/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.interceptors;

import com.sap.engine.lib.security.BasicPasswordCallbackHandler;
import com.sap.engine.lib.security.CSI.CSICallbackHandler;
import com.sap.engine.lib.security.CSI.CSICertificateChain;
import com.sap.engine.lib.security.CSI.CSIDistinguishedName;
import com.sap.engine.lib.security.CSI.CSIPrincipalName;
import com.sap.engine.services.iiop.csiv2.CSI.CompleteEstablishContext;
import com.sap.engine.services.iiop.csiv2.CSI.ContextError;
import com.sap.engine.services.iiop.csiv2.CSI.EstablishContext;
import com.sap.engine.services.iiop.csiv2.CSI.GSS_NT_ExportedNameHelper;
import com.sap.engine.services.iiop.csiv2.CSI.IdentityToken;
import com.sap.engine.services.iiop.csiv2.CSI.SASContextBody;
import com.sap.engine.services.iiop.csiv2.CSI.SASContextBodyHelper;
import com.sap.engine.services.iiop.csiv2.CSI.X501DistinguishedNameHelper;
import com.sap.engine.services.iiop.csiv2.CSI.X509CertificateChainHelper;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUPName;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUPToken;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUtils;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.CorbaServiceFrame;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class SecurityServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private LoginContext loginContext = null;
    private ORB orb = null;
    private Codec codec = null;
    private static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final int INVALID_MECHANISM_MAJOR = 2;
    private static final int INVALID_MECHANISM_MINOR = 1;
    private static final boolean NO_REPLACE = false;
    private static final int MessageInContextMinor = 4;
    public static final int STATUS_PASSED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_RETRY = 2;
    private Hashtable threadcontext = new Hashtable();

    public SecurityServerRequestInterceptor(ORB orb, Codec codec) {
        this.orb = orb;
        this.codec = codec;
    }

    public String name() {
        return "security_server";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo sri) {
    }

    public void receive_request(ServerRequestInfo ri) {
        ServiceContext sc = null;
        int status = 0;
        try {
            sc = ri.get_request_service_context(15);
        }
        catch (BAD_PARAM e) {
            if (((SystemException)((Object)e)).minor != 1330446362) {
                SASContextBody sasctxbody = this.createContextError(2, 1);
                sc = this.createSvcContext(sasctxbody);
                this.threadcontext.put(Thread.currentThread(), sc);
                throw new NO_PERMISSION(e.toString());
            }
            return;
        }
        Any SasAny = this.orb.create_any();
        try {
            SasAny = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            throw new SecurityException("CDR Decoding error for SAS context element.");
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract(SasAny);
        short sasdiscr = sasctxbody.discriminator();
        if (sasdiscr == 5) {
            sasctxbody = this.createContextError(4);
            sc = this.createSvcContext(sasctxbody);
            this.threadcontext.put(Thread.currentThread(), sc);
            throw new NO_PERMISSION();
        }
        if (sasdiscr != 0) {
            throw new SecurityException("Received message not an EstablishContext message.");
        }
        EstablishContext ec = sasctxbody.establish_msg();
        boolean authenticated = false;
        try {
            if (ec.client_authentication_token.length != 0) {
                this.loginAuthenticationCredential(ec.client_authentication_token);
                authenticated = true;
            }
        }
        catch (Exception e) {
            throw new SecurityException("Error while creating a JAAS subject credential.");
        }
        try {
            if (!authenticated && ec.identity_token != null) {
                this.loginIdentityCredential(ec.identity_token);
            }
        }
        catch (SecurityException secex) {
            sasctxbody = this.createContextError(2, 1);
            sc = this.createSvcContext(sasctxbody);
            this.threadcontext.put(Thread.currentThread(), sc);
            throw new NO_PERMISSION(secex.toString());
        }
        catch (Exception e) {
            throw new SecurityException("Error while creating a JAAS subject credential.");
        }
        if (status == 1) {
            sasctxbody = this.createContextError(status);
            sc = this.createSvcContext(sasctxbody);
            this.threadcontext.put(Thread.currentThread(), sc);
            throw new NO_PERMISSION();
        }
        sasctxbody = this.createCompleteEstablishContext(status);
        sc = this.createSvcContext(sasctxbody);
        this.threadcontext.put(Thread.currentThread(), sc);
    }

    public void send_reply(ServerRequestInfo sri) {
        ServiceContext sc = (ServiceContext)this.threadcontext.remove(Thread.currentThread());
        if (sc == null) {
            return;
        }
        sri.add_reply_service_context(sc, false);
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException l_ex) {
            Logger.traceDebug("SecurityServerRequestInterceptor.send_reply(ServerRequestInfo)", Logger.exceptionTrace(l_ex));
            return;
        }
    }

    public void send_exception(ServerRequestInfo sri) {
        ServiceContext sc = (ServiceContext)this.threadcontext.remove(Thread.currentThread());
        if (sc == null) {
            return;
        }
        sri.add_reply_service_context(sc, false);
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException l_ex) {
            Logger.traceDebug("SecurityServerRequestInterceptor.send_exception(ServerRequestInfo)", Logger.exceptionTrace(l_ex));
            return;
        }
    }

    public void send_other(ServerRequestInfo sri) {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException l_ex) {
            Logger.traceDebug("SecurityServerRequestInterceptor.send_other(ServerRequestInfo)", Logger.exceptionTrace(l_ex));
            return;
        }
    }

    private ServiceContext createSvcContext(SASContextBody sasctxtbody) {
        ServiceContext sc = null;
        Any a = this.orb.create_any();
        SASContextBodyHelper.insert(a, sasctxtbody);
        byte[] cdr_encoded_saselm = new byte[]{};
        try {
            cdr_encoded_saselm = this.codec.encode_value(a);
        }
        catch (Exception e) {
            cdr_encoded_saselm = null;
        }
        sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        return sc;
    }

    private SASContextBody createContextError(int status) {
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, 1, status, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createContextError(int major, int minor) {
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, major, minor, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createCompleteEstablishContext(int status) {
        byte[] final_context_token = new byte[]{};
        CompleteEstablishContext cec = new CompleteEstablishContext(0L, false, final_context_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.complete_msg(cec);
        return sasctxtbody;
    }

    private void loginAuthenticationCredential(byte[] token) throws LoginException {
        GSSUPToken gsstoken = new GSSUPToken(this.orb, this.codec, token);
        PasswordCredential passCredential = gsstoken.getPwdcred();
        BasicPasswordCallbackHandler callbackHandler = new BasicPasswordCallbackHandler(passCredential.getUserName(), new String(passCredential.getPassword()));
        this.loginContext = CorbaServiceFrame.getSecurityBasicContext().getAuthenticationContext().getLoginContext(new Subject(), callbackHandler);
        this.loginContext.login();
    }

    private void loginIdentityCredential(IdentityToken idtok) throws Exception {
        CSICallbackHandler callbackHandler = null;
        switch (idtok.discriminator()) {
            case 0: 
            case 1: {
                return;
            }
            case 8: {
                Any any = this.codec.decode_value(idtok.dn(), X501DistinguishedNameHelper.type());
                byte[] derenc = X501DistinguishedNameHelper.extract(any);
                X500Name name = new X500Name(derenc);
                callbackHandler = new CSICallbackHandler(new CSIDistinguishedName(name));
                this.loginContext = CorbaServiceFrame.getSecurityIIOPContext().getAuthenticationContext().getLoginContext(new Subject(), callbackHandler);
                break;
            }
            case 4: {
                Any any = this.codec.decode_value(idtok.certificate_chain(), X509CertificateChainHelper.type());
                byte[] derenc = X509CertificateChainHelper.extract(any);
                DerInputStream din = new DerInputStream(derenc);
                DerValue[] derval = din.getSequence(1);
                X509Certificate[] certchain = new X509Certificate[derval.length];
                int i = 0;
                while (i < certchain.length) {
                    certchain[i] = new X509CertImpl(derval[i]);
                    ++i;
                }
                callbackHandler = new CSICallbackHandler(new CSICertificateChain(certchain));
                this.loginContext = CorbaServiceFrame.getSecurityIIOPContext().getAuthenticationContext().getLoginContext(new Subject(), callbackHandler);
                break;
            }
            case 2: {
                Any any = this.codec.decode_value(idtok.principal_name(), GSS_NT_ExportedNameHelper.type());
                byte[] expname = GSS_NT_ExportedNameHelper.extract(any);
                if (!GSSUtils.verifyMechOID(GSSUtils.GSSUP_MECH_OID, expname)) {
                    throw new SecurityException("Unknown identity assertion type.");
                }
                GSSUPName gssname = new GSSUPName(expname);
                callbackHandler = new CSICallbackHandler(new CSIPrincipalName(gssname.getUser()));
                this.loginContext = CorbaServiceFrame.getSecurityIIOPContext().getAuthenticationContext().getLoginContext(new Subject(), callbackHandler);
                break;
            }
            default: {
                return;
            }
        }
        this.loginContext.login();
    }
}

