/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.interceptors;

import com.sap.engine.services.iiop.csiv2.CSIIOP.SSL;
import com.sap.engine.services.iiop.csiv2.CSIIOP.SSLHelper;
import com.sap.engine.services.iiop.internal.ClientORB;
import com.sap.engine.services.iiop.internal.portable.IIOPOutputStream;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class IORInitializer
extends LocalObject
implements ORBInitializer,
IORInterceptor {
    public static final String NONE = "none";
    public static final String SUPPORTED = "supported";
    public static final String REQUIRED = "required";
    public static int sslport = 0;
    public static String integrity = "required";
    public static String confidentiality = "required";
    public static String establishTrustInTarget = "required";
    public static String establishTrustInClient = "required";
    private ORB orb = null;
    private int target_supports;
    private int target_requires;

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        this.target_supports = this.getTargetSupports();
        this.target_requires = this.getTargetRequires();
        try {
            sslport = ClientORB.communicationLayer.openSSLServerSocket(sslport);
            info.add_ior_interceptor((IORInterceptor)this);
        }
        catch (DuplicateName e) {
            throw new INTERNAL(0, CompletionStatus.COMPLETED_NO);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            throw new INTERNAL("Can't open ssl server socket : " + ioex.getMessage());
        }
    }

    public void establish_components(IORInfo info) {
        IIOPOutputStream out = new IIOPOutputStream((com.sap.engine.services.iiop.CORBA.ORB)this.orb);
        out.setEndian(false);
        out.write_boolean(false);
        SSL sslComp = new SSL(sslport, (short)this.target_requires, (short)this.target_supports);
        SSLHelper.write((OutputStream)out, sslComp);
        info.add_ior_component_to_profile(new TaggedComponent(20, out.toByteArray()), 0);
    }

    public void destroy() {
    }

    public String name() {
        return "ssl_ior";
    }

    public int getTargetSupports() {
        int supports = 0;
        if (!integrity.equals(NONE)) {
            supports |= 2;
        }
        if (!confidentiality.equals(NONE)) {
            supports |= 4;
        }
        if (!establishTrustInTarget.equals(NONE)) {
            supports |= 0x20;
        }
        if (!establishTrustInClient.equals(NONE)) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires() {
        int requires = 0;
        if (integrity.equals(REQUIRED)) {
            requires |= 2;
        }
        if (confidentiality.equals(REQUIRED)) {
            requires |= 4;
        }
        if (establishTrustInTarget.equals(REQUIRED)) {
            requires |= 0x20;
        }
        if (establishTrustInClient.equals(REQUIRED)) {
            requires |= 0x40;
        }
        return requires;
    }
}

