/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.interceptors;

import com.sap.engine.interfaces.csiv2.AS_ContextSec;
import com.sap.engine.interfaces.csiv2.SAS_ContextSec;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.Profile;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.DelegateImpl;
import com.sap.engine.services.iiop.csiv2.CSI.AuthorizationElement;
import com.sap.engine.services.iiop.csiv2.CSI.EstablishContext;
import com.sap.engine.services.iiop.csiv2.CSI.GSS_NT_ExportedNameHelper;
import com.sap.engine.services.iiop.csiv2.CSI.IdentityToken;
import com.sap.engine.services.iiop.csiv2.CSI.SASContextBody;
import com.sap.engine.services.iiop.csiv2.CSI.SASContextBodyHelper;
import com.sap.engine.services.iiop.csiv2.CSI.X509CertificateChainHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMech;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMechListHelper;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUPName;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUPToken;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public abstract class ClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private ORB orb = null;
    private Codec codec = null;
    private static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    public static final int STATUS_PASSED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_RETRY = 2;
    private static final String DEFAULT_REALM = "default";
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;
    static /* synthetic */ Class array$Ljava$security$cert$X509Certificate;
    static /* synthetic */ Class class$com$sap$engine$lib$security$Principal;

    public ClientInterceptor(ORB orb, Codec codec) {
        this.orb = orb;
        this.codec = codec;
    }

    public String name() {
        return "security_client";
    }

    public void send_request(ClientRequestInfo cri) {
        long cContextId = 0L;
        AuthorizationElement[] cAuthzElem = new AuthorizationElement[]{};
        IdentityToken cIdentityToken = null;
        byte[] cAuthenticationToken = new byte[]{};
        byte[] cdr_encoded_saselm = new byte[]{};
        IOR ior = null;
        Object effective_target = cri.effective_target();
        ObjectImpl oimpl = (ObjectImpl)effective_target;
        DelegateImpl delegate = (DelegateImpl)oimpl._get_delegate();
        ior = delegate.getIOR();
        Profile profile = ior.getProfile();
        SimpleProfileInterface[] components = profile.getComponents();
        SimpleProfileInterface tagged = null;
        int i = 0;
        while (i < components.length) {
            if (components[i].getTag() == 33) {
                tagged = components[i];
                break;
            }
            ++i;
        }
        if (tagged == null) {
            return;
        }
        CompoundSecMech mechanism = this.getCompoundSecurityMechanism(tagged);
        if (mechanism == null) {
            return;
        }
        AS_ContextSec asContext = mechanism.as_context_mech;
        SAS_ContextSec sasContext = mechanism.sas_context_mech;
        Subject securityContext = null;
        try {
            securityContext = this.getCurrentSecurityContext().getSession().getSubject();
        }
        catch (Exception e) {
            // empty catch block
        }
        cAuthenticationToken = this.createAuthenticationToken(securityContext, asContext);
        cIdentityToken = this.createIdentityToken(securityContext, sasContext, mechanism.transport_mech);
        EstablishContext ec = new EstablishContext(cContextId, cAuthzElem, cIdentityToken, cAuthenticationToken);
        SASContextBody sasctxbody = new SASContextBody();
        sasctxbody.establish_msg(ec);
        Any SasAny = this.orb.create_any();
        SASContextBodyHelper.insert(SasAny, sasctxbody);
        try {
            cdr_encoded_saselm = this.codec.encode_value(SasAny);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        ServiceContext sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        boolean no_replace = false;
        cri.add_request_service_context(sc, no_replace);
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo cri) {
    }

    public void receive_reply(ClientRequestInfo cri) {
        ServiceContext sc = null;
        try {
            sc = cri.get_reply_service_context(15);
        }
        catch (BAD_PARAM bp_ex) {
            if (((SystemException)((java.lang.Object)bp_ex)).minor != 1330446362) {
                throw bp_ex;
            }
            return;
        }
        Any a = this.orb.create_any();
        try {
            a = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract(a);
        short sasdiscr = sasctxbody.discriminator();
        if (sasdiscr != 1 && sasdiscr != 4) {
            throw new SecurityException("Reply message not one of CompleteEstablishContext or ContextError.");
        }
        int st = this.mapreplyStatus(cri.reply_status());
        this.setreplyStatus(st, cri.effective_target());
    }

    public void receive_exception(ClientRequestInfo cri) {
    }

    public void receive_other(ClientRequestInfo cri) {
    }

    private byte[] createAuthenticationToken(Subject subject, AS_ContextSec asContext) {
        boolean establishTrustInClient = this.isSet(asContext.target_supports, 64);
        boolean anonimous = subject == null || this.getCurrentSecurityContext().getSession().getAuthenticationConfiguration() == null;
        byte[] gsstoken = new byte[]{};
        if (establishTrustInClient && !anonimous) {
            PasswordCredential pwdcred = null;
            try {
                pwdcred = (PasswordCredential)subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = ClientInterceptor.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential).iterator().next();
            }
            catch (Exception ex) {
                pwdcred = null;
            }
            if (pwdcred == null) {
                return gsstoken;
            }
            GSSUPToken tok = new GSSUPToken(this.orb, asContext, this.codec, pwdcred);
            try {
                gsstoken = tok.getGSSToken();
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        }
        return gsstoken;
    }

    protected IdentityToken createIdentityToken(Subject subject, SAS_ContextSec sasContext, SimpleProfileInterface transport) {
        boolean identityAssertion = this.isSet(sasContext.target_supports, 1024);
        IdentityToken idtok = new IdentityToken();
        if (identityAssertion) {
            DerOutputStream dos = new DerOutputStream();
            DerValue[] derval = new DerValue[]{};
            Any any = this.orb.create_any();
            X509Certificate[] certchain = null;
            try {
                certchain = (X509Certificate[])subject.getPublicCredentials(array$Ljava$security$cert$X509Certificate == null ? (array$Ljava$security$cert$X509Certificate = ClientInterceptor.class$("[Ljava.security.cert.X509Certificate;")) : array$Ljava$security$cert$X509Certificate).iterator().next();
            }
            catch (Exception e) {
                certchain = null;
            }
            if (certchain != null) {
                try {
                    derval = new DerValue[certchain.length];
                    int i = 0;
                    while (i < certchain.length) {
                        derval[i] = new DerValue(certchain[i].getEncoded());
                        ++i;
                    }
                    dos.putSequence(derval);
                    X509CertificateChainHelper.insert(any, dos.toByteArray());
                    idtok.certificate_chain(this.codec.encode_value(any));
                    return idtok;
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage());
                }
            }
            if (subject == null || this.getCurrentSecurityContext().getSession().getAuthenticationConfiguration() == null) {
                idtok.anonymous(true);
                return idtok;
            }
            Principal principal = null;
            try {
                principal = (Principal)subject.getPrincipals(class$com$sap$engine$lib$security$Principal == null ? (class$com$sap$engine$lib$security$Principal = ClientInterceptor.class$("com.sap.engine.lib.security.Principal")) : class$com$sap$engine$lib$security$Principal).iterator().next();
            }
            catch (Exception e) {
                principal = null;
            }
            if (principal != null) {
                GSSUPName gssname = new GSSUPName(principal.getName(), DEFAULT_REALM);
                byte[] expname = gssname.getExportedName();
                GSS_NT_ExportedNameHelper.insert(any, expname);
                try {
                    idtok.principal_name(this.codec.encode_value(any));
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage());
                }
            }
        } else {
            idtok.absent(true);
        }
        return idtok;
    }

    private int mapreplyStatus(int repst) {
        int status;
        switch (repst) {
            case 0: 
            case 2: {
                status = 0;
                break;
            }
            case 3: 
            case 4: {
                status = 2;
                break;
            }
            case 1: {
                status = 1;
                break;
            }
            default: {
                status = repst;
            }
        }
        return status;
    }

    private void setreplyStatus(int status, Object target) {
        if (status == 1) {
            throw new SecurityException("Target did not accept security context");
        }
        if (status == 2) {
            // empty if block
        }
    }

    private CompoundSecMech getCompoundSecurityMechanism(SimpleProfileInterface tagged) {
        byte[] taggedData = tagged.getData();
        CORBAInputStream stream = new CORBAInputStream(taggedData);
        CompoundSecMech[] list = CompoundSecMechListHelper.read((InputStream)stream).mechanism_list;
        if (list == null || list.length == 0) {
            return null;
        }
        return list[0];
    }

    private boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    protected abstract SecurityContextObject getCurrentSecurityContext();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

