/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.GSSUP;

import com.sap.engine.interfaces.csiv2.AS_ContextSec;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUtils;
import com.sap.engine.services.iiop.csiv2.GSSUP.InitialContextToken;
import com.sap.engine.services.iiop.csiv2.GSSUP.InitialContextTokenHelper;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.resource.spi.security.PasswordCredential;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

public class GSSUPToken {
    public static final String DELIMITER = "@";
    private static boolean debug = true;
    private byte[] cdr_encoded_token = new byte[0];
    PasswordCredential pwdcred = null;

    public GSSUPToken(ORB orb, AS_ContextSec asContext, Codec codec, PasswordCredential pwdcred) {
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        try {
            name_utf8 = pwdcred.getUserName().getBytes("UTF8");
            password_utf8 = new String(pwdcred.getPassword()).getBytes("UTF8");
        }
        catch (Exception e) {
            Logger.traceError("GSSUPToken(ORB, AS_ContextSec, Codec, PasswordCredential)", Logger.exceptionTrace(e));
        }
        Object mech = null;
        byte[] target_name = asContext.target_name;
        InitialContextToken inctxToken = new InitialContextToken(name_utf8, password_utf8, target_name);
        Any a = orb.create_any();
        InitialContextTokenHelper.insert(a, inctxToken);
        try {
            this.cdr_encoded_token = codec.encode_value(a);
        }
        catch (Exception e) {
            Logger.traceError("GSSUPToken(ORB, AS_ContextSec, Codec, PasswordCredential)", Logger.exceptionTrace(e));
        }
    }

    public GSSUPToken(ORB orb, Codec codec, byte[] authtok) throws SecurityException {
        String name;
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        byte[] target_name = new byte[]{};
        String username = "";
        String userpwd = "";
        String realm = "";
        byte[] encoded_token = new byte[]{};
        encoded_token = GSSUtils.getMechToken(GSSUtils.GSSUP_MECH_OID, authtok);
        Any a = orb.create_any();
        try {
            a = codec.decode_value(encoded_token, InitialContextTokenHelper.type());
        }
        catch (Exception e) {
            Logger.traceError("GSSUPToken(ORB, Codec, byte[])", Logger.exceptionTrace(e));
        }
        InitialContextToken inctxToken = InitialContextTokenHelper.extract(a);
        password_utf8 = inctxToken.password;
        name_utf8 = inctxToken.username;
        target_name = inctxToken.target_name;
        try {
            username = new String(name_utf8, "UTF8");
            userpwd = new String(password_utf8, "UTF8");
        }
        catch (Exception e) {
            Logger.traceError("GSSUPToken(ORB, Codec, byte[])", Logger.exceptionTrace(e));
        }
        int index = username.indexOf(DELIMITER);
        if (index == -1) {
            name = username;
        } else {
            if (index == 0) {
                throw new SecurityException("No name_value in username");
            }
            StringTokenizer strtok = new StringTokenizer(username, DELIMITER);
            name = strtok.nextToken();
            if (strtok.hasMoreTokens() && !(realm = strtok.nextToken()).equals("default")) {
                throw new SecurityException("Unknown realm");
            }
        }
        this.pwdcred = new PasswordCredential(name, userpwd.toCharArray());
    }

    public byte[] getGSSToken() throws IOException {
        byte[] gsstoken = GSSUtils.createMechIndToken(GSSUtils.GSSUP_MECH_OID, this.cdr_encoded_token);
        return gsstoken;
    }

    public PasswordCredential getPwdcred() {
        return this.pwdcred;
    }
}

