/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.PortableServer;

import com.sap.engine.services.iiop.PortableServer.POAManagerImpl;
import com.sap.engine.services.iiop.PortableServer.POATreeNode;
import com.sap.engine.services.iiop.PortableServer.ServantHolder;
import com.sap.engine.services.iiop.PortableServer.policy.PolicyState;
import com.sap.engine.services.iiop.PortableServer.policy.impl.IdAssignmentPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.IdUniquenessPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.ImplicitActivationPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.LifespanPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.RequestProcessingPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.ServantRetentionPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.ThreadPolicy;
import com.sap.engine.services.iiop.PortableServer.state.POAState;
import com.sap.engine.services.iiop.PortableServer.state.StateAction;
import com.sap.engine.services.iiop.logging.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;

public class POAImpl
extends POATreeNode {
    private POAManager the_POAManager;
    private AdapterActivator the_Activator;
    private Servant default_servant;
    private ServantManager servantManager;
    private POAState state = new POAState();
    private PolicyState policy;

    POAImpl(ORB orb) {
        super(orb);
        this.policy = new PolicyState(null, this);
        this.the_POAManager = new POAManagerImpl("RootPOA");
    }

    private POAImpl(String name, POA parent, POAManager poaManager, Policy[] policies) throws AdapterAlreadyExists {
        super(name, (POATreeNode)parent);
        this.the_POAManager = poaManager == null ? new POAManagerImpl(name) : poaManager;
        this.policy = new PolicyState(policies, this);
    }

    public POAManager the_POAManager() {
        return this.the_POAManager;
    }

    public AdapterActivator the_activator() {
        return this.the_Activator;
    }

    public void the_activator(AdapterActivator newThe_activator) {
        this.the_Activator = newThe_activator;
    }

    public POA create_POA(String adapter_name, POAManager poaManager, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy {
        return new POAImpl(adapter_name, this, poaManager, policies);
    }

    public POA find_POA(String adapter_name, boolean activate_it) throws AdapterNonExistent {
        POA poa = this.findChild(adapter_name);
        if (poa != null) {
            return poa;
        }
        if (!activate_it || this.the_Activator == null) {
            throw new AdapterNonExistent(adapter_name);
        }
        try {
            if (!this.the_Activator.unknown_adapter((POA)this, adapter_name)) {
                throw new AdapterNonExistent(adapter_name);
            }
            poa = this.find_POA(adapter_name, false);
        }
        catch (SystemException se) {
            throw new OBJ_ADAPTER(se.toString(), 1, se.completed);
        }
        return poa;
    }

    public org.omg.PortableServer.ThreadPolicy create_thread_policy(ThreadPolicyValue value) {
        return new ThreadPolicy(value);
    }

    public org.omg.PortableServer.LifespanPolicy create_lifespan_policy(LifespanPolicyValue value) {
        return new LifespanPolicy(value);
    }

    public org.omg.PortableServer.IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue value) {
        return new IdUniquenessPolicy(value);
    }

    public org.omg.PortableServer.IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue value) {
        return new IdAssignmentPolicy(value);
    }

    public org.omg.PortableServer.ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue value) {
        return new ImplicitActivationPolicy(value);
    }

    public org.omg.PortableServer.ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue value) {
        return new ServantRetentionPolicy(value);
    }

    public org.omg.PortableServer.RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue value) {
        return new RequestProcessingPolicy(value);
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (this.policy.getRequestProcessingPolicyValue() == 2) {
            return this.servantManager;
        }
        throw new WrongPolicy("USE_SERVANT_MANAGER policy is not specified.");
    }

    public void set_servant_manager(ServantManager imgr) throws WrongPolicy {
        if (this.policy.getRequestProcessingPolicyValue() != 2) {
            throw new WrongPolicy("USE_SERVANT_MANAGER policy is not specified.");
        }
        this.servantManager = imgr;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        if (this.policy.getRequestProcessingPolicyValue() == 1) {
            if (this.default_servant != null) {
                return this.default_servant;
            }
            throw new NoServant("Default Servant not Set!");
        }
        throw new WrongPolicy("USE_DEFAULT_SERVANT policy is not specified.");
    }

    public void set_servant(Servant p_servant) throws WrongPolicy {
        if (this.policy.getRequestProcessingPolicyValue() != 1) {
            throw new WrongPolicy("USE_DEFAULT_SERVANT policy is not specified.");
        }
        this.default_servant = p_servant;
    }

    public byte[] activate_object(Servant p_servant) throws ServantAlreadyActive, WrongPolicy {
        if (this.policy.isSystemAssignedIds() && this.policy.isServantRetention()) {
            if (this.policy.isUniqueIds() && this.policy.containServant(p_servant)) {
                throw new ServantAlreadyActive("Servant Already in AOM!");
            }
            byte[] oid = this.policy.generateKey();
            this.policy.putInAOM(oid, p_servant);
            return oid;
        }
        throw new WrongPolicy("RETAIN and SYSTEM_ID policy are not specified.");
    }

    public void activate_object_with_id(byte[] id, Servant p_servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        if (this.policy.isServantRetention()) {
            if (this.policy.containKey(id)) {
                throw new ObjectAlreadyActive("ObjectKey is Already in AOM!");
            }
            if (this.policy.isUniqueIds() && this.policy.containServant(p_servant)) {
                throw new ServantAlreadyActive("Servant Already in AOM!");
            }
            if (this.policy.isSystemAssignedIds() && !this.policy.validateID(id)) {
                throw new BAD_PARAM("Invalid ObjectId", 14, CompletionStatus.from_int((int)1));
            }
        } else {
            throw new WrongPolicy("RETAIN policy is not specified.");
        }
        this.policy.putInAOM(id, p_servant);
    }

    public void deactivate_object(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.policy.isServantRetention()) {
            if (!this.policy.containKey(oid)) {
                throw new ObjectNotActive();
            }
        } else {
            throw new WrongPolicy("RETAIN policy is not specified.");
        }
        Servant s = this.policy.locateServant(oid);
        this.policy.removeFromAOM(oid);
        this.orb().disconnect(s._get_delegate().this_object(s));
    }

    public Object create_reference(String intf) throws WrongPolicy {
        if (!this.policy.isSystemAssignedIds()) {
            throw new WrongPolicy("SYSTEM_ID policy is not specified.");
        }
        ServantHolder sh = this.policy.getServantHolder(null, intf);
        this.orb().connect((Object)sh);
        return sh;
    }

    public Object create_reference_with_id(byte[] oid, String intf) {
        if (this.policy.isSystemAssignedIds() && !this.policy.validateID(oid)) {
            throw new BAD_PARAM("Invalid ObjectId", 14, CompletionStatus.from_int((int)1));
        }
        if (this.policy.containKey(oid)) {
            ServantHolder sh = this.policy.getServantHolder(oid, intf);
            return sh;
        }
        return null;
    }

    public byte[] servant_to_id(Servant p_servant) throws ServantNotActive, WrongPolicy {
        if (this.policy.useDefaultServant()) {
            return null;
        }
        if (this.policy.isServantRetention()) {
            if (this.policy.isUniqueIds() && this.policy.containServant(p_servant)) {
                byte[] oid = this.policy.servantToKey(p_servant);
                if (oid != null) {
                    return oid;
                }
                throw new ServantNotActive("Servant is not found in ActiveObjectMap!");
            }
            if (this.policy.isImplicitlyActivated()) {
                if (!this.policy.containServant(p_servant) || !this.policy.isUniqueIds()) {
                    byte[] oid = this.policy.generateKey();
                    return oid;
                }
                throw new ServantNotActive("Servant is not found in ActiveObjectMap!");
            }
            throw new WrongPolicy("RETAIN policy is specified but either UNIQUIE_ID nor IMPLICIT_ACTIVATION is specified!");
        }
        throw new WrongPolicy("RETAIN or USE_DEFAULT_SERVANT policy is not specified.");
    }

    public Object servant_to_reference(Servant p_servant) throws ServantNotActive, WrongPolicy {
        if (this.policy.isServantRetention()) {
            if (this.policy.isUniqueIds()) {
                if (this.policy.containServant(p_servant)) {
                    byte[] oid = this.policy.servantToKey(p_servant);
                    if (oid != null) {
                        String[] rep_ids = p_servant._all_interfaces((POA)this, oid);
                        ServantHolder sh = this.policy.getServantHolder(null, rep_ids[0]);
                        this.orb().connect((Object)sh);
                        return sh;
                    }
                    throw new ServantNotActive("Servant is not found in ActiveObjectMap!");
                }
                byte[] oid = this.policy.generateKey();
                this.policy.putInAOM(oid, p_servant);
                String[] rep_ids = p_servant._all_interfaces((POA)this, oid);
                ServantHolder sh = this.policy.getServantHolder(null, rep_ids[0]);
                this.orb().connect((Object)sh);
                return sh;
            }
            if (this.policy.isImplicitlyActivated()) {
                if (!this.policy.containServant(p_servant) || this.policy.isUniqueIds()) {
                    byte[] oid = this.policy.generateKey();
                    this.policy.putInAOM(oid, p_servant);
                    String[] rep_ids = p_servant._all_interfaces((POA)this, oid);
                    ServantHolder sh = this.policy.getServantHolder(null, rep_ids[0]);
                    this.orb().connect((Object)sh);
                    return sh;
                }
                throw new ServantNotActive("Servant is not found in ActiveObjectMap!");
            }
            throw new WrongPolicy("RETAIN Policy is set but either UNIQUIE_ID nor IMPLICIT_ACTIVATION is set!");
        }
        throw new WrongPolicy("RETAIN policy is not specified.");
    }

    public Servant reference_to_servant(Object reference) throws ObjectNotActive, WrongPolicy, WrongAdapter {
        if (this.policy.isServantRetention()) {
            try {
                return ((ServantHolder)reference).locateServant();
            }
            catch (Exception ex) {
                throw new ObjectNotActive("Servant is not found in ActiveObjectMap!");
            }
        }
        if (this.policy.useDefaultServant()) {
            return this.default_servant;
        }
        throw new WrongPolicy("RETAIN or USE_DEFAULT_SERVANT policy are not specified.");
    }

    public byte[] reference_to_id(Object reference) throws WrongAdapter, WrongPolicy {
        try {
            Servant s = this.reference_to_servant(reference);
            try {
                return this.servant_to_id(s);
            }
            catch (ServantNotActive servantNotActive) {
                Logger.traceDebug("POAImpl(Object)", Logger.exceptionTrace(servantNotActive));
                return ((ServantHolder)reference).oid;
            }
        }
        catch (ObjectNotActive objectNotActive) {
            Logger.traceDebug("POAImpl(Object)", Logger.exceptionTrace(objectNotActive));
            return ((ServantHolder)reference).oid;
        }
    }

    public Servant id_to_servant(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.policy.isServantRetention()) {
            if (this.policy.containKey(oid)) {
                return this.policy.locateServant(oid);
            }
            throw new ObjectNotActive("Object not Activated");
        }
        if (!this.policy.useDefaultServant()) {
            throw new WrongPolicy("RETAIN or USE_DEFAULT_SERVANT policy are not specified.");
        }
        return null;
    }

    public Object id_to_reference(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.policy.isServantRetention()) {
            if (this.policy.containKey(oid)) {
                Servant s = this.policy.locateServant(oid);
                String[] rep_ids = s._all_interfaces((POA)this, oid);
                ServantHolder sh = this.policy.getServantHolder(null, rep_ids[0]);
                this.orb().connect((Object)sh);
                return sh;
            }
            throw new ObjectNotActive("Object not Activated");
        }
        throw new WrongPolicy("Needed RETAIN or USE_DEFAULT_SERVANT policy not set!");
    }

    public byte[] id() {
        return new byte[0];
    }

    void setManager(POAManager pm) {
        this.the_POAManager = pm;
    }

    public StateAction get_state() {
        return this.state.getCurrentState(this.the_POAManager.get_state().value());
    }

    public PolicyState getPolicyObject() {
        return this.policy;
    }
}

