/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA.portable;

import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.TypeCodeImpl;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.DelegateImpl;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Stack;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.OutputStream;

public class CORBAOutputStream
extends OutputStream {
    protected int index;
    protected byte[] data;
    private int offset = 0;
    protected boolean littleEndian;
    protected int endTag = 0;
    protected boolean inBlock = false;
    protected int startBlockIndex = -1;
    protected static final int VALUE_NO_CODEBASE = 0;
    protected static final int VALUE_CODEBASE = 1;
    protected static final int VALUE_NO_TYPE_INFORMATION = 0;
    protected static final int SINGLE_TYPE_INFORMATION = 2;
    protected static final int MULTIPLE_TYPE_INFORMATION = 6;
    protected static final int CHUNK = 8;
    protected static final int NO_CHUNK = 0;
    static final int DEFAULT_SIZE = 1024;
    protected ORB orb;
    public int exType = 0;
    private boolean isEncapsulated = false;
    private int minorVersion = 0;
    private int end_contexts_index = 0;
    private Stack encapsulationStack;

    public CORBAOutputStream() {
        this.data = new byte[1024];
        this.index = 0;
        this.littleEndian = false;
    }

    public CORBAOutputStream(int size) {
        this.data = new byte[size];
        this.index = 0;
        this.littleEndian = false;
    }

    public CORBAOutputStream(ORB orb0) {
        this();
        this.orb = orb0;
    }

    public CORBAOutputStream(ORB orb0, int size) {
        this(size);
        this.orb = orb0;
    }

    public CORBAOutputStream(ORB orb, byte[] data0) {
        this(orb);
        this.write_octet_array(data0, 0, data0.length);
    }

    public void set_encapsulation() {
        this.isEncapsulated = true;
    }

    public void set_minor_version(int version) {
        this.minorVersion = version;
    }

    public void makeGIOPHeader(byte type) {
        this.data[0] = 71;
        this.data[1] = 73;
        this.data[2] = 79;
        this.data[3] = 80;
        this.data[4] = 1;
        this.data[5] = 1;
        this.data[6] = 0;
        this.data[7] = type;
        this.index = 12;
    }

    public void prepareGIOPHeader(byte type, byte major, byte minor) {
        this.data[0] = 71;
        this.data[1] = 73;
        this.data[2] = 79;
        this.data[3] = 80;
        this.data[4] = major;
        this.data[5] = minor;
        this.data[6] = this.littleEndian ? (byte)1 : 0;
        this.data[7] = type;
        this.index = 12;
    }

    public byte[] toByteArray() {
        byte[] temp = new byte[this.index];
        System.arraycopy(this.data, 0, temp, 0, this.index);
        return temp;
    }

    public byte[] toByteArray_forSend() {
        return this.data;
    }

    public int byteArray_forSend_length() {
        return this.index;
    }

    public byte[] toGIOPFormat() {
        int size = this.index;
        this.index = 8;
        this.write_long(size - 12);
        this.index = size;
        return this.toByteArray_forSend();
    }

    public void setEndian(boolean b) {
        this.littleEndian = b;
    }

    public boolean getEndian() {
        return this.littleEndian;
    }

    public void setByte(int idx, byte b) throws IndexOutOfBoundsException {
        if (idx > this.data.length || idx > this.index) {
            String messageWithId = "CORBAOutputStream::setByte - index out of bounds ";
            Logger.traceError("CORBAOutputStream.setByte(int, byte)", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        this.data[idx] = b;
    }

    protected void align(int length) {
        int cnt = this.index - 1 + length + this.offset & ~(length - 1);
        this.index = cnt - this.offset;
        if (cnt + length < this.data.length) {
            return;
        }
        this.resizeStream();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int i) {
        this.offset = i;
    }

    public int getPos() {
        return this.index + this.offset;
    }

    public void writeRepositoryId(String repositoryIDstr) {
        byte[] repositoryID = repositoryIDstr.getBytes();
        if (repositoryID == null) {
            String messageWithId = "ID010037: Error in writing string, which is null.";
            Logger.traceError("CORBAOutputStream.writeRepositoryId(String)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        this.write_long(repositoryID.length + 1);
        if (this.index + repositoryID.length <= this.data.length) {
            System.arraycopy(repositoryID, 0, this.data, this.index, repositoryID.length);
            this.index += repositoryID.length;
        } else {
            this.resizeStream();
            System.arraycopy(repositoryID, 0, this.data, this.index, repositoryID.length);
            this.index += repositoryID.length;
        }
        this.write_octet((byte)0);
    }

    public void writeValueTag(boolean chunk, String url) {
        int tag = 0x7FFFFF00;
        tag = url == null ? (tag += 0) : ++tag;
        tag += 2;
        tag = chunk ? (tag += 8) : (tag += 0);
        this.write_long(tag);
    }

    protected void startBlock() {
        this.write_long(0);
        this.startBlockIndex = this.index;
        this.inBlock = true;
    }

    protected void endBlock() {
        if (!this.inBlock) {
            return;
        }
        if (this.index == this.startBlockIndex) {
            this.index = this.startBlockIndex - 4;
            this.startBlockIndex = -1;
        } else {
            int i = this.index;
            this.index = this.startBlockIndex - 4;
            this.write_long(i - this.startBlockIndex);
            this.index = i;
        }
        this.inBlock = false;
    }

    protected void writeEndTag(boolean flag) {
        if (flag) {
            this.write_long(this.endTag);
        }
        ++this.endTag;
    }

    public void setException(int exType) {
        this.exType = exType;
    }

    public void write(byte[] b) throws IOException {
    }

    public void write(byte[] b, int offset, int len) throws IOException {
    }

    public void write(int b) throws IOException {
    }

    public InputStream create_input_stream() {
        return new CORBAInputStream(this.orb, this.data, this.littleEndian);
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public void write_boolean(boolean b) {
        this.write_octet(b ? (byte)1 : 0);
    }

    public void write_boolean_array(boolean[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_boolean(arr[off + i]);
            ++i;
        }
    }

    public void unaligned_write_octet(byte b) {
        this.data[this.index++] = b;
    }

    public void write_octet(byte b) {
        this.align(1);
        this.data[this.index++] = b;
    }

    public void write_octet_array(byte[] arr, int off, int len) {
        int n = off;
        while (n < len + off) {
            this.align(1);
            int avail = this.data.length - this.index;
            int wanted = len + off - n;
            int bytes = wanted < avail ? wanted : avail;
            System.arraycopy(arr, n, this.data, this.index, bytes);
            this.index += bytes;
            n += bytes;
        }
    }

    public void unaligned_write_char(char c) {
        this.data[this.index++] = (byte)(c >>> 0 & 0xFF);
    }

    public void write_char(char c) {
        this.align(1);
        this.data[this.index++] = (byte)(c >>> 0 & 0xFF);
    }

    public void write_char_array(char[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_char(arr[off + i]);
            ++i;
        }
    }

    public void write_short(short s) {
        this.align(2);
        if (this.littleEndian) {
            this.data[this.index++] = (byte)(s >>> 0 & 0xFF);
            this.data[this.index++] = (byte)(s >>> 8 & 0xFF);
        } else {
            this.data[this.index++] = (byte)(s >>> 8 & 0xFF);
            this.data[this.index++] = (byte)(s >>> 0 & 0xFF);
        }
    }

    public void write_short_array(short[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_short(arr[off + i]);
            ++i;
        }
    }

    public void write_ushort(short i) {
        this.write_short(i);
    }

    public void write_ushort_array(short[] arr, int off, int len) {
        this.write_short_array(arr, off, len);
    }

    public void write_long(int i) {
        this.align(4);
        if (this.littleEndian) {
            this.data[this.index++] = (byte)(i >>> 0 & 0xFF);
            this.data[this.index++] = (byte)(i >>> 8 & 0xFF);
            this.data[this.index++] = (byte)(i >>> 16 & 0xFF);
            this.data[this.index++] = (byte)(i >>> 24 & 0xFF);
        } else {
            this.data[this.index++] = (byte)(i >>> 24 & 0xFF);
            this.data[this.index++] = (byte)(i >>> 16 & 0xFF);
            this.data[this.index++] = (byte)(i >>> 8 & 0xFF);
            this.data[this.index++] = (byte)(i >>> 0 & 0xFF);
        }
    }

    public void write_long_array(int[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_long(arr[off + i]);
            ++i;
        }
    }

    public void write_ulong(int i) {
        this.write_long(i);
    }

    public void write_ulong_array(int[] arr, int off, int len) {
        this.write_long_array(arr, off, len);
    }

    public void write_longlong(long l) {
        this.align(8);
        if (this.littleEndian) {
            this.data[this.index++] = (byte)(l >>> 0 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 8 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 16 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 24 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 32 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 40 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 48 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 56 & 0xFFL);
        } else {
            this.data[this.index++] = (byte)(l >>> 56 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 48 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 40 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 32 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 24 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 16 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 8 & 0xFFL);
            this.data[this.index++] = (byte)(l >>> 0 & 0xFFL);
        }
    }

    public void write_longlong_array(long[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_longlong(arr[off + i]);
            ++i;
        }
    }

    public void write_ulonglong(long i) {
        this.write_longlong(i);
    }

    public void write_ulonglong_array(long[] arr, int off, int len) {
        this.write_longlong_array(arr, off, len);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_float_array(float[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_float(arr[off + i]);
            ++i;
        }
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_double_array(double[] arr, int off, int len) {
        int i = 0;
        while (i < len) {
            this.write_double(arr[off + i]);
            ++i;
        }
    }

    public void write_string(String s) throws BAD_PARAM {
        if (s == null) {
            String messageWithId = "ID010037: Error in writing string, which is null.";
            Logger.traceError("CORBAOutputStream.write_string(String)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        int len = s.length();
        this.write_long(len + 1);
        if (this.index + len < this.data.length) {
            int i = 0;
            while (i < len) {
                this.unaligned_write_char(s.charAt(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                this.write_char(s.charAt(i));
                ++i;
            }
        }
        this.write_octet((byte)0);
    }

    public void write_Object(Object o) {
        IOR ior;
        if (o == null) {
            new IOR((org.omg.CORBA.ORB)this.orb, "", null).write_object((org.omg.CORBA.portable.OutputStream)this);
            return;
        }
        try {
            ior = ((DelegateImpl)((ObjectImpl)o)._get_delegate()).getIOR();
        }
        catch (Exception e) {
            this.orb.connect(o);
            ior = ((DelegateImpl)((ObjectImpl)o)._get_delegate()).getIOR();
        }
        ior.write_object((org.omg.CORBA.portable.OutputStream)this, ((ObjectImpl)o)._ids()[0]);
    }

    public void write_TypeCode(TypeCode tc) {
        if (tc == null) {
            String messageWithId = "ID019040: Error in writing type code, which is null.";
            Logger.traceError("CORBAOutputStream.write_TypeCode(TypeCode)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        TypeCodeImpl tci = tc instanceof TypeCodeImpl ? (TypeCodeImpl)tc : new TypeCodeImpl(this.orb, tc);
        tci.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_any(Any any) {
        if (any == null) {
            String messageWithId = "ID010041: Error in writing struct, union or other, which is null.";
            Logger.traceError("CORBAOutputStream.write_any(Any)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_value(Serializable value) {
        if (value == null) {
            Logger.traceWarning("CORBAOutputStream.write_value(Serializable)", "Writing null value.");
            this.write_long(0);
            return;
        }
    }

    public void unaligned_write_wchar(char c) {
        if (this.minorVersion == 2) {
            this.write_octet((byte)2);
        }
        if (this.littleEndian) {
            this.data[this.index++] = (byte)(c & 0xFF);
            this.data[this.index++] = (byte)(c >>> 8 & 0xFF);
        } else {
            this.data[this.index++] = (byte)(c >>> 8 & 0xFF);
            this.data[this.index++] = (byte)(c & 0xFF);
        }
    }

    public void write_wchar(char c) {
        if (this.minorVersion == 2) {
            this.write_octet((byte)2);
        } else {
            this.align(2);
        }
        if (this.littleEndian) {
            this.data[this.index++] = (byte)(c & 0xFF);
            this.data[this.index++] = (byte)(c >>> 8 & 0xFF);
        } else {
            this.data[this.index++] = (byte)(c >>> 8 & 0xFF);
            this.data[this.index++] = (byte)(c & 0xFF);
        }
    }

    public void write_wchar_array(char[] val, int off, int len) {
        if (this.index + len <= this.data.length) {
            this.write_wchar(val[off]);
            int i = off + 1;
            while (i < len) {
                this.unaligned_write_wchar(val[i]);
                ++i;
            }
        } else {
            int i = off;
            while (i < len) {
                this.write_wchar(val[i]);
                ++i;
            }
        }
    }

    public void write_wstring(String s) {
        if (s == null) {
            String messageWithId = "ID010042: WString Null Parameter";
            Logger.traceError("CORBAOutputStream.write_wstring(String)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        int j = s.length() + 1;
        if (this.index + 4 + j * 2 >= this.data.length) {
            this.align(4, 4 + j * 2);
        }
        this.write_long(this.isEncapsulated || this.minorVersion == 2 ? 2 * s.length() : s.length() + 1);
        --j;
        if (this.littleEndian) {
            int k = 0;
            while (k < j) {
                char c = s.charAt(k);
                this.data[this.index++] = (byte)(c & 0xFF);
                this.data[this.index++] = (byte)(c >>> 8 & 0xFF);
                ++k;
            }
        } else {
            int l = 0;
            while (l < j) {
                char c1 = s.charAt(l);
                this.data[this.index++] = (byte)(c1 >>> 8 & 0xFF);
                this.data[this.index++] = (byte)(c1 & 0xFF);
                ++l;
            }
        }
        if (!this.isEncapsulated && this.minorVersion != 2) {
            this.data[this.index++] = 0;
            this.data[this.index++] = 0;
        }
    }

    public void write_Principal(Principal p) {
        String messageWithId = "ID019043: Writing principal is not implemented yet.";
        Logger.traceError("CORBAOutputStream.write_Principal(Principal)", messageWithId);
        throw new NO_IMPLEMENT(messageWithId);
    }

    private void align(int length, int grow) {
        int cnt = this.index - 1 + length + this.offset & ~(length - 1);
        this.index = cnt - this.offset;
        if (cnt + length + grow < this.data.length) {
            return;
        }
        int l = this.data.length * 2;
        while (this.index + grow >= l) {
            l *= 2;
        }
        byte[] temp = new byte[l];
        System.arraycopy(this.data, 0, temp, 0, this.data.length);
        this.data = temp;
    }

    public void setPos(int index) {
        this.index = index;
    }

    public void beginEncapsulation(boolean newEndian) {
        if (this.encapsulationStack == null) {
            this.encapsulationStack = new Stack();
        }
        int lenIndex = this.index;
        this.align(4);
        this.index += 4;
        int start = this.index;
        StackElement se = new StackElement(this.littleEndian, start, lenIndex);
        this.encapsulationStack.push(se);
        this.setEndian(newEndian);
        this.write_boolean(newEndian);
    }

    public int endEncapsulation() {
        StackElement se = (StackElement)this.encapsulationStack.pop();
        int end = this.index;
        int length = this.index - se.start;
        this.setPos(se.lenIndex);
        this.write_long(length);
        this.setPos(end);
        this.setEndian(se.endian);
        return length;
    }

    private void resizeStream() {
        byte[] temp = new byte[this.data.length * 2];
        System.arraycopy(this.data, 0, temp, 0, this.data.length);
        this.data = temp;
    }

    public int getEnd_contexts_index() {
        return this.end_contexts_index;
    }

    public void setEnd_contexts_index(int end_contexts_index) {
        this.end_contexts_index = end_contexts_index;
    }

    private class StackElement {
        public boolean endian;
        public int start;
        public int lenIndex;

        public StackElement(boolean endian, int start, int lenIndex) {
            this.endian = endian;
            this.start = start;
            this.lenIndex = lenIndex;
        }

        public String toString() {
            return "endian: " + this.endian + "   start at: " + this.start + "  length at: " + this.lenIndex;
        }
    }
}

