/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA.portable;

import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.TypeCodeImpl;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.IOException;
import java.util.Stack;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.InputStream;

public class CORBAInputStream
extends InputStream {
    protected byte[] data;
    private int index = 0;
    protected boolean littleEndian = false;
    private int offset = 0;
    protected int endTag = 0;
    protected long endBlockIndex = 0x7FFFFF00L;
    protected boolean isChunked = false;
    private int size = 0;
    protected ORB orb;
    protected boolean isEncapsulated = false;
    protected int minorVersion = 0;
    private int marker = -1;
    boolean check4Chars = true;
    private Stack encapsulationStack;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ObjectImpl;

    public CORBAInputStream(byte[] data) {
        this.size = data.length;
        this.data = data;
    }

    public CORBAInputStream(ORB orb0, byte[] data) {
        this.size = data.length;
        this.data = data;
        this.orb = orb0;
    }

    public CORBAInputStream(ORB orb0, byte[] data, boolean le) {
        this(orb0, data);
        this.littleEndian = le;
    }

    public byte[] getData() {
        return this.data;
    }

    protected int getSize() {
        return this.size;
    }

    protected void setSize(int newSize) {
        this.size = newSize;
    }

    public org.omg.CORBA.ORB getORB() {
        return this.orb;
    }

    public void set_encapsulation() {
        this.isEncapsulated = true;
    }

    public void set_minor_version(int version) {
        this.minorVersion = version;
    }

    public byte[] toByteArray() {
        byte[] temp = new byte[this.size - this.index];
        System.arraycopy(this.data, this.index, temp, 0, this.size - this.index);
        return temp;
    }

    public void setEndian(boolean b) {
        this.littleEndian = b;
    }

    public boolean getEndian() {
        return this.littleEndian;
    }

    public CORBAInputStream dup() {
        return new CORBAInputStream(this.orb, this.data, this.littleEndian);
    }

    public boolean isAvailable() {
        return this.index < this.size;
    }

    public void setOffset(int i) {
        this.offset = i;
    }

    public int getPos() {
        return this.index;
    }

    public void setPos(int index) {
        this.index = index;
    }

    public void reset(int pos) {
        if (pos >= 0 && pos < this.size) {
            this.index = pos;
        }
    }

    protected void align(int i) {
        this.trace("CORBAInputStream.align(int)", "  ALIGN " + this.endBlockIndex + " / " + this.index);
        if (this.endBlockIndex == (long)this.index) {
            this.endBlockIndex = 0x7FFFFF00L;
            this.startBlock();
        } else if (this.endBlockIndex < (long)this.index) {
            throw new MARSHAL("Chunk overflow at offset " + this.index);
        }
        int cnt = this.index - 1 + i + this.offset & ~(i - 1);
        this.index = cnt - this.offset;
    }

    protected void startBlock() {
        this.trace("CORBAInputStream.startBlock()", "START BLOCK: " + this.index);
        this.trace("CORBAInputStream.startBlock()", "  chunked: " + this.isChunked);
        this.trace("CORBAInputStream.startBlock()", "  endBlockIndex: " + this.endBlockIndex);
        if (!this.isChunked || this.endBlockIndex < 0x7FFFFF00L && (long)this.index < this.endBlockIndex) {
            this.trace("CORBAInputStream.startBlock()", "  skip start block... ");
            return;
        }
        this.trace("CORBAInputStream.startBlock()", "  data.length : " + this.data.length);
        if (this.index == this.data.length) {
            this.index -= 4;
            return;
        }
        this.endBlockIndex = 0x7FFFFF00L;
        this.endBlockIndex = this.read_long();
        this.trace("CORBAInputStream.startBlock()", "  new endBlockIndex: " + this.endBlockIndex);
        if (this.endBlockIndex > 0L && this.endBlockIndex < 0x7FFFFF00L) {
            this.endBlockIndex += (long)this.index;
            this.trace("CORBAInputStream.startBlock()", "  endBlockIndex: " + this.endBlockIndex);
        } else {
            this.endBlockIndex = 0x7FFFFF00L;
            this.index -= 4;
            this.trace("CORBAInputStream.startBlock()", "  fix endBlockIndex: " + this.endBlockIndex);
            this.trace("CORBAInputStream.startBlock()", "  index: " + this.index);
        }
        this.trace("CORBAInputStream.startBlock()", "  start chunk index : " + this.index);
    }

    protected void endBlock() {
        this.trace("CORBAInputStream.endBlock()", "END BLOCK: " + this.index);
        this.trace("CORBAInputStream.endBlock()", "  endBlockIndex: " + this.endBlockIndex);
        if (this.endBlockIndex != 0x7FFFFF00L) {
            if (this.endBlockIndex == (long)this.index) {
                this.endBlockIndex = 0x7FFFFF00L;
            } else {
                this.trace("CORBAInputStream.endBlock()", "skip end block... ");
            }
        }
    }

    protected void readEndTag() {
        this.trace("CORBAInputStream.readEndTag()", "READ END TAG: " + this.index);
        this.trace("CORBAInputStream.readEndTag()", "  chunked: " + this.isChunked);
        if (this.endTag == 0) {
            this.trace("CORBAInputStream.readEndTag()", "skip end tag...");
            return;
        }
        if (this.isChunked) {
            int i = this.index;
            int j = this.read_long();
            this.trace("CORBAInputStream.readEndTag()", "  reded end tag: " + j);
            if (j == -1) {
                this.endTag = -1;
            } else if (j != this.endTag && j >= 0) {
                this.trace("CORBAInputStream.readEndTag()", "  RESET INDEX");
                this.reset(i);
            }
        }
        ++this.endTag;
        this.trace("CORBAInputStream.readEndTag()", "  END TAG :" + this.endTag);
    }

    public boolean read_boolean() {
        this.align(1);
        return this.data[this.index++] != 0;
    }

    public void read_boolean_array(boolean[] val, int off, int len) {
        int i = 0;
        while (i < len) {
            val[off + i] = this.read_boolean();
            ++i;
        }
    }

    public byte unaligned_read_octet() {
        return this.data[this.index++];
    }

    public byte read_octet() {
        this.align(1);
        return this.data[this.index++];
    }

    public void read_octet_array(byte[] val, int off, int len) {
        System.arraycopy(this.data, this.index, val, off, len);
        this.index += len;
    }

    public char read_char() {
        return (char)(this.data[this.index++] & 0xFF);
    }

    public void read_char_array(char[] val, int off, int len) {
        int i = 0;
        while (i < len) {
            val[off + i] = this.read_char();
            ++i;
        }
    }

    public short read_short() {
        int b1;
        int b2;
        this.align(2);
        if (this.littleEndian) {
            b2 = this.data[this.index++] << 0 & 0xFF;
            b1 = this.data[this.index++] << 8 & 0xFF00;
        } else {
            b1 = this.data[this.index++] << 8 & 0xFF00;
            b2 = this.data[this.index++] << 0 & 0xFF;
        }
        return (short)(b1 | b2);
    }

    public int read_uShort() {
        int b1;
        int b2;
        this.align(2);
        if (this.littleEndian) {
            b2 = this.data[this.index++] << 0 & 0xFF;
            b1 = this.data[this.index++] << 8 & 0xFF00;
        } else {
            b1 = this.data[this.index++] << 8 & 0xFF00;
            b2 = this.data[this.index++] << 0 & 0xFF;
        }
        return b1 | b2;
    }

    public void read_short_array(short[] val, int off, int len) {
        int i = 0;
        while (i < len) {
            val[off + i] = this.read_short();
            ++i;
        }
    }

    public short read_ushort() {
        return this.read_short();
    }

    public void read_ushort_array(short[] val, int off, int len) {
        this.read_short_array(val, off, len);
    }

    public int unaligned_read_long() {
        int b1;
        int b2;
        int b3;
        int b4;
        if (this.littleEndian) {
            b4 = this.data[this.index++] << 0 & 0xFF;
            b3 = this.data[this.index++] << 8 & 0xFF00;
            b2 = this.data[this.index++] << 16 & 0xFF0000;
            b1 = this.data[this.index++] << 24 & 0xFF000000;
        } else {
            b1 = this.data[this.index++] << 24 & 0xFF000000;
            b2 = this.data[this.index++] << 16 & 0xFF0000;
            b3 = this.data[this.index++] << 8 & 0xFF00;
            b4 = this.data[this.index++] << 0 & 0xFF;
        }
        return b1 | b2 | b3 | b4;
    }

    public int read_long() {
        this.align(4);
        return this.unaligned_read_long();
    }

    public void read_long_array(int[] val, int off, int len) {
        val[off] = this.read_long();
        int i = 1;
        while (i < len) {
            val[off + i] = this.unaligned_read_long();
            ++i;
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public void read_ulong_array(int[] val, int off, int len) {
        this.read_long_array(val, off, len);
    }

    public long read_longlong() {
        long i1;
        long i2;
        this.align(8);
        if (this.littleEndian) {
            i2 = (long)this.read_long() & 0xFFFFFFFFL;
            i1 = (long)this.unaligned_read_long() << 32;
        } else {
            i1 = (long)this.read_long() << 32;
            i2 = (long)this.unaligned_read_long() & 0xFFFFFFFFL;
        }
        return i1 | i2;
    }

    public void read_longlong_array(long[] val, int off, int len) {
        int i = 0;
        while (i < len) {
            val[off + i] = this.read_longlong();
            ++i;
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public void read_ulonglong_array(long[] val, int off, int len) {
        this.read_longlong_array(val, off, len);
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public void read_float_array(float[] val, int off, int len) {
        int i = 0;
        while (i < len) {
            val[off + i] = this.read_float();
            ++i;
        }
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public void read_double_array(double[] val, int off, int len) {
        int i = 0;
        while (i < len) {
            val[off + i] = this.read_double();
            ++i;
        }
    }

    public String read_string() {
        int len = this.read_long();
        String str = new String(this.data, this.index, len - 1);
        this.index += len;
        return str;
    }

    public char unaligned_read_wchar() {
        int i;
        int j;
        boolean endian = this.littleEndian;
        if (this.minorVersion == 2 && this.check4Chars) {
            endian = false;
            byte nmb = this.read_octet();
            if (nmb == 4) {
                int BOM1 = this.unaligned_read_octet() & 0xFF;
                int BOM2 = this.unaligned_read_octet() & 0xFF;
                endian = BOM1 == 255 && BOM2 == 254 ? true : (BOM1 == 254 && BOM2 == 255 ? false : false);
            }
        }
        if (endian) {
            j = this.data[this.index++] & 0xFF;
            i = this.data[this.index++] & 0xFF;
        } else {
            i = this.data[this.index++] & 0xFF;
            j = this.data[this.index++] & 0xFF;
        }
        return (char)((i << 8) + (j << 0));
    }

    public char read_wchar() {
        int i;
        int j;
        boolean endian = this.littleEndian;
        if (this.minorVersion == 2 && this.check4Chars) {
            endian = false;
            byte nmb = this.read_octet();
            if (nmb == 4) {
                int BOM1 = this.unaligned_read_octet() & 0xFF;
                int BOM2 = this.unaligned_read_octet() & 0xFF;
                endian = BOM1 == 255 && BOM2 == 254 ? true : (BOM1 == 254 && BOM2 == 255 ? false : false);
            }
        } else {
            this.align(2);
        }
        if (endian) {
            j = this.data[this.index++] & 0xFF;
            i = this.data[this.index++] & 0xFF;
        } else {
            i = this.data[this.index++] & 0xFF;
            j = this.data[this.index++] & 0xFF;
        }
        return (char)((i << 8) + (j << 0));
    }

    public void read_wchar_array(char[] val, int off, int len) {
        val[off] = this.read_wchar();
        int i = 1;
        while (i < len) {
            val[off + i] = this.unaligned_read_wchar();
            ++i;
        }
    }

    public String read_wstring() {
        int len;
        this.check4Chars = false;
        int n = len = this.isEncapsulated || this.minorVersion == 2 ? this.read_long() / 2 : this.read_long();
        if (len == 0) {
            return "";
        }
        int[] mark = new int[]{this.unaligned_read_octet() & 0xFF, this.unaligned_read_octet() & 0xFF};
        boolean endian = this.littleEndian;
        if (mark[0] == 255 && mark[1] == 254) {
            this.setEndian(true);
            --len;
        } else if (mark[0] == 254 && mark[1] == 255) {
            this.setEndian(false);
            --len;
        } else {
            this.setEndian(endian);
            this.index -= 2;
        }
        char[] ch = new char[len];
        this.read_wchar_array(ch, 0, len);
        this.check4Chars = true;
        if (this.isEncapsulated || this.minorVersion == 2) {
            this.littleEndian = endian;
            return new String(ch, 0, len);
        }
        this.littleEndian = endian;
        return new String(ch, 0, len - 1);
    }

    public synchronized void mark(int readlimit) {
        this.marker = this.index;
    }

    public synchronized void reset() throws IOException {
        if (this.marker >= 0) {
            this.index = this.marker;
            this.marker = -1;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public Object read_Object(Class clas) {
        IOR ior = new IOR((org.omg.CORBA.ORB)this.orb);
        this.trace("CORBAInputStream.read_Object(Class)", "READ OBJECT at : " + this.index);
        ObjectImpl object = (ObjectImpl)ior.read_object(this);
        if (clas != null && clas.isInterface()) {
            return (Object)PortableRemoteObject.narrow((java.lang.Object)object, (Class)clas);
        }
        if (clas != null && (class$org$omg$CORBA$portable$ObjectImpl == null ? (class$org$omg$CORBA$portable$ObjectImpl = CORBAInputStream.class$("org.omg.CORBA.portable.ObjectImpl")) : class$org$omg$CORBA$portable$ObjectImpl).isAssignableFrom(clas)) {
            try {
                ObjectImpl inst = (ObjectImpl)clas.newInstance();
                inst._set_delegate(object._get_delegate());
                this.trace("CORBAInputStream.read_Object(Class)", "OBJECT READ 1 at : " + this.index);
                return inst;
            }
            catch (Exception e) {
                this.trace("CORBAInputStream.read_Object(Class)", "OBJECT READ 2 at : " + this.index);
                return object;
            }
        }
        this.trace("CORBAInputStream.read_Object(Class)", "OBJECT READ 3 at : " + this.index);
        return object;
    }

    public Principal read_Principal() {
        String messageWithId = "ID019037: Reading principal not implemented yet.";
        Logger.traceError("CORBAInputStream.read_Principal()", messageWithId);
        throw new NO_IMPLEMENT(messageWithId);
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl tc = new TypeCodeImpl(this.orb);
        tc.read_value((org.omg.CORBA.portable.InputStream)this);
        return tc;
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl tc = new TypeCodeImpl(this.orb);
        tc.read_value((org.omg.CORBA.portable.InputStream)this);
        any.read_value((org.omg.CORBA.portable.InputStream)this, (TypeCode)tc);
        return any;
    }

    public int beginSequence() {
        return this.read_long();
    }

    public int beginEncapsulation() {
        if (this.encapsulationStack == null) {
            this.encapsulationStack = new Stack();
        }
        int encapsLen = this.read_long();
        StackElement se = new StackElement(this.littleEndian, this.index + encapsLen);
        this.encapsulationStack.push(se);
        this.setEndian(this.read_boolean());
        return encapsLen;
    }

    public void endEncapsulation() {
        StackElement se = (StackElement)this.encapsulationStack.pop();
        this.setEndian(se.endian);
        if (this.index != se.length) {
            this.trace("CORBAInputStream.endEncapsulation()", "!!!!!!!!!!!!!!!!!!!!!!!!!!! ENCAPSULATION !!!!!!!!!!!!!!!!! ERROR");
        }
    }

    private void trace(String where, String msg) {
        Logger.traceDebug(where, msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StackElement {
        public boolean endian;
        public int length;

        public StackElement(boolean endian, int length) {
            this.endian = endian;
            this.length = length;
        }

        public String toString() {
            return "endian: " + this.endian + "   end at: " + this.length;
        }
    }
}

