/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.services.iiop.CORBA.AnyImpl;
import com.sap.engine.services.iiop.CORBA.ContextImpl;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.TypeCodeImpl;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.CORBAOutputStream;
import com.sap.engine.services.iiop.CORBA.util.ExceptionUtility;
import com.sap.engine.services.iiop.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class ServerRequestImpl
extends ServerRequest {
    String _operation;
    NVList _arguments;
    Any _exception;
    Any _result;
    ContextImpl _ctx = null;
    CORBAInputStream _inStream = null;
    boolean _isArgumentSet = false;
    boolean _isResultSet = false;
    boolean _isExceptionSet = false;
    private ORB orb;

    public ServerRequestImpl(ORB orb0) {
        this.orb = orb0;
    }

    public ServerRequestImpl(ORB orb0, String _operation0) {
        this.orb = orb0;
        this._operation = _operation0;
    }

    public void setInputStream(CORBAInputStream in) {
        this._inStream = in;
    }

    public void arguments(NVList list) {
        if (this._isArgumentSet || this._isExceptionSet) {
            String messageWithId = "ID019048: ServerRequestImpl.arguments(): bad invokation order.";
            Logger.traceError("ServerRequestImpl.arguments(NVList)", messageWithId);
            throw new BAD_INV_ORDER(messageWithId);
        }
        if (list == null) {
            String messageWithId = "ID019049: ServerRequestImpl.arguments(): null input parameter.";
            Logger.traceError("ServerRequestImpl.arguments(NVList)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        NamedValue nv = null;
        int i = 0;
        while (i < list.count()) {
            try {
                nv = list.item(i);
                if (nv.flags() != 2) {
                    nv.value().read_value((InputStream)this._inStream, nv.value().type());
                }
            }
            catch (Bounds e) {
            }
            catch (Exception e) {
                Logger.traceError("ServerRequestImpl.arguments(NVList)", Logger.exceptionTrace(e));
                String messageWithId = "ID019050: ServerReqeustImpl.arguments(): error while marshaling argument. ";
                throw new MARSHAL(messageWithId);
            }
            ++i;
        }
        this._arguments = list;
        this._isArgumentSet = true;
    }

    public Context ctx() {
        return this._ctx;
    }

    public String operation() {
        return this._operation;
    }

    public void except(Any any) {
        this.set_exception(any);
    }

    public void set_exception(Any any) {
        if (any == null) {
            String messageWithId = "ID019051: ServerRequestImpl.set_exception(): null input parameter.";
            Logger.traceError("ServerRequestImpl.set_exception(Any)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        if (any.type().kind() != TCKind.tk_except) {
            String messageWithId = "ID019052: ServerRequestImpl.set_exception(): invalid parameter kind.";
            Logger.traceError("ServerRequestImpl.set_exception(Any)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        this._exception = any;
        this._isExceptionSet = true;
    }

    public void set_result(Any any) {
        if (!this._isArgumentSet || this._isResultSet || this._isExceptionSet) {
            String messageWithId = "ID019053: ServerRequestImpl.set_result(): bad invokation order.";
            Logger.traceError("ServerRequestImpl.set_result(Any)", messageWithId);
            throw new BAD_INV_ORDER(messageWithId);
        }
        if (any == null) {
            String messageWithId = "ID019054: ServerRequestImpl.set_result(): null input parameter.";
            Logger.traceError("ServerRequestImpl.set_result(Any)", messageWithId);
            throw new BAD_PARAM(messageWithId);
        }
        this._result = any;
        this._isResultSet = true;
    }

    public byte hasException() {
        if (this._isExceptionSet) {
            try {
                String id = this._exception.type().id();
                if (ExceptionUtility.isSystemException(id)) {
                    return 2;
                }
                return 1;
            }
            catch (Exception e) {
                Logger.traceDebug("ServerRequestImpl.hasException()", Logger.exceptionTrace(e));
                return 2;
            }
        }
        return 0;
    }

    public Any get_result() {
        if (this._result != null) {
            return this._result;
        }
        return this._exception;
    }

    public void writeResult(CORBAOutputStream out) throws Exception {
        if (this._isArgumentSet && this._isResultSet) {
            this._result.write_value((OutputStream)out);
        } else if (this._isArgumentSet && !this._isResultSet && !this._isExceptionSet) {
            try {
                this._result = new AnyImpl(this.orb);
                this._result.type((TypeCode)new TypeCodeImpl(this.orb, TCKind.tk_void));
                this._result.write_value((OutputStream)out);
            }
            catch (Exception e) {
                Logger.traceError("ServerRequestImpl.writeResult(CORBAOutputStream)", Logger.exceptionTrace(e));
                throw e;
            }
        } else {
            if (this._isExceptionSet) {
                String id = this._exception.type().id();
                if (ExceptionUtility.isSystemException(id)) {
                    CORBAInputStream in = (CORBAInputStream)this._exception.create_input_stream();
                    out.write_string(in.read_string());
                    out.write_long(in.read_long());
                    out.write_long(in.unaligned_read_long());
                    return;
                }
                this._exception.write_value((OutputStream)out);
                return;
            }
            String messageWithId = "ID019055: ServerRequestImpl.writeResult(): bad invocation order.";
            Logger.traceError("ServerRequestImpl.writeResult(CORBAOutputStream)", messageWithId);
            throw new BAD_INV_ORDER(messageWithId);
        }
        NamedValue nv = null;
        int i = 0;
        while (i < this._arguments.count()) {
            try {
                nv = this._arguments.item(i);
                if (nv.flags() != 1) {
                    nv.value().write_value((OutputStream)out);
                }
            }
            catch (Bounds e) {
            }
            catch (Exception e) {
                String messageWithId = "ID019056: ServerReqeustImpl.writeResult(): error while marshaling arguments. ";
                Logger.traceError("ServerRequestImpl.writeResult(CORBAOutputStream)", Logger.exceptionTrace(e));
                throw new MARSHAL(messageWithId);
            }
            ++i;
        }
    }
}

