/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.logging.Logger;

public class CodeSetChooser {
    private int fallback_loc_c = 0x5010001;
    private int fallback_loc_wc = 65801;
    private int loc_c_n = 65568;
    private int loc_wc_n = 65792;
    private static int[] loc_c_cv = new int[]{65537, 65538, 65539, 65540, 65541};
    private static int[] loc_wc_cv = new int[]{65801};
    private int c_n = 65537;
    private int wc_n;
    private int[] c_cv;
    private int[] wc_cv;
    private int temp_loc_c = -1;
    private int temp_loc_wc = -1;

    public CodeSetChooser() {
        this.wc_n = 0;
    }

    public CodeSetChooser(byte[] data) {
        this.extractCodeSets(new CORBAInputStream(data));
    }

    public CodeSetChooser(CORBAInputStream cis) {
        this.extractCodeSets(cis);
    }

    public void extractCodeSets(CORBAInputStream cis) {
        int i;
        cis.beginEncapsulation();
        this.c_n = cis.read_long();
        int convCnt = cis.unaligned_read_long();
        if (convCnt > 0) {
            this.c_cv = new int[convCnt];
            i = 0;
            while (i < convCnt) {
                this.c_cv[i] = cis.unaligned_read_long();
                ++i;
            }
        }
        this.wc_n = cis.unaligned_read_long();
        convCnt = cis.unaligned_read_long();
        if (convCnt > 0) {
            this.wc_cv = new int[convCnt];
            i = 0;
            while (i < convCnt) {
                this.wc_cv[i] = cis.unaligned_read_long();
                ++i;
            }
        }
        cis.endEncapsulation();
    }

    public void setCharNative(int chn) {
        this.loc_c_n = chn;
    }

    public void setWCharNative(int wchn) {
        this.loc_wc_n = wchn;
    }

    public void setCharConvertions(int[] chnc) {
        loc_c_cv = chnc;
    }

    public void setWCharConvertions(int[] wchn) {
        loc_wc_cv = wchn;
    }

    public int charCodeSet() {
        return this.loc_c_n;
    }

    public int wcharCodeSet() {
        return this.loc_wc_n;
    }

    public int o_charCodeSet() {
        return this.c_n;
    }

    public int o_wcharCodeSet() {
        return this.wc_n;
    }

    public int[] charConvertions() {
        return loc_c_cv;
    }

    public int[] wcharConvertions() {
        return loc_wc_cv;
    }

    public int verifyCodesets() {
        try {
            if (this.charChoosed() && this.wcharChoosed()) {
                if (this.temp_loc_c > -1) {
                    this.loc_c_n = this.temp_loc_c;
                }
                if (this.temp_loc_wc > -1) {
                    this.loc_wc_n = this.temp_loc_wc;
                }
                return 0;
            }
            return 2;
        }
        catch (Exception e) {
            Logger.traceError("CodeSetChooser.verifyCodesets()", Logger.exceptionTrace(e));
            return 2;
        }
    }

    private boolean charChoosed() {
        if (this.c_n == this.loc_c_n) {
            return true;
        }
        if (this.elementOf(this.loc_c_n, this.c_cv)) {
            return true;
        }
        if (this.elementOf(this.c_n, loc_c_cv)) {
            this.temp_loc_c = this.c_n;
            return true;
        }
        this.temp_loc_c = this.findMatch(loc_c_cv, this.c_cv);
        if (this.temp_loc_c > -1) {
            return true;
        }
        if (this.charFallbackCompatible()) {
            this.loc_c_n = this.fallback_loc_c;
            return true;
        }
        return false;
    }

    private boolean wcharChoosed() {
        if (this.wc_n == this.loc_wc_n) {
            return true;
        }
        if (this.elementOf(this.loc_wc_n, this.wc_cv)) {
            return true;
        }
        if (this.elementOf(this.wc_n, loc_wc_cv)) {
            this.temp_loc_wc = this.wc_n;
            return true;
        }
        this.temp_loc_wc = this.findMatch(loc_wc_cv, this.wc_cv);
        if (this.temp_loc_wc > -1) {
            return true;
        }
        if (this.wcharFallbackCompatible()) {
            this.loc_wc_n = this.fallback_loc_wc;
            return true;
        }
        return false;
    }

    private boolean elementOf(int n, int[] all) {
        int i = 0;
        while (i < all.length) {
            if (n == all[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findMatch(int[] one, int[] two) {
        int i = 0;
        while (i < one.length) {
            int j = 0;
            while (j < two.length) {
                if (one[i] == two[i]) {
                    return one[i];
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private boolean charFallbackCompatible() {
        return true;
    }

    private boolean wcharFallbackCompatible() {
        return true;
    }
}

