/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.services.iiop.CORBA.AnyInputStream;
import com.sap.engine.services.iiop.CORBA.AnyOutputStream;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.TCUtility;
import com.sap.engine.services.iiop.CORBA.TypeCodeImpl;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.CORBAOutputStream;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public final class AnyImpl
extends Any {
    private TypeCodeImpl typeCode;
    private CORBAInputStream stream;
    private long value;
    private java.lang.Object object;
    static boolean[] isStreamed = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, true, true, true, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false};
    ORB orb;

    public AnyImpl(ORB orb0) {
        this.orb = orb0;
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_null);
    }

    AnyImpl(ORB orb0, Any obj) {
        this(orb0);
        if (obj instanceof AnyImpl) {
            AnyImpl objImpl = (AnyImpl)obj;
            this.typeCode = objImpl.typeCode;
            this.value = objImpl.value;
            this.object = objImpl.object;
            if (objImpl.stream != null) {
                this.stream = objImpl.stream.dup();
            }
        } else {
            this.read_value(obj.create_input_stream(), obj.type());
        }
    }

    public TypeCode type() {
        return this.typeCode;
    }

    public void type(TypeCode tc) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, tc);
        this.stream = null;
        this.value = 0L;
        this.object = null;
    }

    public boolean equal(Any otherAny) {
        if (!this.typeCode.equal(otherAny.type())) {
            return false;
        }
        switch (this.typeCode.kind().value()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == otherAny.extract_short();
            }
            case 3: {
                return this.extract_long() == otherAny.extract_long();
            }
            case 4: {
                return this.extract_ushort() == otherAny.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == otherAny.extract_ulong();
            }
            case 6: {
                return this.extract_float() == otherAny.extract_float();
            }
            case 7: {
                return this.extract_double() == otherAny.extract_double();
            }
            case 8: {
                return this.extract_boolean() == otherAny.extract_boolean();
            }
            case 9: {
                return this.extract_char() == otherAny.extract_char();
            }
            case 10: {
                return this.extract_octet() == otherAny.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(otherAny.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(otherAny.extract_TypeCode());
            }
            case 18: {
                return this.extract_string().equals(otherAny.extract_string());
            }
            case 23: {
                return this.extract_longlong() == otherAny.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == otherAny.extract_ulonglong();
            }
            case 17: {
                return this.create_input_stream().read_long() == otherAny.create_input_stream().read_long();
            }
            case 26: {
                return this.extract_wchar() == otherAny.extract_wchar();
            }
            case 27: {
                return this.extract_wstring().equals(otherAny.extract_wstring());
            }
            case 25: {
                throw new NO_IMPLEMENT("ID019000");
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: {
                throw new NO_IMPLEMENT("ID019001");
            }
        }
        return false;
    }

    public OutputStream create_output_stream() {
        return new AnyOutputStream(this.orb);
    }

    public InputStream create_input_stream() {
        if (this.stream != null) {
            return this.stream.dup();
        }
        CORBAOutputStream os = new CORBAOutputStream(this.orb);
        TCUtility.marshalIn((OutputStream)os, this.typeCode.kind().value(), this.value, this.object);
        return os.create_input_stream();
    }

    public void read_value(InputStream in, TypeCode tc) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, tc);
        int type = this.typeCode.kind().value();
        if (isStreamed[type]) {
            if (in instanceof AnyInputStream) {
                this.stream = (CORBAInputStream)in;
            } else {
                CORBAOutputStream out = new CORBAOutputStream(this.orb);
                this.typeCode.copy(in, (OutputStream)out);
                this.stream = (CORBAInputStream)out.create_input_stream();
            }
        } else {
            java.lang.Object[] objholder = new java.lang.Object[]{this.object};
            long[] longholder = new long[1];
            TCUtility.unmarshalIn(in, type, longholder, objholder);
            this.value = longholder[0];
            this.object = objholder[0];
            this.stream = null;
        }
    }

    public void write_value(OutputStream out) {
        if (this.stream != null) {
            this.typeCode.copy((InputStream)this.stream.dup(), out);
        } else {
            TCUtility.marshalIn(out, this.typeCode.kind().value(), this.value, this.object);
        }
    }

    public void insert_Streamable(Streamable s) {
        AnyOutputStream os = new AnyOutputStream(this.orb);
        s._write((OutputStream)os);
        this.read_value(os.create_input_stream(), s._type());
    }

    public void insert_short(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_short);
        this.value = s;
    }

    public short extract_short() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_short))) {
            throw new BAD_OPERATION("ID019002");
        }
        return (short)this.value;
    }

    public void insert_long(int l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_long);
        this.value = l;
    }

    public int extract_long() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_long))) {
            throw new BAD_OPERATION("ID019003");
        }
        return (int)this.value;
    }

    public void insert_ushort(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort);
        this.value = s;
    }

    public short extract_ushort() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort))) {
            throw new BAD_OPERATION("ID019004");
        }
        return (short)this.value;
    }

    public void insert_ulong(int l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong);
        this.value = l;
    }

    public int extract_ulong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong))) {
            throw new BAD_OPERATION("ID019005");
        }
        return (int)this.value;
    }

    public void insert_float(float f) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_float);
        this.value = Float.floatToIntBits(f);
    }

    public float extract_float() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_float))) {
            throw new BAD_OPERATION("ID019006");
        }
        return Float.intBitsToFloat((int)this.value);
    }

    public void insert_double(double d) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_double);
        this.value = Double.doubleToLongBits(d);
    }

    public double extract_double() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_double))) {
            throw new BAD_OPERATION("ID019007");
        }
        return Double.longBitsToDouble(this.value);
    }

    public void insert_longlong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong);
        this.value = l;
    }

    public long extract_longlong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong))) {
            throw new BAD_OPERATION("ID019008");
        }
        return this.value;
    }

    public void insert_ulonglong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong);
        this.value = l;
    }

    public long extract_ulonglong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong))) {
            throw new BAD_OPERATION("ID019009");
        }
        return this.value;
    }

    public void insert_boolean(boolean b) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean);
        this.value = b ? 1L : 0L;
    }

    public boolean extract_boolean() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean))) {
            throw new BAD_OPERATION("ID019010");
        }
        return this.value != 0L;
    }

    public void insert_char(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_char);
        this.value = c;
    }

    public char extract_char() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_char))) {
            throw new BAD_OPERATION("ID019011");
        }
        return (char)this.value;
    }

    public void insert_wchar(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar);
        this.value = c;
    }

    public char extract_wchar() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar))) {
            throw new BAD_OPERATION("ID019012");
        }
        return (char)this.value;
    }

    public void insert_octet(byte b) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_octet);
        this.value = b;
    }

    public byte extract_octet() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_octet))) {
            throw new BAD_OPERATION("ID019014");
        }
        return (byte)this.value;
    }

    public void insert_string(String s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_string);
        this.object = s;
    }

    public String extract_string() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_string))) {
            throw new BAD_OPERATION("ID019015");
        }
        return (String)this.object;
    }

    public void insert_wstring(String s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wstring);
        this.object = s;
    }

    public String extract_wstring() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_wstring))) {
            throw new BAD_OPERATION("ID019016");
        }
        return (String)this.object;
    }

    public void insert_any(Any a) {
        AnyOutputStream os = new AnyOutputStream(this.orb);
        os.write_any(a);
        this.read_value(os.create_input_stream(), TypeCodeImpl.get_primitive_tc(TCKind.tk_any));
    }

    public Any extract_any() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_any))) {
            throw new BAD_OPERATION("ID019018");
        }
        return this.stream.dup().read_any();
    }

    public void insert_Object(Object o) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_objref);
        this.object = o;
    }

    public void insert_Object(Object o, TypeCode tc) {
        try {
            if (!tc.id().equals("IDL:omg.org/CORBA/Object:1.0") && !o._is_a(tc.id())) {
                throw new BAD_OPERATION("ID019019");
            }
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, tc);
            this.object = o;
        }
        catch (Exception ex) {
            Logger.traceError("AnyImpl.insert_Object(org.omg.CORBA.Object, TypeCode)", Logger.exceptionTrace(ex));
            throw new BAD_OPERATION("ID019020");
        }
    }

    public Object extract_Object() {
        Object obj = null;
        try {
            obj = (Object)this.object;
            if (this.typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || obj._is_a(this.typeCode.id())) {
                return obj;
            }
            throw new BAD_OPERATION("ID019021");
        }
        catch (Exception ex) {
            Logger.traceError("AnyImpl.extract_Object", Logger.exceptionTrace(ex));
            throw new BAD_OPERATION("ID019022");
        }
    }

    public void insert_Value(Serializable v) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_value);
        if (v == null) {
            return;
        }
        this.object = v;
    }

    public void insert_Value(Serializable v, TypeCode tc) throws MARSHAL {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, tc);
        if (v == null) {
            return;
        }
        this.object = v;
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        return (Serializable)this.object;
    }

    public void insert_TypeCode(TypeCode tc) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode);
        this.object = tc;
    }

    public TypeCode extract_TypeCode() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode))) {
            throw new BAD_OPERATION("ID019024");
        }
        return (TypeCode)this.object;
    }

    public void insert_Principal(Principal p) {
        AnyOutputStream os = new AnyOutputStream(this.orb);
        os.write_Principal(p);
        this.read_value(os.create_input_stream(), TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal));
    }

    public Principal extract_Principal() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal))) {
            throw new BAD_OPERATION("ID019025");
        }
        return this.stream.dup().read_Principal();
    }
}

