/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.services.httptunneling.HttpLib;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import com.sap.engine.services.httptunneling.HttpTunnelingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

class ServerWriter
implements HttpTunnelingWriter {
    private Socket outputSocket;
    private OutputStream out;
    private HttpTunnelingSocket main;
    private int acknowledgementTimeout = 5000;
    private boolean closed = false;
    private long msgCounter = 0L;

    ServerWriter(HttpTunnelingSocket main) {
        this.main = main;
    }

    synchronized void setOutput(Socket outputSocket) throws IOException {
        if (this.closed) {
            outputSocket.close();
            return;
        }
        try {
            this.outputSocket = outputSocket;
            this.out = outputSocket.getOutputStream();
        }
        catch (IOException e) {
            HttpTunnelingServiceFrame.log(500, "Fail when try to get the OutputStream - " + e.toString());
            this.main.kill();
            throw e;
        }
        this.notifyAll();
    }

    private void closeOutput() {
        try {
            this.out.close();
            this.outputSocket.close();
        }
        catch (Exception e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected exception in ServerWriter.closeOutput - " + e.getMessage());
        }
        this.out = null;
        this.outputSocket = null;
    }

    public void waitForSocket() throws IOException {
        while (this.outputSocket == null && this.main.getStatus() != 5 && this.main.getStatus() != 4) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {
                HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in ServerWriter.waitForSocket - " + exc.getMessage());
            }
        }
        if (this.main.getStatus() == 4) {
            throw new IOException("Socket Closed");
        }
        if (this.main.getStatus() == 5) {
            throw new SocketException("Connection reset by peer");
        }
    }

    public void waitForAcknowledgement(long msgVersion) throws IOException {
        try {
            this.wait();
        }
        catch (InterruptedException exc) {
            HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in ServerWriter.waitForAcknowledgement:122 - " + exc.getMessage());
        }
        if (this.main.getStatus() == 4) {
            throw new IOException("Socket Closed");
        }
        if (this.main.getStatus() == 5) {
            try {
                this.wait(this.acknowledgementTimeout);
            }
            catch (InterruptedException exc) {
                HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in ServerWriter.waitForAcknowledgement:133 - " + exc.getMessage());
            }
            if (this.outputSocket == null && this.msgCounter == msgVersion) {
                throw new SocketException("Connection reset by peer");
            }
        }
    }

    public synchronized void send(byte[] bytes, int offset, int length, int type) throws IOException {
        this.waitForSocket();
        try {
            this.out.write(HttpLib.buildResponse(type, length));
            if (bytes != null && bytes.length > 0) {
                this.out.write(bytes, offset, length);
            }
            this.out.flush();
        }
        catch (IOException exc) {
            this.main.kill();
            this.closeOutput();
            throw new SocketException("Connection reset by peer");
        }
        this.closeOutput();
        ++this.msgCounter;
        this.waitForAcknowledgement(this.msgCounter);
    }

    public synchronized void close() {
        this.closed = true;
        this.closeOutput();
        this.notifyAll();
    }

    public synchronized void notifyAboutKill() {
        this.notifyAll();
    }

    public void closeLocally() throws IOException {
        this.send(null, 0, 0, 16);
    }
}

