/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.frame.cluster.transport.TransportFactory;
import com.sap.engine.services.httptunneling.ClientReader;
import com.sap.engine.services.httptunneling.ClientWriter;
import com.sap.engine.services.httptunneling.HttpLib;
import com.sap.engine.services.httptunneling.HttpTunnelingInputStream;
import com.sap.engine.services.httptunneling.HttpTunnelingOutputStream;
import com.sap.engine.services.httptunneling.HttpTunnelingServerSocket;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.ServerWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import java.util.Random;

public class HttpTunnelingSocket
extends Socket {
    static final byte STATUS_NOT_COMPLETED = 0;
    static final byte STATUS_NOT_ACCEPTED = 1;
    static final byte STATUS_ACCEPTED = 2;
    static final byte STATUS_CLIENT = 3;
    static final byte STATUS_CLOSED = 4;
    static final byte STATUS_CONNECTION_RESET = 5;
    private HttpTunnelingInputStream hin = null;
    private HttpTunnelingOutputStream hout = null;
    private HttpTunnelingServerSocket server = null;
    private ClientReader reader = null;
    private int port;
    private String host;
    private int proxyPort;
    private String proxyHost;
    private long number;
    private TransportFactory socketFactory = null;
    private Properties connectionProps = null;
    private InetAddress inetAddress = null;
    private InetAddress localAddress = null;
    private byte status = (byte)4;
    private String id = null;

    HttpTunnelingSocket(String host, int port, TransportFactory socketFactory) throws IOException {
        this.host = host;
        this.port = port;
        this.socketFactory = socketFactory;
        this.proxyHost = host;
        this.proxyPort = port;
        this.createConnection();
    }

    HttpTunnelingSocket(String host, int port, Properties props, TransportFactory socketFactory) throws IOException {
        this.host = host;
        this.port = port;
        this.socketFactory = socketFactory;
        this.proxyHost = props.getProperty("HTTP_Host", host);
        try {
            this.proxyPort = Integer.parseInt(props.getProperty("HTTP_Port", String.valueOf(port)));
        }
        catch (Exception e) {
            this.proxyPort = port;
        }
        this.createConnection();
    }

    HttpTunnelingSocket(long number, String id, HttpTunnelingServerSocket server, InetAddress inetAddress, InetAddress localAddress) {
        this.number = number;
        this.server = server;
        this.inetAddress = inetAddress;
        this.localAddress = localAddress;
        this.id = id;
        this.hin = new HttpTunnelingInputStream(this);
        this.hout = new HttpTunnelingOutputStream(this, new ServerWriter(this));
        this.setSoTimeout(HttpTunnelingServiceFrame.prop_Timeout);
    }

    public HttpTunnelingSocket(String host, int port) throws IOException {
        this(host, port, (TransportFactory)null);
    }

    public HttpTunnelingSocket(String host, int port, Properties properties) throws IOException {
        this(host, port, properties, null);
    }

    byte getStatus() {
        return this.status;
    }

    synchronized void setStatus(byte status) {
        this.status = status;
    }

    Socket getSocket() throws IOException {
        Socket result = null;
        try {
            result = this.socketFactory.getSocket(this.proxyHost, this.proxyPort, this.connectionProps);
        }
        catch (NullPointerException e) {
            result = new Socket(this.proxyHost, this.proxyPort);
        }
        return result;
    }

    private void createConnection() throws IOException {
        byte[] id_bytes = new byte[HttpTunnelingServiceFrame.prop_IdLength];
        new Random().nextBytes(id_bytes);
        this.id = new String(id_bytes);
        Socket socket = this.getSocket();
        this.inetAddress = InetAddress.getByName(this.host);
        this.localAddress = socket.getLocalAddress();
        OutputStream out = socket.getOutputStream();
        out.write(HttpLib.buildRequest(this.inetAddress.getHostAddress(), this.port, this.id, socket.getLocalAddress().getHostAddress()));
        out.flush();
        this.number = HttpLib.getHeaderFullMessage(HttpLib.readHeader(socket.getInputStream()));
        try {
            out.close();
            socket.close();
        }
        catch (IOException e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected IOException in HttpTunnelingSocket.createConnection - " + e.getMessage());
        }
        socket = this.getSocket();
        out = socket.getOutputStream();
        out.write(HttpLib.buildRequest(this.host, this.port, this.id, 2, this.number));
        out.flush();
        try {
            this.hin = new HttpTunnelingInputStream(this);
            this.hout = new HttpTunnelingOutputStream(this, new ClientWriter(this.host, this.port, this.number, this));
            this.reader = new ClientReader(socket, this.host, this.port, this.hin, this.number, this);
            this.reader.start();
        }
        catch (IOException e) {
            HttpTunnelingServiceFrame.log(500, "Can't create connection - " + e.toString());
            this.close();
            throw e;
        }
        this.setStatus((byte)3);
    }

    public InputStream getInputStream() throws IOException {
        if (this.status == 4) {
            throw new IOException("Socket Closed");
        }
        return this.hin;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.status == 4) {
            throw new IOException("Socket Closed");
        }
        return this.hout;
    }

    public synchronized void close() throws IOException {
        if (this.status != 4) {
            if (this.status == 3) {
                this.reader.close();
            } else {
                this.server.unregisterSocket(this.number);
            }
            this.status = (byte)4;
            this.hin.notifyAboutSocketClosed();
            this.hout.getWriter().close();
        }
    }

    synchronized void kill() {
        if (this.status != 4 && this.status != 5) {
            this.status = (byte)5;
            this.hin.notifyAboutKill();
            this.hout.getWriter().notifyAboutKill();
        }
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public synchronized int getPort() {
        if (this.status == 4 || this.status == 5) {
            return 0;
        }
        if (this.status == 3) {
            return this.port;
        }
        throw new UnsupportedOperationException("The server hasn't permanent port!");
    }

    public InetAddress getLocalAddress() {
        if (this.status == 4 || this.status == 5) {
            return null;
        }
        return this.localAddress;
    }

    public synchronized int getLocalPort() {
        if (this.status == 4 || this.status == 5) {
            return -1;
        }
        if (this.status != 3) {
            return this.server.getLocalPort();
        }
        throw new UnsupportedOperationException("The client hasn't permanent local port");
    }

    public void setSendBufferSize(int size) throws SocketException {
        throw new SocketException("Unsupported operation!");
    }

    public int getSendBufferSize() {
        return Integer.MAX_VALUE;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        throw new SocketException("Unsupported operation!");
    }

    public int getReceiveBufferSize() {
        return Integer.MAX_VALUE;
    }

    public void setKeepAlive(boolean on) throws SocketException {
        throw new SocketException("Unsupported operation!");
    }

    public boolean getKeepAlive() {
        return false;
    }

    public void shutdownInput() {
        this.hin.closeLocally();
    }

    public void shutdownOutput() throws IOException {
        this.hout.closeLocally();
    }

    public String toString() {
        String portString = null;
        String localPortString = null;
        try {
            portString = String.valueOf(this.getPort());
        }
        catch (UnsupportedOperationException e) {
            portString = "N/A";
        }
        try {
            localPortString = String.valueOf(this.getLocalPort());
        }
        catch (UnsupportedOperationException e) {
            localPortString = "N/A";
        }
        return "HttpTunnelingSocket [addr=" + this.getInetAddress() + ",port=" + portString + ",localport=" + localPortString + "]";
    }

    public boolean getTcpNoDelay() {
        return false;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        throw new SocketException("Unsupported operation!");
    }

    public int getSoLinger() {
        return -1;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        throw new SocketException("Unsupported operation!");
    }

    public void setSoTimeout(int soTimeout) {
        this.hin.setSoTimeout(soTimeout);
    }

    public int getSoTimeout() {
        return this.hin.getSoTimeout();
    }

    String getId() {
        return this.id;
    }
}

