/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import com.sap.engine.services.httptunneling.HttpTunnelingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class HttpTunnelingOutputStream
extends OutputStream {
    private HttpTunnelingWriter writer;
    private HttpTunnelingSocket parentSocket = null;
    private boolean locallyClosed = false;

    HttpTunnelingOutputStream(HttpTunnelingSocket parentSocket, HttpTunnelingWriter writer) {
        this.parentSocket = parentSocket;
        this.setWriter(writer);
    }

    void setWriter(HttpTunnelingWriter writer) {
        this.writer = writer;
    }

    HttpTunnelingWriter getWriter() {
        return this.writer;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.locallyClosed) {
            throw new SocketException("Connection shutdown");
        }
        if (this.parentSocket.getStatus() == 4 || this.parentSocket.getStatus() == 5) {
            throw new SocketException("Socket closed");
        }
        this.writer.send(b, off, len, 0);
    }

    public void flush() {
    }

    public void close() throws IOException {
        this.parentSocket.close();
    }

    void closeLocally() throws IOException {
        this.locallyClosed = true;
        this.writer.closeLocally();
    }
}

