/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.file;

import com.sap.engine.services.file.FileData;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class FileDataImpl
extends PortableRemoteObject
implements FileData {
    private File file;
    private int bufferSize;
    private RandomAccessFile r;
    private int readPosition;
    private byte[] buffer;

    public FileDataImpl(File file) throws RemoteException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.file = file;
        this.bufferSize = 16384;
        this.r = null;
    }

    public void openRead() throws IOException {
        this.r = new RandomAccessFile(this.file, "r");
        this.r.seek(0L);
        this.readPosition = 0;
        this.buffer = new byte[this.bufferSize];
    }

    public void openWrite() throws IOException {
        this.r = new RandomAccessFile(this.file, "rw");
        this.r.seek(0L);
    }

    public void closeRead() throws IOException {
        this.r.close();
    }

    public void closeWrite() throws IOException {
        this.r.setLength(this.r.getFilePointer());
        this.closeRead();
    }

    public void write(byte[] data, int off, int length) throws IOException {
        this.r.write(data, off, length);
    }

    public byte[] read() throws IOException {
        if ((long)this.readPosition < this.r.length()) {
            if (this.r.length() - (long)this.readPosition < (long)this.bufferSize) {
                this.buffer = new byte[(int)this.r.length() - this.readPosition];
            }
            this.r.read(this.buffer);
            this.readPosition += this.buffer.length;
            return this.buffer;
        }
        return null;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }
}

