/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.serialization;

import com.sap.engine.interfaces.ejb.serialization.EJBSerializable;
import com.sap.engine.services.failover.exceptions.FailoverIOException;
import com.sap.engine.services.failover.serialization.EntityBeanReference;
import com.sap.engine.services.failover.serialization.ReplaceObject;
import com.sap.engine.services.rmi_p4.StubImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Stack;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class FailoverOutputStream
extends ObjectOutputStream {
    private Stack statefulIDs = null;

    public FailoverOutputStream(OutputStream outStream, Stack _statefulIDs) throws IOException {
        super(outStream);
        this.enableReplaceObject(true);
        this.statefulIDs = _statefulIDs;
    }

    public Object replaceObject(Object obj) throws IOException {
        if (obj instanceof InitialContext) {
            return new ReplaceObject("JNDI_INT");
        }
        String contextName = null;
        if (obj instanceof Context) {
            try {
                contextName = ((Context)obj).getNameInNamespace();
                return new ReplaceObject("JNDI_CTX" + contextName);
            }
            catch (NamingException ne) {
                throw new FailoverIOException("failover_0101", new String[]{contextName}, ne);
            }
        }
        if (obj instanceof UserTransaction) {
            return new ReplaceObject("UT");
        }
        if (obj instanceof SessionContext) {
            return new ReplaceObject("SC");
        }
        if (obj.getClass().getClassLoader() != null) {
            try {
                if (obj instanceof EJBObject || obj instanceof EJBHome || obj instanceof EJBLocalObject || obj instanceof EJBLocalHome) {
                    EJBSerializable ejbs = this.getEJBImplementation(obj);
                    String ejbId = ejbs.ejbGetID();
                    if (ejbId.startsWith("&STATEFUL&")) {
                        ejbId = ejbId.substring("&STATEFUL&".length());
                        this.statefulIDs.push(ejbId);
                    }
                    if (ejbId.startsWith("&ENTITY&")) {
                        if (ejbId.endsWith("&LOCAL&")) {
                            Object pk = ((EJBLocalObject)obj).getPrimaryKey();
                            return new EntityBeanReference(ejbId.substring("&ENTITY&".length()), pk);
                        }
                        Object pk = ((EJBObject)obj).getPrimaryKey();
                        return new EntityBeanReference(ejbId.substring("&ENTITY&".length()), pk);
                    }
                    return new ReplaceObject("EJB" + ejbId);
                }
            }
            catch (Exception exc) {
                throw new FailoverIOException("failover_0102", exc);
            }
        }
        return obj;
    }

    private EJBSerializable getEJBImplementation(Object stub) {
        if (stub instanceof StubImpl) {
            return (EJBSerializable)((Object)((StubImpl)stub).p4remote.getDelegate());
        }
        return (EJBSerializable)stub;
    }
}

