/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless_sp5;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.session.stateless_sp5.BaseContainer;
import com.sap.engine.services.ejb.session.stateless_sp5.BaseContext;
import com.sap.engine.services.ejb.session.stateless_sp5.StatelessContainerFP;
import com.sap.engine.services.ejb.util.debug.AssertionError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.transaction.UserTransaction;

public class StatelessContext
extends BaseContext
implements SessionContext {
    static final byte DOES_NOT_EXIST = 0;
    static final byte SETTING_CONTEXT = 1;
    static final byte CREATING_BEAN = 4;
    static final byte METHOD_READY = 16;
    static final byte REMOVING = 64;
    private final StatelessContainerFP container;
    protected final ResourceContext resourceContext;
    byte state = 0;

    StatelessContext(StatelessContainerFP container, SessionBean bean) {
        super(container, (EnterpriseBean)bean);
        String appName = container.getAppName();
        this.container = container;
        String compName = "ejbContexts/" + appName + "/" + container.getSessionDescriptor().getJndiName();
        this.resourceContext = container.getEnvironment().getResourceContextFactory().createContext(container.getAppName(), compName, true);
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    private final void assertLegalState(int allowedStates) {
        if ((this.state & allowedStates) == 0) {
            throw new IllegalStateException();
        }
    }

    public EJBHome getEJBHome() {
        this.assertLegalState(85);
        return this.container.getEJBHome();
    }

    public EJBObject getEJBObject() {
        this.assertLegalState(84);
        return this.container.createEJBObject();
    }

    public EJBLocalHome getEJBLocalHome() {
        this.assertLegalState(85);
        return this.getBaseContainer().getEJBLocalHome();
    }

    public EJBLocalObject getEJBLocalObject() {
        this.assertLegalState(84);
        Class<?> ejbLocalHomeClass = this.container.getEJBLocalHome().getClass();
        try {
            Method m = ejbLocalHomeClass.getMethod("create", null);
            return (EJBLocalObject)m.invoke((Object)this.container.getEJBLocalHome(), null);
        }
        catch (NoSuchMethodException sme) {
            throw new AssertionError(false);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError(false);
        }
        catch (InvocationTargetException ite) {
            BaseEJBException ejbExc = new BaseEJBException("ejb_1007", ite.getTargetException());
            throw (EJBException)BaseContainer.traceError((Throwable)((Object)ejbExc));
        }
    }

    public boolean getRollbackOnly() {
        this.assertLegalState(16);
        if (this.container.getSessionDescriptor().getTransactionType() != 1) {
            throw new IllegalStateException();
        }
        return super.getRollbackOnly();
    }

    public boolean isCallerInRole(String role) {
        this.assertLegalState(16);
        return super.isCallerInRole(role);
    }

    public Principal getCallerPrincipal() {
        this.assertLegalState(16);
        return super.getCallerPrincipal();
    }

    public void setRollbackOnly() {
        this.assertLegalState(16);
        if (this.container.getSessionDescriptor().getTransactionType() != 1) {
            throw new IllegalStateException();
        }
        super.setRollbackOnly();
    }

    public UserTransaction getUserTransaction() {
        this.assertLegalState(84);
        if (this.container.getSessionDescriptor().getTransactionType() != 0) {
            throw new IllegalStateException();
        }
        return super.getUserTransaction();
    }
}

