/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless_sp5;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.session.stateless_sp5.BeanContext;
import com.sap.engine.services.ejb.session.stateless_sp5.StatelessContainerFP;
import com.sap.engine.services.ejb.session.stateless_sp5.StatelessContext;
import com.sap.engine.services.ejb.util.debug.AssertionError;
import com.sap.engine.services.ejb.util.pool.PoolUser;
import com.sap.engine.services.ejb.util.pool.StackException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.security.auth.Subject;

class BeanFactory
implements PoolUser {
    private Constructor beanCtr;
    private Method createMethod;
    private Subject runAsSubject;
    private StatelessContainerFP container;
    private SecurityContext securityContext;
    private int securityContextObjectId;

    BeanFactory(StatelessContainerFP container) {
        this.container = container;
        this.securityContextObjectId = container.getEnvironment().getSecurityContextObjectId();
        try {
            this.createMethod = container.getBeanClass().getMethod("ejbCreate", null);
            this.beanCtr = container.getBeanClass().getConstructor(null);
            this.runAsSubject = container.getRunAsSubject();
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError(false);
        }
    }

    public Object createObject() throws Throwable {
        ResourceContext noResources = this.container.getRestrictedResourceContext();
        StatelessContext bean = null;
        try {
            try {
                noResources.enterMethod("createObject");
                SessionBean instance = (SessionBean)this.beanCtr.newInstance(null);
                bean = new StatelessContext(this.container, instance);
                this.runAsRunAsPrincipal(bean);
                bean.state = 1;
                BeanContext ctx = new BeanContext(bean);
                ((SessionBean)bean.getBeanInstance()).setSessionContext((SessionContext)ctx);
                bean.state = (byte)4;
                this.createMethod.invoke((Object)instance, null);
                bean.state = (byte)16;
                this.container.getMonitoringInfo().updateCreations();
                StatelessContext statelessContext = bean;
                Object var7_9 = null;
                this.runAsCallerPrincipal(bean);
                noResources.exitMethod("createObject", bean != null && bean.state == 16);
                return statelessContext;
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError(false);
            }
            catch (InstantiationException ie) {
                throw new AssertionError("false");
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.runAsCallerPrincipal(bean);
            noResources.exitMethod("createObject", bean != null && bean.state == 16);
            throw throwable;
        }
    }

    public void destroyObject(Object obj) throws Throwable {
        StatelessContext bean = (StatelessContext)obj;
        ResourceContext noResources = this.container.getRestrictedResourceContext();
        try {
            this.runAsRunAsPrincipal(bean);
            noResources.enterMethod("destroyObject");
            bean.state = (byte)64;
            ((SessionBean)bean.getBeanInstance()).ejbRemove();
            bean.state = 0;
            this.container.getMonitoringInfo().updateRemovals();
            Object var5_4 = null;
            this.runAsCallerPrincipal(bean);
            noResources.exitMethod("destroyObject", bean.state == 0);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.runAsCallerPrincipal(bean);
            noResources.exitMethod("destroyObject", bean.state == 0);
            throw throwable;
        }
    }

    public StatelessContext getActiveBean() {
        try {
            StatelessContext bean = (StatelessContext)this.container.getContainerPool().pop();
            this.runAsRunAsPrincipal(bean);
            return bean;
        }
        catch (StackException e) {
            throw new BaseRuntimeException("ejb_1046", e.getTarget());
        }
    }

    public void releaseActiveBean(StatelessContext bean) {
        this.runAsCallerPrincipal(bean);
        this.container.getContainerPool().push((Object)bean);
    }

    private final void runAsRunAsPrincipal(StatelessContext bean) {
        if (this.runAsSubject != null) {
            bean.setCallerPrincipal(this.container.getSecurityContext().getPrincipal());
            this.getSecurityContextObject().runAs(this.runAsSubject);
        }
    }

    private final void runAsCallerPrincipal(StatelessContext bean) {
        if (this.runAsSubject != null) {
            bean.setCallerPrincipal(null);
            this.getSecurityContextObject().runAs(null);
        }
    }

    private final SecurityContextObject getSecurityContextObject() {
        ThreadContext tc = this.container.getEnvironment().getThreadSystem().getThreadContext();
        return (SecurityContextObject)((Object)tc.getContextObject(this.securityContextObjectId));
    }
}

