/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless_sp5;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.exceptions.BaseUnsupportedOperationException;
import com.sap.engine.services.ejb.session.stateless_sp5.BaseContainer;
import java.security.Identity;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EnterpriseBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public abstract class BaseContext
implements EJBContext {
    private final BaseContainer container;
    private Principal callerPrincipal = null;
    private final EnterpriseBean beanInstance;

    protected BaseContext(BaseContainer container, EnterpriseBean beanInstance) {
        this.container = container;
        this.beanInstance = beanInstance;
    }

    protected final BaseContainer getBaseContainer() {
        return this.container;
    }

    public final EnterpriseBean getBeanInstance() {
        return this.beanInstance;
    }

    public Properties getEnvironment() {
        throw new BaseUnsupportedOperationException("ejb_1069");
    }

    public Identity getCallerIdentity() {
        throw new BaseUnsupportedOperationException("ejb_1070");
    }

    public boolean isCallerInRole(Identity role) {
        throw new BaseUnsupportedOperationException("ejb_1071");
    }

    public Principal getCallerPrincipal() {
        return this.callerPrincipal != null ? this.callerPrincipal : this.container.getSecurityContext().getPrincipal();
    }

    protected void setCallerPrincipal(Principal principal) {
        this.callerPrincipal = principal;
    }

    public boolean isCallerInRole(String roleReferenceName) {
        Hashtable secRoleReferences = this.getBaseContainer().getDescriptor().getRoleReferences();
        SecurityRoleReference secRoleRef = (SecurityRoleReference)secRoleReferences.get(roleReferenceName);
        if (secRoleRef == null) {
            return false;
        }
        String roleName = secRoleRef.getSecurityRoleName();
        SecurityRole securityRole = this.getBaseContainer().getSecurityRoleContext().getSecurityRole(roleName);
        if (securityRole == null) {
            return false;
        }
        return securityRole.isCallerInRole();
    }

    public UserTransaction getUserTransaction() {
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)p).put("domain", "true");
        try {
            return (UserTransaction)new InitialContext(p).lookup("UserTransaction");
        }
        catch (NamingException ne) {
            throw (RuntimeException)BaseContainer.traceError(new BaseRuntimeException("ejb_1009", ne));
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        try {
            this.container.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException se) {
            throw (RuntimeException)BaseContainer.traceError(new BaseRuntimeException("ejb_1009", se));
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        try {
            Transaction tran = this.getBaseContainer().getTransactionManager().getTransaction();
            return tran.getStatus() == 1;
        }
        catch (SystemException se) {
            throw (RuntimeException)BaseContainer.traceError(new BaseRuntimeException("ejb_1009", se));
        }
    }

    public abstract EJBLocalHome getEJBLocalHome();

    public abstract EJBHome getEJBHome();
}

