/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless_sp5;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.csiv2.EJBIORGeneratorInterface;
import com.sap.engine.interfaces.csiv2.IORDescriptor;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.interfaces.resourcecontext.ResourceContextFactory;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.ejb.ContainerBoot;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.RunAsPrivilegedAction;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.runtime.ContainerRuntime;
import com.sap.engine.services.ejb.session.stateless_sp5.BaseContext;
import com.sap.engine.services.ejb.session.stateless_sp5.InactiveContainerException;
import com.sap.engine.services.ejb.util.MonitoringInfo;
import com.sap.engine.services.ejb.util.debug.Log;
import com.sap.engine.services.ejb.util.pool.ContainerPool;
import com.sap.engine.services.ejb.util.pool.PoolUser;
import java.lang.reflect.Constructor;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;

public abstract class BaseContainer
extends PortableRemoteObject
implements ContainerBoot,
ContainerRuntime {
    private EJBHome ejbHome = null;
    private EJBLocalHome ejbLocalHome = null;
    private Environment environment = null;
    private String appName = null;
    private DeploymentDescriptor descriptor = null;
    private ClassLoader loader = null;
    private SecurityContext applicationSecurityContext = null;
    private Subject runAsSubject = null;
    private EJBIORGeneratorInterface iorGenerator = null;
    private SimpleProfileInterface iiopSimpleProfile = null;
    private MonitoringInfo monitoringInfo = null;
    private Class beanClass = null;
    private ContainerPool containerPool = null;
    private com.sap.engine.interfaces.resourcecontext.ResourceContext restrictedResourceContext = null;
    private boolean active = false;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$util$pool$PoolUser;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$Environment;
    static /* synthetic */ Class class$java$util$Properties;

    protected BaseContainer() throws RemoteException {
    }

    public ResourceContext getResourceContext() {
        this.assertActive();
        return this.getApplicationSecurityContext().getAuthorizationContext().getSecurityResourceContext();
    }

    public Environment getEnvironment() {
        this.assertActive();
        return this.environment;
    }

    public String getAppName() {
        this.assertActive();
        return this.appName;
    }

    public SecurityRoleContext getSecurityRoleContext() {
        this.assertActive();
        return this.getApplicationSecurityContext().getAuthorizationContext().getSecurityRoleContext();
    }

    protected DeploymentDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(DeploymentDescriptor _descriptor) {
        this.descriptor = _descriptor;
    }

    public ClassLoader getClassLoader() {
        this.assertActive();
        return this.loader;
    }

    protected void setClassLoader(ClassLoader _loader) {
        this.loader = _loader;
    }

    public MonitoringInfo getMonitoringInfo() {
        this.assertActive();
        if (this.monitoringInfo == null) {
            throw new IllegalStateException();
        }
        return this.monitoringInfo;
    }

    protected SecurityContext getApplicationSecurityContext() {
        return this.applicationSecurityContext;
    }

    public com.sap.engine.interfaces.resourcecontext.ResourceContext getRestrictedResourceContext() {
        this.assertActive();
        return this.restrictedResourceContext;
    }

    public ResourceContextFactory getResourceContextFactory() {
        this.assertActive();
        return this.getEnvironment().getResourceContextFactory();
    }

    public EJBHome getEJBHome() {
        this.assertActive();
        return this.ejbHome;
    }

    protected void setEJBHome(EJBHome home) {
        this.ejbHome = home;
    }

    public EJBLocalHome getEJBLocalHome() {
        this.assertActive();
        return this.ejbLocalHome;
    }

    protected void setEJBLocalHome(EJBLocalHome home) {
        this.ejbLocalHome = home;
    }

    public String getBeanName() {
        this.assertActive();
        return this.getDescriptor().getEjbName();
    }

    public Class getBeanClass() {
        this.assertActive();
        return this.beanClass;
    }

    protected void setBeanClass(Class _beanClass) {
        this.beanClass = _beanClass;
    }

    public com.sap.engine.lib.security.SecurityContext getSecurityContext() {
        this.assertActive();
        ThreadContext currentThread = this.getEnvironment().getThreadSystem().getThreadContext();
        int secId = this.getEnvironment().getSecurityContextObjectId();
        return (com.sap.engine.lib.security.SecurityContext)((Object)currentThread.getContextObject(secId));
    }

    public ContainerPool getContainerPool() {
        this.assertActive();
        if (this.containerPool == null) {
            throw new IllegalStateException();
        }
        return this.containerPool;
    }

    protected void destroyContainerPool() {
        this.containerPool.destroy();
        this.containerPool = null;
    }

    private void initBeanClass() {
        try {
            String className = this.getDescriptor().getRuntimeClassName();
            this.beanClass = this.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new BaseRuntimeException("ejb_1064", new Object[]{this.getBeanName()}, e);
        }
    }

    public TransactionManager getTransactionManager() {
        this.assertActive();
        return this.getEnvironment().getTransactionManager();
    }

    protected Properties getBeanProperties() {
        return this.getDescriptor().getBeanProperties();
    }

    public abstract void releaseActiveBean(BaseContext var1);

    protected int getContainerPoolProperty(int property) {
        switch (property) {
            case 1: {
                return this.getContainerPool().size();
            }
            case 2: {
                return this.getContainerPool().getMaxSize();
            }
            case 3: {
                return this.getContainerPool().getInitialCapacity();
            }
            case 4: {
                return this.getContainerPool().getResizeStep();
            }
            case 5: {
                return this.getContainerPool().used();
            }
        }
        throw new BaseIllegalArgumentException("ejb_1049", new Object[]{new Integer(property)});
    }

    public final void init(Environment environment, String appName, DeploymentDescriptor descriptor, ClassLoader loader) throws ContainerInitializationException {
        this.active = true;
        this.environment = environment;
        this.appName = appName;
        this.descriptor = descriptor;
        this.loader = loader;
        try {
            this.start();
        }
        catch (Throwable t) {
            this.active = false;
            throw new ContainerInitializationException("ejb_1007", new Object[]{"init"}, t);
        }
    }

    protected void start() throws Throwable {
        this.initMonitoringInfo();
        this.initSecurity();
        this.initBeanClass();
        this.initRemoteInterfacesInfrastructure();
        this.initLocalInterfacesInfrastructre();
        this.initRestrictedResourceContext();
    }

    public final void destroy() {
        this.assertActive();
        try {
            this.stop();
            Object var2_1 = null;
            this.active = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.active = false;
            throw throwable;
        }
    }

    protected void stop() {
        try {
            this.destroyRemoteInterfacesInfrastructure();
        }
        catch (Throwable any) {
            BaseContainer.traceError(any);
        }
        try {
            this.destroyRestrictedResourceContext();
        }
        catch (Throwable any) {
            BaseContainer.traceError(any);
        }
    }

    private void initMonitoringInfo() {
        this.monitoringInfo = new MonitoringInfo(this.getMonitorType());
    }

    protected abstract int getMonitorType();

    private void initSecurity() {
        SecurityIdentity secIdentity;
        String policyConfiguration = this.getAppName() + "*" + this.getDescriptor().getEJBJarDescriptor().getJarName();
        this.applicationSecurityContext = this.getEnvironment().getSecurityContext().getPolicyConfigurationContext(policyConfiguration);
        IORDescriptor[] iorDescriptors = this.getDescriptor().getIORDescriptors();
        if (iorDescriptors != null) {
            this.iorGenerator = this.getEnvironment().getIORGenerator();
            this.iiopSimpleProfile = this.iorGenerator.generateSecurityTaggedComponent(iorDescriptors);
        }
        if ((secIdentity = this.getDescriptor().getSecurityIdentity()) == null || secIdentity.isCallerIdentity()) {
            return;
        }
        RunAsIdentity runAsIdentity = secIdentity.getRunAsIdentity();
        UserStoreFactory userStoreFactory = this.getApplicationSecurityContext().getUserStoreContext();
        UserStore userStore = userStoreFactory.getActiveUserStore();
        UserContext userCtx = userStore.getUserContext();
        String userName = runAsIdentity.getUserName();
        if (userName == null) {
            String runAsRoleName = runAsIdentity.getSecurityRoleName();
            SecurityRole runAsRole = this.getSecurityRoleContext().getSecurityRole(runAsRoleName);
            String[] userNames = runAsRole.getUsers();
            if (userNames != null && userNames.length != 0) {
                userName = userNames[0];
            } else {
                String[] groupNames = runAsRole.getGroups();
                if (groupNames != null) {
                    GroupContext groupCtx = userStore.getGroupContext();
                    int i = 0;
                    while (i < groupNames.length) {
                        Iterator groupUsers = groupCtx.getGroupInfo(groupNames[i]).getUsersInGroup();
                        if (groupUsers != null && groupUsers.hasNext()) {
                            userName = (String)groupUsers.next();
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (userName == null) {
                throw new BaseRuntimeException("ejb_1066", new Object[]{runAsRoleName});
            }
        }
        UserInfo user = userCtx.getUserInfo(userName);
        this.runAsSubject = new Subject();
        RunAsPrivilegedAction runAsAction = new RunAsPrivilegedAction(userCtx, user, this.runAsSubject);
        AccessController.doPrivileged(runAsAction);
    }

    public Subject getRunAsSubject() {
        return this.runAsSubject;
    }

    private void initRestrictedResourceContext() {
        this.restrictedResourceContext = this.getResourceContextFactory().createRestrictedContext(this.getAppName(), "ejbContexts/" + this.getAppName() + "/" + this.descriptor.getJndiName());
    }

    private void destroyRestrictedResourceContext() {
        this.restrictedResourceContext.destroy();
    }

    public final void addIIOPSimpleProfile(PortableRemoteObject pro) {
        this.iorGenerator.addTaggedComponent(pro, this.iiopSimpleProfile);
    }

    protected void initRemoteInterfacesInfrastructure() throws Exception {
        String homeName = this.descriptor.getEjbHomeImpl();
        if (homeName == null) {
            return;
        }
        this.ejbHome = (EJBHome)this.createRemoteOrLocalHomeInstance(homeName);
        if (this.getDescriptor().getIORDescriptors() != null) {
            this.addIIOPSimpleProfile((PortableRemoteObject)this.ejbHome);
        }
    }

    protected void destroyRemoteInterfacesInfrastructure() {
        if (this.ejbHome != null) {
            try {
                PortableRemoteObject.unexportObject((Remote)this.ejbHome);
            }
            catch (NoSuchObjectException nsoe) {
                BaseContainer.traceError(nsoe);
            }
            this.ejbHome = null;
        }
    }

    protected void initLocalInterfacesInfrastructre() throws Exception {
        String localHomeName = this.descriptor.getEjbLocalHomeImpl();
        if (localHomeName != null) {
            this.ejbLocalHome = (EJBLocalHome)this.createRemoteOrLocalHomeInstance(localHomeName);
        }
    }

    private Object createRemoteOrLocalHomeInstance(String className) throws Exception {
        Class<?> cl = this.getClassLoader().loadClass(className);
        Constructor<?> cnstr = cl.getConstructor(this.getClass());
        return cnstr.newInstance(this);
    }

    protected final void createContainerPool(PoolUser poolUser) throws Exception {
        String poolClassName = null;
        poolClassName = this.getBeanProperties().getProperty("PoolClass", "com.sap.engine.services.ejb.util.pool.ContainerPoolImpl");
        Class<?> poolClass = Class.forName(poolClassName);
        Constructor<?> c = poolClass.getConstructor(class$com$sap$engine$services$ejb$util$pool$PoolUser == null ? (class$com$sap$engine$services$ejb$util$pool$PoolUser = BaseContainer.class$("com.sap.engine.services.ejb.util.pool.PoolUser")) : class$com$sap$engine$services$ejb$util$pool$PoolUser, class$com$sap$engine$services$ejb$Environment == null ? (class$com$sap$engine$services$ejb$Environment = BaseContainer.class$("com.sap.engine.services.ejb.Environment")) : class$com$sap$engine$services$ejb$Environment, class$java$util$Properties == null ? (class$java$util$Properties = BaseContainer.class$("java.util.Properties")) : class$java$util$Properties);
        this.containerPool = (ContainerPool)c.newInstance(poolUser, this.getEnvironment(), this.getBeanProperties());
    }

    protected final void initContainerPool() {
        this.getContainerPool().init();
    }

    protected final void assertActive() {
        if (!this.active) {
            throw new InactiveContainerException();
        }
    }

    public int getStoresNumber() {
        this.assertActive();
        return this.getMonitoringInfo().getStores();
    }

    public int getLoadsNumber() {
        this.assertActive();
        return this.getMonitoringInfo().getLoads();
    }

    public int getActivationsNumber() {
        this.assertActive();
        return this.getMonitoringInfo().getActivations();
    }

    public int getCreationsNumber() {
        this.assertActive();
        return this.getMonitoringInfo().getCreations();
    }

    public int getRemovalsNumber() {
        this.assertActive();
        return this.getMonitoringInfo().getRemovals();
    }

    public int getPassivationsNumber() {
        this.assertActive();
        return this.getMonitoringInfo().getPassivations();
    }

    public abstract int getType();

    public String getCurrentUser() {
        this.assertActive();
        Principal p = this.getSecurityContext().getPrincipal();
        return p == null ? "UNKNOWN" : p.getName();
    }

    public static Throwable traceError(Throwable t) {
        return Log.traceError(t);
    }

    public static Throwable traceInfo(Throwable t) {
        return Log.traceInfo(t);
    }

    public abstract void initPools() throws ContainerInitializationException;

    public abstract int getPoolProperty(int var1) throws RemoteException;

    public abstract int getSessionProperty(int var1) throws RemoteException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

