/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContextFactory;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.session.stateless.StatelessContainer;
import com.sap.engine.services.ejb.session.stateless.StatelessSessionContext;
import javax.ejb.SessionBean;
import javax.transaction.SystemException;

public class StatelessSessionContextFP
extends StatelessSessionContext {
    private ResourceContext resourceContext = null;

    public StatelessSessionContextFP(StatelessContainer cont, SessionBean instance) {
        super(cont, instance);
        String appName = cont.getApplicationName();
        String compName = "ejbContexts/" + appName + "/" + cont.getDescriptor().getJndiName();
        ResourceContextFactory resourceContextFactory = this.container.getEnvironment().getResourceContextFactory();
        this.resourceContext = resourceContextFactory.createContext(appName, compName, true);
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.method < 3) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1073", new Object[]{"setRollbackOnly()"});
            toThrow.log();
            throw toThrow;
        }
        if (this.getContainer().getDescriptor().getTransactionType() == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1074");
            toThrow.log();
            throw toThrow;
        }
        if (this.resourceContext.getTransaction() == null) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1075");
            toThrow.log();
            throw toThrow;
        }
        try {
            this.resourceContext.getTransaction().setRollbackOnly();
        }
        catch (SystemException se) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1076", new Object[]{"setRollbackOnly()"});
            toThrow.log();
            throw toThrow;
        }
    }

    public void destroySession() {
        super.destroySession();
        this.resourceContext.destroy();
    }
}

