/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless;

import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.session.BasicSessionContext;
import com.sap.engine.services.ejb.session.EJBHomeImpl;
import com.sap.engine.services.ejb.session.EJBLocalHomeImpl;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.session.SessionContainer;
import com.sap.engine.services.ejb.session.stateless.StatelessContainer;
import com.sap.engine.services.ejb.session.stateless.StatelessEJBHomeImpl;
import com.sap.engine.services.ejb.session.stateless.StatelessEJBLocalHomeImpl;
import java.rmi.RemoteException;
import java.security.Principal;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class StatelessSessionContext
extends BasicSessionContext {
    Session sesObject = null;
    StatelessContainer container = null;
    boolean destroyed = false;

    public StatelessSessionContext(StatelessContainer cont, SessionBean instance) {
        this.bean = instance;
        this.container = cont;
        String appName = cont.getApplicationName();
        String compName = "ejbContexts/" + appName + "/" + cont.getDescriptor().getJndiName();
        int isolationLevel = this.container.getDescriptor().getIsolationLevel();
        this.resource = isolationLevel == -1 ? new ResourceSetImpl(appName, compName) : new ResourceSetImpl(appName, compName, isolationLevel);
    }

    public SessionBean getInstance(Session sObj) {
        this.sesObject = sObj;
        return this.bean;
    }

    public void clearSessionObject() {
        this.sesObject = null;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        if (this.method < 2) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1031", new Object[]{"getEJBLocalObject()"});
            toThrow.log();
            throw toThrow;
        }
        EJBLocalObject locObject = null;
        try {
            Session tempSession = this.container.startSession();
            EJBLocalHomeImpl ejbLocHome = (EJBLocalHomeImpl)this.container.getEJBLocalHome();
            try {
                locObject = ejbLocHome.createEJBLocalObject(tempSession);
                tempSession.setLocalObject(locObject);
                return locObject;
            }
            catch (NullPointerException npe) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1032");
                toThrow.log();
                throw toThrow;
            }
        }
        catch (NoSuchSessionException nsse) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1033", (Throwable)((Object)nsse));
            toThrow.log();
            throw toThrow;
        }
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        if (this.method < 2) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1028", new Object[]{"getEJBObject()"});
            toThrow.log();
            throw toThrow;
        }
        EJBObject remObject = null;
        try {
            Session tempSession = this.container.startSession();
            EJBHomeImpl ejbHome = (EJBHomeImpl)this.container.getEJBHome();
            try {
                remObject = ejbHome.createEJBObject(tempSession);
                tempSession.setObject(remObject);
                return remObject;
            }
            catch (NullPointerException npe) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1029");
                toThrow.log();
                throw toThrow;
            }
            catch (RemoteException remEx) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1029", remEx.detail);
                toThrow.log();
                throw toThrow;
            }
        }
        catch (NoSuchSessionException nsse) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1033", (Throwable)((Object)nsse));
            toThrow.log();
            throw toThrow;
        }
    }

    public SessionContainer getContainer() {
        return this.container;
    }

    public Principal getCallerPrincipal() {
        if (this.method < 3) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1026", new Object[]{"getCallerPrincipal()"});
            toThrow.log();
            throw toThrow;
        }
        return super.getCallerPrincipal();
    }

    public boolean isCallerInRole(String roleName) {
        if (this.method < 3) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1027", new Object[]{"isCallerInRole(String)"});
            toThrow.log();
            throw toThrow;
        }
        return super.isCallerInRole(roleName);
    }

    public void begin(Transaction t) {
        try {
            this.resource.enlistAll(t);
        }
        catch (Exception e) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1050", e);
            toThrow.log();
            throw toThrow;
        }
    }

    public void end() {
        try {
            this.resource.delistAll(0x4000000);
        }
        catch (SystemException se) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1051", se);
            toThrow.log();
            throw toThrow;
        }
    }

    public void destroySession() {
        if (!this.destroyed) {
            try {
                try {
                    EJBHome home = this.container.getEJBHome();
                    if (home != null) {
                        ((StatelessEJBHomeImpl)home).removeBean(this);
                    } else {
                        home = this.container.getEJBLocalHome();
                        if (home != null) {
                            ((StatelessEJBLocalHomeImpl)home).removeBean(this);
                        } else {
                            BaseRuntimeException toThrow = new BaseRuntimeException("ejb_1052");
                            toThrow.log();
                            throw toThrow;
                        }
                    }
                    Object var4_5 = null;
                    this.destroyed = true;
                }
                catch (RemoteException re) {
                    BaseRuntimeException toThrow = new BaseRuntimeException("ejb_1053");
                    toThrow.log();
                    throw toThrow;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.destroyed = true;
                throw throwable;
            }
        }
    }
}

