/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless;

import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.session.SessionContainer;
import com.sap.engine.services.ejb.session.SessionEJBLocalObjectImpl;
import com.sap.engine.services.ejb.session.SessionEJBObjectImpl;
import com.sap.engine.services.ejb.session.stateless.StatelessContainer;
import com.sap.engine.services.ejb.session.stateless.StatelessSessionContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class StatelessSession
implements Session {
    private StatelessContainer container = null;
    private long sessionKey = -1L;
    private int invocations = 1;
    private EJBObject ejbObject = null;
    private EJBLocalObject ejbLocalObject = null;

    public StatelessSession(StatelessContainer cont, long sesKey) {
        this.sessionKey = sesKey;
        this.container = cont;
    }

    public EJBObject getObject() {
        return this.ejbObject;
    }

    public void setObject(EJBObject ejbObj) {
        this.ejbObject = ejbObj;
    }

    public EJBLocalObject getLocalObject() {
        return this.ejbLocalObject;
    }

    public void setLocalObject(EJBLocalObject ejbLocObj) {
        this.ejbLocalObject = ejbLocObj;
    }

    public SessionContainer getContainer() {
        return this.container;
    }

    public long getSessionKey() {
        return this.sessionKey;
    }

    public synchronized StatelessSessionContext getContext() {
        ++this.invocations;
        return this.container.getContext();
    }

    public synchronized void releaseInstance(StatelessSessionContext context) {
        context.clearSessionObject();
        this.container.releaseInstance(context);
    }

    public synchronized void failInstance(StatelessSessionContext context) {
        context.clearSessionObject();
        this.container.failInstance(context);
    }

    public void destroySession() {
        try {
            if (this.ejbObject != null) {
                ((SessionEJBObjectImpl)this.ejbObject).unexportSession();
            }
            if (this.ejbLocalObject != null) {
                ((SessionEJBLocalObjectImpl)this.ejbLocalObject).unexportSession();
            }
            this.ejbObject = null;
            this.ejbLocalObject = null;
        }
        catch (Exception e) {
            this.container.logError("Exception during destroySession().", e);
        }
        this.container = null;
    }

    public void destroySessionWithoutRemove() {
        this.destroySession();
    }

    public synchronized void checkState() {
        if (this.invocations == 0) {
            this.container.stopSession(this);
        } else {
            this.invocations = 0;
        }
    }
}

