/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless;

import com.sap.engine.interfaces.cross.Redirectable;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchObjectException;
import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.session.SessionEJBObjectImpl;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;

public abstract class StatelessEJBObjectImpl
extends SessionEJBObjectImpl
implements Redirectable {
    public StatelessEJBObjectImpl(Session session) throws RemoteException {
        super(session);
    }

    public boolean isIdentical(EJBObject ejbObject) throws RemoteException {
        String home1 = ejbObject.getEJBHome().getEJBMetaData().getHomeInterfaceClass().getName();
        String home2 = this.getEJBHome().getEJBMetaData().getHomeInterfaceClass().getName();
        return home1.equals(home2);
    }

    public void remove() throws RemoveException, RemoteException {
        try {
            this.session.getContainer().stopSession(this.session);
        }
        catch (NullPointerException npe) {
            BaseNoSuchObjectException toThrow = new BaseNoSuchObjectException("ejb_1006");
            toThrow.log();
            throw toThrow;
        }
    }

    public String ejbGetID() {
        String jndiName = this.session.getContainer().getDescriptor().getJndiName();
        long sessionKey = this.session.getSessionKey();
        return jndiName + "*" + sessionKey;
    }

    public abstract String getIdentifier();
}

