/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.stateless.StatelessContainer;
import com.sap.engine.services.ejb.session.stateless.StatelessEJBHomeImpl;
import com.sap.engine.services.ejb.session.stateless.StatelessEJBLocalHomeImpl;
import com.sap.engine.services.ejb.session.stateless.StatelessSessionContext;
import com.sap.engine.services.ejb.session.stateless.StatelessSessionContextFP;
import java.rmi.RemoteException;
import javax.ejb.SessionBean;

public class StatelessContainerFP
extends StatelessContainer {
    private ResourceContext restrictedResourceContext = null;

    public void init(Environment e, String appName, DeploymentDescriptor descr, ClassLoader loader) throws ContainerInitializationException {
        super.init(e, appName, descr, loader);
        this.restrictedResourceContext = this.env.getResourceContextFactory().createRestrictedContext(appName, "ejbContexts/" + this.applicationName + "/" + this.descriptor.getJndiName());
    }

    public ResourceContext getRestrictedResourceContext() {
        return this.restrictedResourceContext;
    }

    public StatelessSessionContext createContext() {
        SessionBean inst = null;
        try {
            inst = this.createBean();
        }
        catch (NoSuchSessionException nse) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1046", (Throwable)((Object)nse));
            toThrow.log();
            throw toThrow;
        }
        StatelessSessionContextFP ctx = new StatelessSessionContextFP(this, inst);
        if (this.ejbHome != null) {
            ((StatelessEJBHomeImpl)this.ejbHome).initSessionBean(inst, ctx);
        } else {
            ((StatelessEJBLocalHomeImpl)this.ejbLocalHome).initSessionBean(inst, ctx);
        }
        return ctx;
    }

    public void destroy() {
        super.destroy();
        this.restrictedResourceContext.destroy();
    }
}

