/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateless;

import com.sap.engine.interfaces.cross.CrossObjectFactory;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.session.EJBHomeImpl;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.session.SessionContainer;
import com.sap.engine.services.ejb.session.stateless.StatelessEJBHomeImpl;
import com.sap.engine.services.ejb.session.stateless.StatelessEJBLocalHomeImpl;
import com.sap.engine.services.ejb.session.stateless.StatelessSession;
import com.sap.engine.services.ejb.session.stateless.StatelessSessionContext;
import com.sap.engine.services.ejb.util.MonitoringInfo;
import com.sap.engine.services.ejb.util.pool.ContainerPool;
import com.sap.engine.services.ejb.util.pool.PoolUser;
import com.sap.engine.services.ejb.util.pool.StackException;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;

public class StatelessContainer
extends SessionContainer
implements PoolUser,
CrossObjectFactory {
    private ContainerPool pool = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$util$pool$PoolUser;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$Environment;
    static /* synthetic */ Class class$java$util$Properties;

    public void init(Environment e, String appName, DeploymentDescriptor descr, ClassLoader loader) throws ContainerInitializationException {
        super.init(e, appName, descr, loader);
        e.getCrossInterface().registerObjectFactory(this.descriptor.getJndiName(), this);
        this.monitoringInfo = new MonitoringInfo(1);
        String name = null;
        Properties beanProps = descr.getBeanProperties();
        try {
            name = beanProps.getProperty("PoolClass");
        }
        catch (Exception ex) {
            name = "com.sap.engine.services.ejb.util.pool.ContainerPoolImpl";
        }
        if (name == null) {
            name = "com.sap.engine.services.ejb.util.pool.ContainerPoolImpl";
        }
        try {
            Class<?> poolClass = Class.forName(name);
            Constructor<?> c = poolClass.getConstructor(class$com$sap$engine$services$ejb$util$pool$PoolUser == null ? (class$com$sap$engine$services$ejb$util$pool$PoolUser = StatelessContainer.class$("com.sap.engine.services.ejb.util.pool.PoolUser")) : class$com$sap$engine$services$ejb$util$pool$PoolUser, class$com$sap$engine$services$ejb$Environment == null ? (class$com$sap$engine$services$ejb$Environment = StatelessContainer.class$("com.sap.engine.services.ejb.Environment")) : class$com$sap$engine$services$ejb$Environment, class$java$util$Properties == null ? (class$java$util$Properties = StatelessContainer.class$("java.util.Properties")) : class$java$util$Properties);
            this.pool = (ContainerPool)c.newInstance(this, this.getEnvironment(), beanProps);
        }
        catch (Exception ex) {
            ContainerInitializationException toThrow = new ContainerInitializationException("ejb_1044", ex);
            toThrow.log();
            throw toThrow;
        }
        catch (NoClassDefFoundError ncdfe) {
            ContainerInitializationException toThrow = new ContainerInitializationException("ejb_1044", ncdfe);
            toThrow.log();
            throw toThrow;
        }
    }

    public void initPools() throws ContainerInitializationException {
        try {
            this.pool.init();
        }
        catch (StackException sex) {
            throw new ContainerInitializationException("ejb_1045", sex.getTarget());
        }
    }

    public StatelessSessionContext getContext() {
        try {
            return (StatelessSessionContext)this.pool.pop();
        }
        catch (StackException empSt) {
            BaseRuntimeException toThrow = new BaseRuntimeException("ejb_1025", empSt.getTarget());
            toThrow.log();
            throw toThrow;
        }
    }

    public StatelessSessionContext createContext() {
        SessionBean inst = null;
        try {
            inst = this.createBean();
        }
        catch (NoSuchSessionException nse) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1046", (Throwable)((Object)nse));
            toThrow.log();
            throw toThrow;
        }
        StatelessSessionContext ctx = new StatelessSessionContext(this, inst);
        if (this.ejbHome != null) {
            ((StatelessEJBHomeImpl)this.ejbHome).initSessionBean(inst, ctx);
        } else {
            ((StatelessEJBLocalHomeImpl)this.ejbLocalHome).initSessionBean(inst, ctx);
        }
        return ctx;
    }

    public void releaseInstance(StatelessSessionContext context) {
        this.pool.push((Object)context);
    }

    public void failInstance(StatelessSessionContext context) {
        this.pool.fail();
    }

    protected Session createSession(long sessionKey) throws NoSuchSessionException {
        return new StatelessSession(this, sessionKey);
    }

    public void fail() {
        this.pool.fail();
    }

    public void destroy() {
        this.getEnvironment().getCrossInterface().unregisterObjectFactory(this.descriptor.getJndiName());
        this.pool.destroy();
        this.pool = null;
        super.destroy();
    }

    public Object getObject(String name) {
        try {
            if (name.startsWith(SessionContainer._OBJECT_)) {
                Session session = this.startSession();
                EJBObject obj = ((EJBHomeImpl)this.getEJBHome()).createEJBObject(session);
                session.setObject(obj);
                return obj;
            }
            if (name.startsWith(SessionContainer._HOME_)) {
                return this.ejbHome;
            }
            return null;
        }
        catch (Exception ex) {
            this.logError(ex);
            return null;
        }
    }

    public void destroyObject(Object obj) {
        ((StatelessSessionContext)obj).destroySession();
    }

    public Object createObject() {
        return this.createContext();
    }

    public Object restoreSession(long oldKey, Hashtable map) throws RemoteException {
        try {
            Session session = null;
            Long oldd = new Long(oldKey);
            Long neww = (Long)map.get(oldd);
            if (neww != null) {
                long newKey = neww;
                session = this.findBySessionKey(newKey);
                return session.getObject();
            }
            session = this.startSession();
            long newKey = session.getSessionKey();
            map.put(oldd, new Long(newKey));
            if (this.ejbLocalHome != null) {
                EJBLocalObject localObject = ((StatelessEJBLocalHomeImpl)this.ejbLocalHome).createEJBLocalObject(session);
                session.setLocalObject(localObject);
                return localObject;
            }
            EJBObject remObject = ((StatelessEJBHomeImpl)this.ejbHome).createEJBObject(session);
            session.setObject(remObject);
            return remObject;
        }
        catch (Exception exc) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1036", exc);
            toThrow.log();
            throw toThrow;
        }
    }

    public int getSessionProperty(int property) {
        switch (property) {
            case 1: {
                return this.descriptor.getSessionTimeout();
            }
            case 2: {
                return this.descriptor.getStatefulTimeout();
            }
            case 4: {
                return -1;
            }
            case 3: {
                return this.base.size();
            }
            case 5: {
                return this.completedSessionsCount;
            }
        }
        EJBResourceAccessor.location.log(500, EJBResourceAccessor.category, (Object)"ejb_1085", new Object[]{new Integer(property)});
        return -1;
    }

    public int getPoolProperty(int property) {
        switch (property) {
            case 1: {
                return this.pool.size();
            }
            case 2: {
                return this.pool.getMaxSize();
            }
            case 3: {
                return this.pool.getInitialCapacity();
            }
            case 4: {
                return this.pool.getResizeStep();
            }
            case 5: {
                return this.pool.used();
            }
        }
        EJBResourceAccessor.location.log(500, EJBResourceAccessor.category, (Object)"ejb_1049", new Object[]{new Integer(property)});
        return -1;
    }

    public int getType() throws RemoteException {
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

