/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateful;

import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.lib.util.base.PrevItem;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.engine.services.ejb.EJBContainerEventListener;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.session.BasicSessionContext;
import com.sap.engine.services.ejb.session.EJBHomeImpl;
import com.sap.engine.services.ejb.session.EJBLocalHomeImpl;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.SessionContainer;
import com.sap.engine.services.ejb.session.SessionEJBLocalObjectImpl;
import com.sap.engine.services.ejb.session.SessionEJBObjectImpl;
import com.sap.engine.services.ejb.session.stateful.StatefulContainer;
import com.sap.engine.services.ejb.session.stateful.StatefulEJBLocalObjectImpl;
import com.sap.engine.services.ejb.session.stateful.StatefulEJBObjectImpl;
import com.sap.engine.services.ejb.session.stateful.StatefulSession;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;

public class StatefulSessionContext
extends BasicSessionContext
implements StatefulSession,
EJBContainerEventListener,
TimeoutListener {
    private static final long DEF_STATEFUL_TIMEOUT = 3600000L;
    private static final String PASSIVATED = "_passivated_";
    protected static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$session$stateful$StatefulSessionContext == null ? (class$com$sap$engine$services$ejb$session$stateful$StatefulSessionContext = StatefulSessionContext.class$("com.sap.engine.services.ejb.session.stateful.StatefulSessionContext")) : class$com$sap$engine$services$ejb$session$stateful$StatefulSessionContext));
    protected EJBObject ejbObject = null;
    protected EJBLocalObject ejbLocalObject = null;
    protected StatefulContainer container = null;
    protected NextItem next = null;
    protected PrevItem prev = null;
    private TimeoutManager timeoutService = null;
    private boolean stopped = false;
    private long sessionKey;
    private boolean locked = false;
    private boolean passivated = false;
    protected boolean passivatedByFailover = false;
    private int invocations = 1;
    private long timeout = 0L;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$session$stateful$StatefulSessionContext;

    public StatefulSessionContext(StatefulContainer container, long addressKey) throws NoSuchSessionException {
        this.sessionKey = addressKey;
        this.container = container;
        this.bean = container.createBean();
        container.getEnvironment().registerContainerListener(this, "timeout");
        String appName = container.getApplicationName();
        String compName = "ejbContexts/" + appName + "/" + container.getDescriptor().getJndiName();
        int isolationLevel = container.getDescriptor().getIsolationLevel();
        this.resource = isolationLevel == -1 ? new ResourceSetImpl(appName, compName) : new ResourceSetImpl(appName, compName, isolationLevel);
        this.timeout = 1000 * container.getDescriptor().getStatefulTimeout();
        if (this.timeout == 0L) {
            this.timeout = 3600000L;
        }
    }

    public void startFunctionalityRelatedToService(Object serviceInterface) {
        this.timeoutService = (TimeoutManager)serviceInterface;
        if (this.isPassivated()) {
            this.timeoutService.registerTimeoutListener((TimeoutListener)this, this.timeout, 0L, false);
        }
    }

    public void stopFunctionalityRelatedToService(String serviceName) {
        this.timeoutService = null;
    }

    public long getSessionKey() {
        return this.sessionKey;
    }

    public SessionContainer getContainer() {
        return this.container;
    }

    public EJBLocalObject getLocalObject() {
        return this.ejbLocalObject;
    }

    public void setLocalObject(EJBLocalObject lo) {
        this.ejbLocalObject = lo;
    }

    public EJBObject getObject() {
        return this.ejbObject;
    }

    public void setObject(EJBObject o) {
        this.ejbObject = o;
    }

    public void passivate() {
        this.callEJBPassivate();
        boolean useStatefulFailover = this.container.getDescriptor().useStatefulFailover();
        if (!useStatefulFailover && !this.container.serializeSession(PASSIVATED + this.container.getServerId() + "_" + this.sessionKey, this.bean)) {
            this.destroySessionWithoutRemove();
            return;
        }
        this.bean = null;
        this.passivated = true;
        if (this.timeoutService != null) {
            this.timeoutService.registerTimeoutListener((TimeoutListener)this, this.timeout, 0L, false);
        }
    }

    public SessionBean getInstanceForSerialization() {
        if (this.container.passivateByFailover) {
            this.callEJBPassivate();
            this.passivatedByFailover = true;
        }
        return this.bean;
    }

    private void callEJBPassivate() {
        try {
            if (this.ejbObject != null) {
                ((StatefulEJBObjectImpl)this.ejbObject).passivateBean(this.bean);
            } else {
                ((StatefulEJBLocalObjectImpl)this.ejbLocalObject).passivateBean(this.bean);
            }
        }
        catch (Exception t) {
            this.destroySessionWithoutRemove();
            LOCATION.traceThrowableT(500, "", (Throwable)t);
        }
    }

    public void timeout() {
        try {
            this.readFromStream();
            this.container.decreasePassivated();
        }
        catch (NoSuchSessionException nsse) {
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)nsse));
        }
        this.unexportSession();
    }

    public boolean check() {
        return true;
    }

    protected void begin() throws EJBException {
        StatefulSessionContext statefulSessionContext = this;
        synchronized (statefulSessionContext) {
            if (this.locked) {
                if (this.stopped) {
                    throw new BaseEJBException("ejb_1023");
                }
                throw new BaseEJBException("ejb_1024");
            }
            this.locked = true;
            try {
                if (this.isPassivated()) {
                    this.activate();
                    this.container.decreasePassivated();
                } else if (this.passivatedByFailover) {
                    this.callEJBActivate();
                    this.passivatedByFailover = false;
                }
            }
            catch (NoSuchSessionException nss) {
                throw new BaseEJBException("ejb_1025", (Throwable)((Object)nss));
            }
        }
        this.container.accessedSession(this);
        ++this.invocations;
    }

    protected void beginWithNoPassivation() throws EJBException {
        StatefulSessionContext statefulSessionContext = this;
        synchronized (statefulSessionContext) {
            if (this.locked) {
                if (this.stopped) {
                    throw new BaseEJBException("ejb_1023");
                }
                throw new BaseEJBException("ejb_1024");
            }
            this.locked = true;
        }
        ++this.invocations;
    }

    protected synchronized void end(boolean fatal) {
        if (fatal) {
            this.destroySessionWithoutRemove();
        }
        this.locked = false;
    }

    private void unexportSession() {
        if (this.ejbObject != null) {
            ((SessionEJBObjectImpl)this.ejbObject).unexportSession();
        }
        if (this.ejbLocalObject != null) {
            ((SessionEJBLocalObjectImpl)this.ejbLocalObject).unexportSession();
        }
        this.ejbObject = null;
        this.ejbLocalObject = null;
    }

    public void destroySession() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        try {
            if (this.ejbObject != null) {
                ((StatefulEJBObjectImpl)this.ejbObject).removeBean(this.bean);
            }
            if (this.ejbLocalObject != null) {
                ((StatefulEJBLocalObjectImpl)this.ejbLocalObject).removeBean(this.bean);
            }
        }
        catch (Exception remvEx) {
            this.bean = null;
            LOCATION.traceThrowableT(500, "", (Throwable)remvEx);
        }
        this.unexportSession();
        this.container.getEnvironment().unregisterContainerListener(this, "timeout");
        if (this.isPassivated() && this.timeoutService != null) {
            this.timeoutService.unregisterTimeoutListener(this);
        }
        if (this.container.getDescriptor().useStatefulFailover()) {
            this.container.deleteInstanceFromPersistentStorage(this.container.getServerId() + "_" + this.sessionKey);
        }
    }

    public void destroySessionWithoutRemove() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.unexportSession();
        this.container.getEnvironment().unregisterContainerListener(this, "timeout");
        if (this.isPassivated() && this.timeoutService != null) {
            this.timeoutService.unregisterTimeoutListener(this);
        }
    }

    public EJBObject getEJBObject() {
        if (this.method < 2) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1028", new Object[]{"getEJBObject()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (this.ejbObject == null) {
            EJBHomeImpl ejbHomeImpl = (EJBHomeImpl)this.container.getEJBHome();
            if (ejbHomeImpl == null) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1029");
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
            try {
                this.ejbObject = ejbHomeImpl.createEJBObject(this);
                return this.ejbObject;
            }
            catch (RemoteException remEx) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1030", remEx.detail);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
        }
        return this.ejbObject;
    }

    public EJBLocalObject getEJBLocalObject() {
        if (this.method < 2) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1031", new Object[]{"getEJBLocalObject()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (this.ejbLocalObject == null) {
            EJBLocalHomeImpl ejbLocalHomeImpl = (EJBLocalHomeImpl)this.container.getEJBLocalHome();
            if (ejbLocalHomeImpl == null) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1032");
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
            try {
                this.ejbLocalObject = ejbLocalHomeImpl.createEJBLocalObject(this);
                return this.ejbLocalObject;
            }
            catch (EJBException ejbEx) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1033", ejbEx);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
        }
        return this.ejbLocalObject;
    }

    protected boolean notReadyForPassivate() {
        return this.stopped || this.isPassivated();
    }

    private void readFromStream() throws NoSuchSessionException {
        try {
            boolean useStatefulFailover = this.container.getDescriptor().useStatefulFailover();
            if (useStatefulFailover) {
                String identifier = ((StatefulEJBObjectImpl)this.ejbObject).getFailoverID();
                this.bean = this.container.readBeanFromPersistentStorage(identifier);
            } else {
                this.bean = this.container.readBeanFromPersistentStorage(PASSIVATED + this.container.getServerId() + "_" + this.sessionKey);
                this.container.deleteInstanceFromPersistentStorage(PASSIVATED + this.container.getServerId() + "_" + this.sessionKey);
            }
            this.passivated = false;
        }
        catch (PersistentStorageException pexc) {
            throw new NoSuchSessionException("ejb_1039", pexc);
        }
    }

    protected boolean isPassivated() {
        return this.passivated;
    }

    private void activate() throws NoSuchSessionException {
        if (this.timeoutService != null) {
            this.timeoutService.unregisterTimeoutListener(this);
        }
        this.readFromStream();
        this.callEJBActivate();
        this.container.activateSession(this);
    }

    private void callEJBActivate() throws NoSuchSessionException {
        try {
            if (this.ejbObject != null) {
                ((StatefulEJBObjectImpl)this.ejbObject).activateBean(this.bean);
            } else {
                ((StatefulEJBLocalObjectImpl)this.ejbLocalObject).activateBean(this.bean);
            }
        }
        catch (Exception e) {
            this.bean = null;
            this.destroySessionWithoutRemove();
            throw new NoSuchSessionException("ejb_1040", e);
        }
    }

    public void checkState() {
        if (this.invocations == 0) {
            try {
                this.lock();
                this.container.stopSession(this);
            }
            catch (EJBException ejbexc) {
                LOCATION.traceThrowableT(500, "", (Throwable)ejbexc);
            }
        } else {
            this.invocations = 0;
        }
    }

    protected void setBean(SessionBean _bean) {
        this.bean = _bean;
    }

    private synchronized void lock() {
        if (this.locked) {
            throw new BaseEJBException("ejb_1041");
        }
        this.locked = true;
    }

    public void setNext(NextItem item) {
        this.next = item;
    }

    public NextItem getNext() {
        return this.next;
    }

    public void setPrev(PrevItem item) {
        this.prev = item;
    }

    public PrevItem getPrev() {
        return this.prev;
    }

    public void clearItem() {
        this.prev = null;
        this.next = null;
    }

    public Object clone() {
        BaseEJBException toThrow = new BaseEJBException("ejb_1020");
        LOCATION.traceThrowableT(500, "", (Throwable)((Object)toThrow));
        throw toThrow;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

