/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateful;

import com.sap.engine.interfaces.ejb.serialization.EJBSerializable;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchObjectException;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.exceptions.BaseRemoveException;
import com.sap.engine.services.ejb.session.BasicSessionContext;
import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.session.SessionEJBObjectImpl;
import com.sap.engine.services.ejb.session.stateful.MethodNames;
import com.sap.engine.services.ejb.session.stateful.StatefulContainer;
import com.sap.engine.services.ejb.session.stateful.StatefulSession;
import com.sap.engine.services.ejb.session.stateful.StatefulSessionContext;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.StubImpl;
import com.sap.tc.logging.Location;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import javax.transaction.Transaction;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public abstract class StatefulEJBObjectImpl
extends SessionEJBObjectImpl
implements EJBSerializable,
MethodNames {
    protected static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$session$stateful$StatefulEJBObjectImpl == null ? (class$com$sap$engine$services$ejb$session$stateful$StatefulEJBObjectImpl = StatefulEJBObjectImpl.class$("com.sap.engine.services.ejb.session.stateful.StatefulEJBObjectImpl")) : class$com$sap$engine$services$ejb$session$stateful$StatefulEJBObjectImpl));
    protected String failoverID = "";
    static /* synthetic */ Class class$com$sap$engine$services$ejb$session$stateful$StatefulEJBObjectImpl;

    public StatefulEJBObjectImpl(Session session) throws RemoteException {
        super(session);
    }

    public boolean isIdentical(EJBObject ejbObject) throws RemoteException {
        try {
            if (ejbObject instanceof Stub) {
                Tie tie = Util.getTie((Remote)((Remote)((java.lang.Object)this)));
                ORB.init().connect((Object)tie);
                Stub thisStub = (Stub)PortableRemoteObject.toStub((Remote)((Remote)((java.lang.Object)this)));
                thisStub = (Stub)PortableRemoteObject.narrow((java.lang.Object)thisStub, (Class)this.getRemoteInterfaceClass());
                if (tie.orb() != null) {
                    thisStub.connect(tie.orb());
                }
                return thisStub.equals((java.lang.Object)ejbObject);
            }
            if (ejbObject instanceof StubImpl) {
                P4ObjectBroker p4OB = P4ObjectBroker.init();
                P4RemoteObject ro = p4OB.loadObject((Remote)((java.lang.Object)this));
                StubImpl thisStub = (StubImpl)p4OB.narrow(p4OB.stringToObject(p4OB.objectToString(ro)), this.getRemoteInterfaceClass());
                return thisStub.equals(ejbObject);
            }
            return this.equals(ejbObject);
        }
        catch (Exception exc) {
            LOCATION.traceThrowableT(500, "", (Throwable)exc);
            return false;
        }
    }

    public void remove() throws RemoteException, RemoveException {
        if (this.session == null) {
            BaseNoSuchObjectException toThrow = new BaseNoSuchObjectException("ejb_1006");
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (((StatefulSessionContext)this.session).resource.getTransaction() != null) {
            BaseRemoveException toThrow = new BaseRemoveException("ejb_1017");
            LOCATION.traceThrowableT(500, "", (Throwable)((java.lang.Object)toThrow));
            throw toThrow;
        }
        this.session.getContainer().stopSession(this.session);
    }

    protected void completeTx(boolean app, boolean fatal, Transaction t, boolean owner) throws RemoteException {
        try {
            if (owner) {
                if (!fatal && t.getStatus() != 1) {
                    t.commit();
                } else {
                    t.rollback();
                }
            } else if (t != null && fatal) {
                t.setRollbackOnly();
            }
        }
        catch (Exception e) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1010", new java.lang.Object[]{"completeTx"}, e);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    protected void completeTxWithFailover(boolean fatal, Transaction t) throws RemoteException {
        try {
            if (t != null && fatal) {
                t.setRollbackOnly();
            }
            if (t == null) {
                StatefulContainer container = (StatefulContainer)this.session.getContainer();
                container.serializeSession(this.failoverID, ((StatefulSession)this.session).getInstance());
            }
        }
        catch (Exception e) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1010", new java.lang.Object[]{"completeTxWithFailover"}, e);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    public String ejbGetID() {
        String jndiName = this.session.getContainer().getDescriptor().getJndiName();
        long sessionKey = this.session.getSessionKey();
        String id = "&STATEFUL&" + jndiName + "*" + sessionKey;
        return id;
    }

    public void passivateBean(SessionBean bean) throws EJBException, RemoteException {
        ((BasicSessionContext)((java.lang.Object)this.session)).setMethod(2);
        ResourceSet myResSet = ((BasicSessionContext)((java.lang.Object)this.session)).resource;
        String methName = myResSet.setMethodName("ejbPassivate()");
        ResourceSet rset = ResourceSetContextObject.replaceCurrentResourceSet(myResSet);
        try {
            this.session.getContainer().getMonitoringInfo().updatePassivations();
            bean.ejbPassivate();
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rset);
            myResSet.setMethodName(methName);
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rset);
        myResSet.setMethodName(methName);
    }

    public void activateBean(SessionBean bean) throws EJBException, RemoteException {
        ((BasicSessionContext)((java.lang.Object)this.session)).setMethod(2);
        ResourceSet myResSet = ((BasicSessionContext)((java.lang.Object)this.session)).resource;
        String methName = myResSet.setMethodName("ejbActivate()");
        ResourceSet rset = ResourceSetContextObject.replaceCurrentResourceSet(myResSet);
        try {
            this.session.getContainer().getMonitoringInfo().updateActivations();
            bean.ejbActivate();
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rset);
            myResSet.setMethodName(methName);
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rset);
        myResSet.setMethodName(methName);
    }

    public void removeBean(SessionBean bean) throws EJBException, RemoteException {
        ((BasicSessionContext)((java.lang.Object)this.session)).setMethod(2);
        ResourceSet myResSet = ((BasicSessionContext)((java.lang.Object)this.session)).resource;
        String methName = myResSet.setMethodName("ejbRemove()");
        ResourceSet rset = ResourceSetContextObject.replaceCurrentResourceSet(myResSet);
        try {
            this.session.getContainer().getMonitoringInfo().updateRemovals();
            bean.ejbRemove();
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rset);
            myResSet.setMethodName(methName);
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rset);
        myResSet.setMethodName(methName);
    }

    private Class getRemoteInterfaceClass() throws Exception {
        ClassLoader classLoader = this.session.getContainer().getClassLoader();
        return classLoader.loadClass(this.session.getContainer().getDescriptor().getRemoteInterface());
    }

    public String getFailoverID() {
        return this.failoverID;
    }

    public void setFailoverID(String _failoverID) {
        this.failoverID = _failoverID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

