/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateful;

import com.sap.engine.interfaces.cross.CrossObjectFactory;
import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseIOException;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.session.EJBHomeImpl;
import com.sap.engine.services.ejb.session.EJBLocalHomeImpl;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.session.SessionContainer;
import com.sap.engine.services.ejb.session.stateful.BMStatefulSessionContext;
import com.sap.engine.services.ejb.session.stateful.CMStatefulSessionContext;
import com.sap.engine.services.ejb.session.stateful.StatefulEJBObjectImpl;
import com.sap.engine.services.ejb.session.stateful.StatefulSession;
import com.sap.engine.services.ejb.session.stateful.StatefulSessionContext;
import com.sap.engine.services.ejb.util.LRUHashtable;
import com.sap.engine.services.ejb.util.LRUHashtableItem;
import com.sap.engine.services.ejb.util.MonitoringInfo;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.failover.storage.PersistentStorage;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Stack;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;

public class StatefulContainer
extends SessionContainer
implements CrossObjectFactory {
    private volatile int passiveSessionsCount = 0;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$session$stateful$StatefulContainer == null ? (class$com$sap$engine$services$ejb$session$stateful$StatefulContainer = StatefulContainer.class$("com.sap.engine.services.ejb.session.stateful.StatefulContainer")) : class$com$sap$engine$services$ejb$session$stateful$StatefulContainer));
    protected boolean passivateByFailover = false;
    private PersistentStorage failoverPersistentStorage;
    private int serverId;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$session$stateful$StatefulContainer;
    static /* synthetic */ Class class$javax$ejb$SessionSynchronization;

    public void init(Environment env, String appName, DeploymentDescriptor descr, ClassLoader load_er) throws ContainerInitializationException {
        super.init(env, appName, descr, load_er);
        this.monitoringInfo = new MonitoringInfo(2);
        this.failoverPersistentStorage = env.getFailoverPersistentStorage();
        if (this.failoverPersistentStorage == null) {
            if (this.descriptor.usePassivation()) {
                throw new ContainerInitializationException("ejb_1090", new String[]{this.beanName});
            }
            if (this.descriptor.useStatefulFailover()) {
                throw new ContainerInitializationException("ejb_1089", new String[]{this.beanName});
            }
        }
        if (this.descriptor.useStatefulFailover()) {
            env.getCrossInterface().registerObjectFactory(this.descriptor.getJndiName(), this);
        }
        this.passivateByFailover = this.descriptor.keepsOpenResources();
        this.serverId = env.getServiceContext().getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
    }

    public int getServerId() {
        return this.serverId;
    }

    public void decreasePassivated() {
        --this.passiveSessionsCount;
    }

    protected Session createSession(long sessionKey) throws NoSuchSessionException {
        if (this.descriptor.getTransactionType() == 0) {
            return new BMStatefulSessionContext(this, sessionKey);
        }
        return new CMStatefulSessionContext(this, sessionKey, (class$javax$ejb$SessionSynchronization == null ? (class$javax$ejb$SessionSynchronization = StatefulContainer.class$("javax.ejb.SessionSynchronization")) : class$javax$ejb$SessionSynchronization).isAssignableFrom(this.beanClass));
    }

    protected void accessedSession(StatefulSession session) {
        if (!this.passivateByFailover) {
            HashMapLongObject hashMapLongObject = this.base;
            synchronized (hashMapLongObject) {
                ((LRUHashtable)this.base).access((LRUHashtableItem)session);
            }
        }
    }

    public Session startSession_passivation() throws NoSuchSessionException {
        Session session = null;
        Object popSession = null;
        long sessionKey = this.getNextSessionID();
        session = this.createSession(sessionKey);
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            popSession = this.base.put(sessionKey, session);
        }
        if (popSession != null) {
            ((StatefulSessionContext)popSession).passivate();
            ++this.passiveSessionsCount;
        }
        return session;
    }

    protected void activateSession(StatefulSession session) {
        Object popSession = null;
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            popSession = this.base.put(session.getSessionKey(), session);
        }
        if (popSession != null) {
            ((StatefulSessionContext)popSession).passivate();
        } else {
            --this.passiveSessionsCount;
        }
    }

    public Object restoreSession(String id, Hashtable map, boolean local) throws RemoteException {
        try {
            Session session = null;
            Long neww = (Long)map.get(id);
            if (neww != null) {
                long newKey = neww;
                session = this.findBySessionKey(newKey);
                return session.getObject();
            }
            session = this.descriptor.usePassivation() ? this.startSession_passivation() : this.startSession();
            long newKey = session.getSessionKey();
            map.put(id, new Long(newKey));
            if (local) {
                EJBLocalObject localObject = ((EJBLocalHomeImpl)this.ejbLocalHome).createEJBLocalObject(session);
                session.setLocalObject(localObject);
                return localObject;
            }
            EJBObject remObject = ((EJBHomeImpl)this.ejbHome).createEJBObject(session);
            session.setObject(remObject);
            return remObject;
        }
        catch (NoSuchSessionException nexc) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1034", (Throwable)((Object)nexc));
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        catch (Exception exc) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1035", exc);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    public void writeInstance(String id, long sessionKey, Stack IDs, ObjectOutputStream outStream) throws IOException {
        try {
            StatefulSessionContext session = (StatefulSessionContext)this.findBySessionKey(sessionKey);
            SessionBean instance = session.getInstanceForSerialization();
            outStream.writeObject(id);
            outStream.writeObject(instance);
        }
        catch (NoSuchSessionException ss) {
            BaseIOException toThrow = new BaseIOException("ejb_1037", (Throwable)((Object)ss));
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    public void restoreStatefulInstance(Session session, Object obj) throws RemoteException {
        try {
            SessionBean instance = (SessionBean)obj;
            ((StatefulSessionContext)session).setBean(instance);
            ((StatefulSessionContext)session).passivatedByFailover = true;
        }
        catch (Exception exc) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1038", exc);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    public int getSessionProperty(int property) {
        switch (property) {
            case 1: {
                return this.descriptor.getSessionTimeout();
            }
            case 2: {
                return this.descriptor.getStatefulTimeout();
            }
            case 4: {
                return this.passiveSessionsCount;
            }
            case 3: {
                return this.base.size();
            }
            case 5: {
                return this.completedSessionsCount;
            }
        }
        LOCATION.errorT(EJBResourceAccessor.category, "ejb_1085", new Object[]{new Integer(property)});
        return -1;
    }

    public int getPoolProperty(int property) {
        return -1;
    }

    public int getType() throws RemoteException {
        return 1;
    }

    public void destroy() {
        if (this.descriptor.useStatefulFailover()) {
            this.env.getCrossInterface().unregisterObjectFactory(this.descriptor.getJndiName());
        }
        super.destroy();
    }

    public boolean serializeSession(String key, Object bean) {
        try {
            this.failoverPersistentStorage.serializeSession(this.applicationName, key, bean);
        }
        catch (PersistentStorageException pexc) {
            LOCATION.traceThrowableT(500, "", (Throwable)pexc);
            return false;
        }
        return true;
    }

    public SessionBean readBeanFromPersistentStorage(String key) throws PersistentStorageException {
        return (SessionBean)this.failoverPersistentStorage.readSession(this.applicationName, key, this.getClassLoader());
    }

    public void deleteInstanceFromPersistentStorage(String key) {
        try {
            this.failoverPersistentStorage.deleteSession(this.applicationName, key);
        }
        catch (PersistentStorageException pexc) {
            LOCATION.traceThrowableT(500, "", (Throwable)pexc);
        }
    }

    public Object getObject(String name) {
        try {
            if (name.startsWith(SessionContainer._OBJECT_)) {
                String oldIdentifier = name.substring(SessionContainer._OBJECT_.length());
                SessionBean bean = this.readBeanFromPersistentStorage(oldIdentifier);
                Session session = null;
                session = this.descriptor.usePassivation() ? this.startSession_passivation() : this.startSession();
                StatefulSessionContext statefulSession = (StatefulSessionContext)session;
                statefulSession.setBean(bean);
                EJBObject remObject = ((EJBHomeImpl)this.ejbHome).createEJBObject(session);
                ((StatefulEJBObjectImpl)remObject).setFailoverID(oldIdentifier);
                session.setObject(remObject);
                return remObject;
            }
            if (name.startsWith(SessionContainer._HOME_)) {
                return this.ejbHome;
            }
            return null;
        }
        catch (PersistentStorageException pexc) {
            LOCATION.traceThrowableT(500, "", (Throwable)pexc);
            return null;
        }
        catch (NoSuchSessionException nexc) {
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)nexc));
            return null;
        }
        catch (Exception exc) {
            LOCATION.traceThrowableT(500, "", (Throwable)exc);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

