/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateful;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContextException;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.stateful.BMStatefulSessionContext;
import com.sap.engine.services.ejb.session.stateful.StatefulContainerFP;
import com.sap.engine.services.ejb.session.stateful.StatefulEJBObjectImpl;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class BMStatefulSessionContextFP
extends BMStatefulSessionContext {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$session$stateful$BMStatefulSessionContextFP == null ? (class$com$sap$engine$services$ejb$session$stateful$BMStatefulSessionContextFP = BMStatefulSessionContextFP.class$("com.sap.engine.services.ejb.session.stateful.BMStatefulSessionContextFP")) : class$com$sap$engine$services$ejb$session$stateful$BMStatefulSessionContextFP));
    private ResourceContext resourceContext = null;
    private Transaction transaction = null;
    private Transaction outerRemoveTransaction = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$session$stateful$BMStatefulSessionContextFP;

    public BMStatefulSessionContextFP(StatefulContainerFP container, long addressKey) throws NoSuchSessionException {
        super(container, addressKey);
        String appName = container.getApplicationName();
        String compName = "ejbContexts/" + appName + "/" + container.getDescriptor().getJndiName();
        this.resourceContext = container.getEnvironment().getResourceContextFactory().createContext(appName, compName, false);
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public Transaction beforeInvoke(int method, String methodName) throws RemoteException {
        Transaction t;
        this.method = method;
        this.begin();
        try {
            t = this.container.getTransactionManager().suspend();
            this.container.getTransactionManager().resume(this.transaction);
            this.resourceContext.enterMethod(methodName);
        }
        catch (SystemException e) {
            this.end(true);
            throw new BaseRemoteException("ejb_1010", new Object[]{"beforeInvoke(int, String)"}, e);
        }
        catch (ResourceContextException rexc) {
            this.end(true);
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1087", rexc);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        this.setMethod(3);
        return t;
    }

    public Transaction beforeInvoke_(int method, String methodName) throws RemoteException {
        Transaction t;
        this.method = method;
        this.beginWithNoPassivation();
        try {
            t = this.container.getTransactionManager().suspend();
            this.container.getTransactionManager().resume(this.transaction);
            this.resourceContext.enterMethod(methodName);
        }
        catch (SystemException e) {
            this.end(true);
            throw new BaseRemoteException("ejb_1010", new Object[]{"beforeInvoke_(int, String)"}, e);
        }
        catch (ResourceContextException rexc) {
            this.end(true);
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1087", rexc);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        this.setMethod(3);
        return t;
    }

    public void afterInvoke(Transaction t, boolean fatal, String methodName) throws RemoteException {
        try {
            this.resourceContext.exitMethod(methodName, !fatal);
        }
        catch (ResourceContextException rexc) {
            this.end(true);
            BaseRemoteException toThrow = new BaseRemoteException("ejb_1087", rexc);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        try {
            this.transaction = this.container.getTransactionManager().suspend();
            if (fatal && this.transaction != null) {
                this.transaction.rollback();
            }
            this.container.getTransactionManager().resume(t);
            this.end(fatal);
        }
        catch (SystemException e) {
            this.end(true);
            throw new BaseRemoteException("ejb_1010", new Object[]{"afterInvoke(Transaction, boolean, String)"}, e);
        }
    }

    public void afterInvokeWithFailover(Transaction t, boolean fatal, String methodName) throws RemoteException {
        String key = ((StatefulEJBObjectImpl)this.ejbObject).getFailoverID();
        this.container.serializeSession(key, this.bean);
        this.afterInvoke(t, fatal, methodName);
    }

    public void afterCreate() throws EJBException {
        try {
            this.transaction = this.container.getTransactionManager().suspend();
        }
        catch (SystemException e) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1010", new Object[]{"afterCreate()"}, e);
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)toThrow));
            throw toThrow;
        }
    }

    public void beforeRemove() throws EJBException {
        TransactionManager tm = this.container.getTransactionManager();
        try {
            this.outerRemoveTransaction = tm.suspend();
            tm.resume(this.transaction);
        }
        catch (Exception exc) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1010", new Object[]{"beforeRemove()"}, exc);
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)toThrow));
            throw toThrow;
        }
    }

    public void afterRemove() throws EJBException {
        TransactionManager tm = this.container.getTransactionManager();
        Transaction t = null;
        try {
            t = tm.getTransaction();
        }
        catch (SystemException sysexc) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1010", new Object[]{"afterRemove()"}, sysexc);
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)toThrow));
            throw toThrow;
        }
        if (t != null) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1088");
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)toThrow));
            throw toThrow;
        }
        try {
            tm.resume(this.outerRemoveTransaction);
        }
        catch (Exception exc) {
            BaseEJBException toThrow = new BaseEJBException("ejb_1010", new Object[]{"afterRemove()"}, exc);
            LOCATION.traceThrowableT(500, "", (Throwable)((Object)toThrow));
            throw toThrow;
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1074");
        LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
        throw toThrow;
    }

    public void destroySession() {
        super.destroySession();
        this.resourceContext.destroy();
        this.transaction = null;
    }

    public void destroySessionWithoutRemove() {
        super.destroySessionWithoutRemove();
        this.resourceContext.destroy();
        this.transaction = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

