/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session.stateful;

import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.stateful.StatefulContainer;
import com.sap.engine.services.ejb.session.stateful.StatefulEJBObjectImpl;
import com.sap.engine.services.ejb.session.stateful.StatefulSessionContext;
import java.rmi.RemoteException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class BMStatefulSessionContext
extends StatefulSessionContext {
    public BMStatefulSessionContext(StatefulContainer container, long addressKey) throws NoSuchSessionException {
        super(container, addressKey);
    }

    public Transaction beforeInvoke(int method) throws RemoteException {
        Transaction t;
        this.method = method;
        this.begin();
        try {
            t = this.container.getTransactionManager().suspend();
            this.container.getTransactionManager().resume(this.resource.getTransaction());
        }
        catch (SystemException e) {
            this.end(true);
            throw new BaseRemoteException("ejb_1010", new Object[]{"beforeInvoke(int)"}, e);
        }
        this.setMethod(2);
        return t;
    }

    public Transaction beforeInvoke_(int method) throws RemoteException {
        Transaction t;
        this.method = method;
        this.beginWithNoPassivation();
        try {
            t = this.container.getTransactionManager().suspend();
            this.container.getTransactionManager().resume(this.resource.getTransaction());
        }
        catch (SystemException e) {
            this.end(true);
            throw new BaseRemoteException("ejb_1010", new Object[]{"beforeInvoke_(int)"}, e);
        }
        this.setMethod(2);
        return t;
    }

    public void afterInvoke(Transaction t, boolean fatal) throws RemoteException {
        try {
            Transaction tt = this.container.getTransactionManager().suspend();
            if (fatal && tt != null) {
                tt.rollback();
            }
            this.container.getTransactionManager().resume(t);
            this.end(fatal);
        }
        catch (SystemException e) {
            this.end(true);
            throw new BaseRemoteException("ejb_1010", new Object[]{"afterInvoke(Transaction, boolean)"}, e);
        }
    }

    public void afterInvokeWithFailover(Transaction t, boolean fatal) throws RemoteException {
        String key = ((StatefulEJBObjectImpl)this.ejbObject).getFailoverID();
        this.container.serializeSession(key, this.bean);
        this.afterInvoke(t, fatal);
    }
}

