/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.csiv2.EJBIORGeneratorInterface;
import com.sap.engine.interfaces.csiv2.IORDescriptor;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.ejb.ContainerBoot;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.EJBContainerEventListener;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.RunAsPrivilegedAction;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import com.sap.engine.services.ejb.runtime.ContainerRuntime;
import com.sap.engine.services.ejb.session.EJBLocalHomeImpl;
import com.sap.engine.services.ejb.session.NoSuchSessionException;
import com.sap.engine.services.ejb.session.Session;
import com.sap.engine.services.ejb.util.AdminUtils;
import com.sap.engine.services.ejb.util.LRUHashtable;
import com.sap.engine.services.ejb.util.MonitoringInfo;
import com.sap.engine.services.ejb.util.NoConnectionResourceSetImpl;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.tc.logging.Location;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.SessionBean;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;

public abstract class SessionContainer
extends PortableRemoteObject
implements ContainerBoot,
ContainerRuntime,
EJBContainerEventListener,
TimeoutListener {
    public static final String _OBJECT_ = AdminUtils._reserved[0] + "object" + AdminUtils._reserved[0];
    public static final String _HOME_ = AdminUtils._reserved[0] + "home" + AdminUtils._reserved[0];
    private static final String SYSTEM_METHODS = "System_methods_not_allowed_to_use_resources";
    private static final int DEF_SIZE = 101;
    private static final long DEF_SESSION_TIMEOUT = 36000000L;
    private boolean bean_tx;
    private long counter = Long.MIN_VALUE;
    private Object synch = new Object();
    protected HashMapLongObject base = null;
    protected SessionDescriptor descriptor = null;
    protected String applicationName = null;
    protected String beanName = null;
    protected EJBHome ejbHome = null;
    protected EJBLocalHome ejbLocalHome = null;
    protected Class beanClass = null;
    protected MonitoringInfo monitoringInfo = null;
    protected Environment env = null;
    protected volatile int completedSessionsCount = 0;
    private ClassLoader loader = null;
    private TimeoutManager timeoutService = null;
    private TransactionManager transactionManager = null;
    private Subject runAsSubject = null;
    private SimpleProfileInterface iiopSimpleProfile = null;
    private EJBIORGeneratorInterface iorGenerator = null;
    private SecurityContext myApplicationSecContext = null;
    private ResourceSet noConnectionResourceSet = null;
    protected static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$session$SessionContainer == null ? (class$com$sap$engine$services$ejb$session$SessionContainer = SessionContainer.class$("com.sap.engine.services.ejb.session.SessionContainer")) : class$com$sap$engine$services$ejb$session$SessionContainer));
    static /* synthetic */ Class class$com$sap$engine$services$ejb$session$SessionContainer;

    protected abstract Session createSession(long var1) throws NoSuchSessionException;

    public void init(Environment e, String appName, DeploymentDescriptor descr, ClassLoader _loader) throws ContainerInitializationException {
        ContainerInitializationException toThrow;
        Constructor<?> constr;
        this.env = e;
        this.loader = _loader;
        this.applicationName = appName;
        this.descriptor = (SessionDescriptor)descr;
        this.beanName = this.descriptor.getEjbName();
        String policyConfiguration = appName + "*" + descr.getEJBJarDescriptor().getJarName();
        this.myApplicationSecContext = this.env.getSecurityContext().getPolicyConfigurationContext(policyConfiguration);
        this.bean_tx = this.descriptor.getTransactionType() == 0;
        int size = this.descriptor.getContainerSize();
        if (size == 0) {
            size = 101;
        }
        this.env.registerContainerListener(this, "timeout");
        this.base = this.descriptor.usePassivation() ? new LRUHashtable(size, this.descriptor.getLruLimit()) : new HashMapLongObject(size);
        this.synch = new Object();
        String ejbHomeName = this.descriptor.getEjbHomeImpl();
        String ejbLocalHomeName = this.descriptor.getEjbLocalHomeImpl();
        this.transactionManager = this.env.getTransactionManager();
        if (ejbHomeName == null && ejbLocalHomeName == null) {
            ContainerInitializationException toThrow2 = new ContainerInitializationException("ejb_1054");
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow2);
            throw toThrow2;
        }
        this.initSecurityRunAs(descr);
        this.initIIOPSimpleProfile(descr);
        this.noConnectionResourceSet = new NoConnectionResourceSetImpl(this.applicationName, "ejbContexts/" + this.applicationName + "/" + this.descriptor.getJndiName(), SYSTEM_METHODS);
        if (ejbHomeName != null) {
            try {
                Class<?> ejbHomeClass = this.loader.loadClass(ejbHomeName);
                constr = ejbHomeClass.getConstructor(class$com$sap$engine$services$ejb$session$SessionContainer == null ? (class$com$sap$engine$services$ejb$session$SessionContainer = SessionContainer.class$("com.sap.engine.services.ejb.session.SessionContainer")) : class$com$sap$engine$services$ejb$session$SessionContainer);
                this.ejbHome = (EJBHome)constr.newInstance(this);
            }
            catch (NoClassDefFoundError ncdfe) {
                ContainerInitializationException toThrow3 = new ContainerInitializationException("ejb_1055", new Object[]{ejbHomeName}, ncdfe);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow3);
                throw toThrow3;
            }
            catch (ClassNotFoundException cnfe) {
                ContainerInitializationException toThrow4 = new ContainerInitializationException("ejb_1055", new Object[]{ejbHomeName}, cnfe);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow4);
                throw toThrow4;
            }
            catch (NoSuchMethodException nsme) {
                ContainerInitializationException toThrow5 = new ContainerInitializationException("ejb_1056", nsme);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow5);
                throw toThrow5;
            }
            catch (InstantiationException inste) {
                ContainerInitializationException toThrow6 = new ContainerInitializationException("ejb_1057", inste);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow6);
                throw toThrow6;
            }
            catch (IllegalAccessException illAccEx) {
                ContainerInitializationException toThrow7 = new ContainerInitializationException("ejb_1058", illAccEx);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow7);
                throw toThrow7;
            }
            catch (InvocationTargetException ite) {
                Throwable detail = ite.getTargetException();
                if (detail == null) {
                    detail = ite;
                }
                ContainerInitializationException toThrow8 = new ContainerInitializationException("ejb_1059", detail);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow8);
                throw toThrow8;
            }
        }
        if (ejbLocalHomeName != null) {
            try {
                Class<?> ejbLocalHomeClass = this.loader.loadClass(ejbLocalHomeName);
                constr = ejbLocalHomeClass.getConstructor(class$com$sap$engine$services$ejb$session$SessionContainer == null ? (class$com$sap$engine$services$ejb$session$SessionContainer = SessionContainer.class$("com.sap.engine.services.ejb.session.SessionContainer")) : class$com$sap$engine$services$ejb$session$SessionContainer);
                this.ejbLocalHome = (EJBLocalHome)constr.newInstance(this);
            }
            catch (NoClassDefFoundError ncdfe) {
                toThrow = new ContainerInitializationException("ejb_1055", new Object[]{ejbLocalHomeName}, ncdfe);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
            catch (ClassNotFoundException cnfe) {
                ContainerInitializationException toThrow9 = new ContainerInitializationException("ejb_1055", new Object[]{ejbLocalHomeName}, cnfe);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow9);
                throw toThrow9;
            }
            catch (NoSuchMethodException nsme) {
                ContainerInitializationException toThrow10 = new ContainerInitializationException("ejb_1060", nsme);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow10);
                throw toThrow10;
            }
            catch (InstantiationException inste) {
                ContainerInitializationException toThrow11 = new ContainerInitializationException("ejb_1061", inste);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow11);
                throw toThrow11;
            }
            catch (IllegalAccessException illAccEx) {
                ContainerInitializationException toThrow12 = new ContainerInitializationException("ejb_1062", illAccEx);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow12);
                throw toThrow12;
            }
            catch (InvocationTargetException ite) {
                Throwable detail = ite.getTargetException();
                if (detail == null) {
                    detail = ite;
                }
                ContainerInitializationException toThrow13 = new ContainerInitializationException("ejb_1063", detail);
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow13);
                throw toThrow13;
            }
        }
        try {
            this.beanClass = this.loader.loadClass(this.descriptor.getClassName());
        }
        catch (ClassNotFoundException cnfe) {
            toThrow = new ContainerInitializationException("ejb_1064", new Object[]{this.descriptor.getClassName()}, cnfe);
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    public void startFunctionalityRelatedToService(Object serviceInterface) {
        this.timeoutService = (TimeoutManager)serviceInterface;
        long timeout = 1000 * this.descriptor.getSessionTimeout();
        if (timeout == 0L) {
            timeout = 36000000L;
        }
        this.timeoutService.registerTimeoutListener((TimeoutListener)this, timeout, timeout, false);
    }

    public void stopFunctionalityRelatedToService(String serviceName) {
        this.timeoutService = null;
    }

    public SecurityRoleContext getSecurityRoleContext() {
        return this.myApplicationSecContext.getAuthorizationContext().getSecurityRoleContext();
    }

    public com.sap.engine.lib.security.SecurityContext getSecurityContext() {
        ThreadContext currentThread = this.env.getThreadSystem().getThreadContext();
        int secId = this.env.getSecurityContextObjectId();
        return (com.sap.engine.lib.security.SecurityContext)((Object)currentThread.getContextObject(secId));
    }

    public void initPools() throws ContainerInitializationException {
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void timeout() {
        this.checkSessions();
    }

    public boolean check() {
        return true;
    }

    public ResourceContext getResourceContext() {
        return this.myApplicationSecContext.getAuthorizationContext().getSecurityResourceContext();
    }

    public SessionBean createBean() throws NoSuchSessionException {
        try {
            return (SessionBean)this.beanClass.newInstance();
        }
        catch (IllegalAccessException iaex) {
            throw new NoSuchSessionException("ejb_1065", new String[]{this.beanClass.getName()}, iaex);
        }
        catch (InstantiationException iex) {
            throw new NoSuchSessionException("ejb_1065", new String[]{this.beanClass.getName()}, iex);
        }
    }

    public EJBHome getEJBHome() {
        return this.ejbHome;
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.ejbLocalHome;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public SessionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Session findBySessionKey(long sessionKey) throws NoSuchSessionException {
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            Session session = (Session)this.base.get(sessionKey);
            return session;
        }
    }

    public Session startSession() throws NoSuchSessionException {
        Session session = null;
        long sessionKey = this.getNextSessionID();
        session = this.createSession(sessionKey);
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            this.base.put(sessionKey, session);
        }
        return session;
    }

    public void stopSession(Session session) {
        if (session == null) {
            return;
        }
        long sessionKey = session.getSessionKey();
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            this.base.remove(sessionKey);
        }
        ++this.completedSessionsCount;
        session.destroySession();
    }

    public void destroy() {
        this.env.unregisterContainerListener(this, "timeout");
        if (this.timeoutService != null) {
            this.timeoutService.unregisterTimeoutListener(this);
        }
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            Enumeration enumeration = this.base.elements();
            while (enumeration.hasMoreElements()) {
                ((Session)enumeration.nextElement()).destroySessionWithoutRemove();
            }
        }
        this.base = null;
        if (this.ejbHome != null) {
            try {
                PortableRemoteObject.unexportObject((Remote)this.ejbHome);
            }
            catch (NoSuchObjectException nsoe) {
                LOCATION.traceThrowableT(300, "", (Throwable)nsoe);
            }
        }
        this.ejbHome = null;
        if (this.ejbLocalHome != null) {
            ((EJBLocalHomeImpl)this.ejbLocalHome).unexportSession();
        }
        this.ejbLocalHome = null;
        this.beanClass = null;
        this.loader = null;
        this.descriptor = null;
    }

    private void initIIOPSimpleProfile(DeploymentDescriptor descriptor) throws ContainerInitializationException {
        IORDescriptor[] iorDescriptors = descriptor.getIORDescriptors();
        if (iorDescriptors == null) {
            return;
        }
        this.iorGenerator = this.env.getIORGenerator();
        this.iiopSimpleProfile = this.iorGenerator.generateSecurityTaggedComponent(iorDescriptors);
    }

    public void addIIOPSimpleProfile(PortableRemoteObject pro) throws ContainerInitializationException {
        this.iorGenerator.addTaggedComponent(pro, this.iiopSimpleProfile);
    }

    private void initSecurityRunAs(DeploymentDescriptor descriptor) throws ContainerInitializationException {
        SecurityIdentity secIdentity = descriptor.getSecurityIdentity();
        if (secIdentity == null || secIdentity.isCallerIdentity()) {
            return;
        }
        RunAsIdentity runAsIdentity = secIdentity.getRunAsIdentity();
        UserStoreFactory userStoreFactory = this.myApplicationSecContext.getUserStoreContext();
        UserStore userStore = userStoreFactory.getActiveUserStore();
        UserContext userCtx = userStore.getUserContext();
        String userName = runAsIdentity.getUserName();
        if (userName == null) {
            String runAsRoleName = runAsIdentity.getSecurityRoleName();
            SecurityRole runAsRole = this.getSecurityRoleContext().getSecurityRole(runAsRoleName);
            String[] userNames = runAsRole.getUsers();
            if (userNames != null && userNames.length != 0) {
                userName = userNames[0];
            } else {
                String[] groupNames = runAsRole.getGroups();
                if (groupNames != null) {
                    GroupContext groupCtx = userStore.getGroupContext();
                    int i = 0;
                    while (i < groupNames.length) {
                        Iterator groupUsers = groupCtx.getGroupInfo(groupNames[i]).getUsersInGroup();
                        if (groupUsers != null && groupUsers.hasNext()) {
                            userName = (String)groupUsers.next();
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (userName == null) {
                ContainerInitializationException toThrow = new ContainerInitializationException("ejb_1066", new Object[]{runAsRoleName});
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
        }
        UserInfo user = userCtx.getUserInfo(userName);
        this.runAsSubject = new Subject();
        RunAsPrivilegedAction runAsAction = new RunAsPrivilegedAction(userCtx, user, this.runAsSubject);
        AccessController.doPrivileged(runAsAction);
    }

    public Subject getRunAsSubject() {
        return this.runAsSubject;
    }

    public void checkSessions() {
        Object[] sessions;
        HashMapLongObject hashMapLongObject = this.base;
        synchronized (hashMapLongObject) {
            sessions = this.base.getAllValues();
        }
        int i = 0;
        while (i < sessions.length) {
            ((Session)sessions[i]).checkState();
            ++i;
        }
    }

    protected long getNextSessionID() {
        Object object = this.synch;
        synchronized (object) {
            long l = this.counter++;
            return l;
        }
    }

    public ResourceSet getNoConnectionResourceSet() {
        return this.noConnectionResourceSet;
    }

    public static void traceError(String message, Throwable t) {
        LOCATION.traceThrowableT(500, message, t);
    }

    public void logError(String message, Throwable t) {
        new ExceptionWrapperException(500, t, message).log();
    }

    public void logError(Throwable t) {
        LOCATION.traceThrowableT(500, "", t);
    }

    public void logInfo(Throwable t) {
        LOCATION.traceThrowableT(300, "", t);
    }

    public String getCurrentUser() {
        Principal p = this.getSecurityContext().getPrincipal();
        if (p == null) {
            return "UNKNOWN";
        }
        return p.getName();
    }

    public MonitoringInfo getMonitoringInfo() {
        return this.monitoringInfo;
    }

    public int getCreationsNumber() {
        return this.monitoringInfo.getCreations();
    }

    public int getRemovalsNumber() {
        return this.monitoringInfo.getRemovals();
    }

    public int getPassivationsNumber() {
        return this.monitoringInfo.getPassivations();
    }

    public int getActivationsNumber() {
        return this.monitoringInfo.getActivations();
    }

    public int getLoadsNumber() {
        return this.monitoringInfo.getLoads();
    }

    public int getStoresNumber() {
        return this.monitoringInfo.getStores();
    }

    public abstract int getType() throws RemoteException;

    public abstract int getPoolProperty(int var1) throws RemoteException;

    public abstract int getSessionProperty(int var1) throws RemoteException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

