/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.session;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.lib.security.SecurityContext;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.session.SessionContainer;
import com.sap.tc.logging.Location;
import java.security.Identity;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public abstract class BasicSessionContext
implements SessionContext {
    public static final int SET_CONTEXT = 1;
    public static final int EJB = 2;
    public static final int BUSINESS = 3;
    protected int method = 1;
    protected SessionBean bean = null;
    protected Transaction t0 = null;
    public ResourceSet resource = null;
    private Principal runAsPrincipal = null;
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$session$BasicSessionContext == null ? (class$com$sap$engine$services$ejb$session$BasicSessionContext = BasicSessionContext.class$("com.sap.engine.services.ejb.session.BasicSessionContext")) : class$com$sap$engine$services$ejb$session$BasicSessionContext));
    static /* synthetic */ Class class$com$sap$engine$services$ejb$session$BasicSessionContext;

    public void setMethod(int method) {
        this.method = method;
    }

    public SessionBean getInstance() {
        return this.bean;
    }

    protected abstract SessionContainer getContainer();

    public void setRunAsPrincipal(Principal p) {
        this.runAsPrincipal = p;
    }

    public abstract EJBObject getEJBObject();

    public abstract EJBLocalObject getEJBLocalObject();

    public EJBHome getEJBHome() {
        if (this.method < 1) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1067", new Object[]{"getEJBHome()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        return this.getContainer().getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.method < 1) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1068", new Object[]{"getEJBLocalHome()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        return this.getContainer().getEJBLocalHome();
    }

    public Properties getEnvironment() {
        BaseRuntimeException toThrow = new BaseRuntimeException("ejb_1069");
        LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
        throw toThrow;
    }

    public Identity getCallerIdentity() {
        BaseRuntimeException toThrow = new BaseRuntimeException("ejb_1070");
        LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
        throw toThrow;
    }

    public Principal getCallerPrincipal() {
        if (this.method < 2) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1026", new Object[]{"getCallerPrincipal()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (this.runAsPrincipal != null) {
            return this.runAsPrincipal;
        }
        SecurityContext secCtx = this.getContainer().getSecurityContext();
        return secCtx.getPrincipal();
    }

    public boolean isCallerInRole(Identity identity) {
        BaseRuntimeException toThrow = new BaseRuntimeException("ejb_1071");
        LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
        throw toThrow;
    }

    public boolean isCallerInRole(String roleReferenceName) {
        if (this.method < 2) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1027", new Object[]{"isCallerInRole(String)"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        Hashtable secRoleReferences = this.getContainer().getDescriptor().getRoleReferences();
        SecurityRoleReference secRoleRef = (SecurityRoleReference)secRoleReferences.get(roleReferenceName);
        if (secRoleRef == null) {
            return false;
        }
        String roleName = secRoleRef.getSecurityRoleName();
        SecurityRole securityRole = this.getContainer().getSecurityRoleContext().getSecurityRole(roleName);
        if (securityRole == null) {
            return false;
        }
        return securityRole.isCallerInRole();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.method < 2 || this.getContainer().descriptor.getTransactionType() == 1) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1072", new Object[]{"getUserTransaction()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        return this.innerGetUserTransaction();
    }

    public UserTransaction innerGetUserTransaction() {
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)p).put("domain", "true");
        try {
            return (UserTransaction)new InitialContext(p).lookup("UserTransaction");
        }
        catch (NamingException ne) {
            this.getContainer();
            SessionContainer.traceError("getUserTransaction returns null, because it cannot lookup UserTransaction.", ne);
            return null;
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.method < 3) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1073", new Object[]{"setRollbackOnly()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (this.getContainer().descriptor.getTransactionType() == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1074");
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (this.resource.getTransaction() == null) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1075");
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        try {
            this.resource.getTransaction().setRollbackOnly();
        }
        catch (SystemException se) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1076", new Object[]{"setRollbackOnly()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.method < 3) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1077", new Object[]{"getRollbackOnly()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        if (this.getContainer().descriptor.getTransactionType() == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1078");
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
        try {
            int status = this.getContainer().getTransactionManager().getStatus();
            if (status == 6) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1079");
                LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
                throw toThrow;
            }
            return status == 1;
        }
        catch (SystemException se) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_1080", new Object[]{"getRollbackOnly()"});
            LOCATION.traceThrowableT(500, "", (Throwable)toThrow);
            throw toThrow;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

