/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.runtime;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.ejb.monitor.EJBRuntimeChanges;
import com.sap.engine.lib.jar.JarHandler;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.EJBAdmin;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.admintool.InqmyEjbGenerator;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.xml.EJBJarGenerator;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBWarningException;
import com.sap.engine.services.ejb.runtime.ContainerRuntime;
import com.sap.engine.services.ejb.runtime.EJBAdminCallback;
import com.sap.engine.services.ejb.runtime.PersistentRuntime;
import com.sap.engine.services.ejb.runtime.PersistentRuntimeImpl;
import com.sap.engine.services.ejb.runtime.RuntimeControls;
import com.sap.engine.services.ejb.util.AdminUtils;
import com.sap.tc.logging.Location;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import org.w3c.dom.Document;

public class RuntimeControlsImpl
implements RuntimeControls {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$runtime$RuntimeControlsImpl == null ? (class$com$sap$engine$services$ejb$runtime$RuntimeControlsImpl = RuntimeControlsImpl.class$("com.sap.engine.services.ejb.runtime.RuntimeControlsImpl")) : class$com$sap$engine$services$ejb$runtime$RuntimeControlsImpl));
    private static final String CANNOT_FIND_INFO = "Cannot find container for bean {0} in jar {1} from application {2}";
    public static final String UTF8 = "UTF-8";
    private EJBAdmin admin = null;
    private Environment env = null;
    private EJBJarGenerator ejbJarGenerator = null;
    private InqmyEjbGenerator inqmyGenerator = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$runtime$RuntimeControlsImpl;

    public RuntimeControlsImpl(EJBAdmin admin, Environment env) throws RemoteException {
        this.admin = admin;
        this.env = env;
        try {
            this.ejbJarGenerator = new EJBJarGenerator();
            this.inqmyGenerator = new InqmyEjbGenerator(env);
        }
        catch (DeploymentException de) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_9004", (Throwable)((Object)de));
            throw toThrow;
        }
        env.setManagementInterface(this);
    }

    public String[][] getSessionStatefulBeans() throws RemoteException {
        Vector<String[]> filtered = new Vector<String[]>();
        ApplicationDescriptor[] applications = this.admin.getAllApplications();
        ApplicationDescriptor singleApp = null;
        EJBJarDescriptor[] jars = null;
        EJBJarDescriptor singleJar = null;
        DeploymentDescriptor[] beans = null;
        DeploymentDescriptor singleBean = null;
        String[] configuration = null;
        int i = 0;
        while (i < applications.length) {
            configuration = new String[3];
            singleApp = applications[i];
            jars = singleApp.getEJBJarDescriptors();
            int j = 0;
            while (j < jars.length) {
                singleJar = jars[j];
                beans = singleJar.getDDescriptors();
                int k = 0;
                while (k < beans.length) {
                    singleBean = beans[k];
                    if (singleBean instanceof SessionDescriptor && ((SessionDescriptor)singleBean).getSessionType() == 1) {
                        configuration = new String[]{singleApp.getName(), singleJar.getJarName(), singleBean.getName()};
                        filtered.add(configuration);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        String[][] result = new String[filtered.size()][];
        filtered.toArray((T[])result);
        return result;
    }

    public String[][] getSessionStatelessBeans() throws RemoteException {
        Vector<String[]> filtered = new Vector<String[]>();
        ApplicationDescriptor[] applications = this.admin.getAllApplications();
        ApplicationDescriptor singleApp = null;
        EJBJarDescriptor[] jars = null;
        EJBJarDescriptor singleJar = null;
        DeploymentDescriptor[] beans = null;
        DeploymentDescriptor singleBean = null;
        String[] configuration = null;
        int i = 0;
        while (i < applications.length) {
            configuration = new String[3];
            singleApp = applications[i];
            jars = singleApp.getEJBJarDescriptors();
            int j = 0;
            while (j < jars.length) {
                singleJar = jars[j];
                beans = singleJar.getDDescriptors();
                int k = 0;
                while (k < beans.length) {
                    singleBean = beans[k];
                    if (singleBean instanceof SessionDescriptor && ((SessionDescriptor)singleBean).getSessionType() == 0) {
                        configuration = new String[]{singleApp.getName(), singleJar.getJarName(), singleBean.getName()};
                        filtered.add(configuration);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        String[][] result = new String[filtered.size()][];
        filtered.toArray((T[])result);
        return result;
    }

    public String[][] getMessageDrivenBeans() throws RemoteException {
        Vector<String[]> filtered = new Vector<String[]>();
        ApplicationDescriptor[] applications = this.admin.getAllApplications();
        ApplicationDescriptor singleApp = null;
        EJBJarDescriptor[] jars = null;
        EJBJarDescriptor singleJar = null;
        DeploymentDescriptor[] beans = null;
        DeploymentDescriptor singleBean = null;
        String[] configuration = null;
        int i = 0;
        while (i < applications.length) {
            configuration = new String[3];
            singleApp = applications[i];
            jars = singleApp.getEJBJarDescriptors();
            int j = 0;
            while (j < jars.length) {
                singleJar = jars[j];
                beans = singleJar.getDDescriptors();
                int k = 0;
                while (k < beans.length) {
                    singleBean = beans[k];
                    if (singleBean instanceof MessageDrivenDescriptor) {
                        configuration = new String[]{singleApp.getName(), singleJar.getJarName(), singleBean.getName()};
                        filtered.add(configuration);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        String[][] result = new String[filtered.size()][];
        filtered.toArray((T[])result);
        return result;
    }

    public String[][] getEntityBeans() throws RemoteException {
        Vector<String[]> filtered = new Vector<String[]>();
        ApplicationDescriptor[] applications = this.admin.getAllApplications();
        ApplicationDescriptor singleApp = null;
        EJBJarDescriptor[] jars = null;
        EJBJarDescriptor singleJar = null;
        DeploymentDescriptor[] beans = null;
        DeploymentDescriptor singleBean = null;
        String[] configuration = null;
        int i = 0;
        while (i < applications.length) {
            singleApp = applications[i];
            jars = singleApp.getEJBJarDescriptors();
            int j = 0;
            while (j < jars.length) {
                singleJar = jars[j];
                beans = singleJar.getDDescriptors();
                int k = 0;
                while (k < beans.length) {
                    singleBean = beans[k];
                    if (singleBean instanceof EntityDescriptor) {
                        configuration = new String[]{singleApp.getName(), singleJar.getJarName(), singleBean.getName()};
                        filtered.add(configuration);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        String[][] result = new String[filtered.size()][];
        filtered.toArray((T[])result);
        return result;
    }

    public int getCurrentPoolSize(String appName, String jarName, String beanName) throws RemoteException {
        return this.getPoolProperty(appName, jarName, beanName, 1);
    }

    public int getMaxPoolSize(String appName, String jarName, String beanName) throws RemoteException {
        return this.getPoolProperty(appName, jarName, beanName, 2);
    }

    public int getInitialPoolSize(String appName, String jarName, String beanName) throws RemoteException {
        return this.getPoolProperty(appName, jarName, beanName, 3);
    }

    public int getPoolIncrementSize(String appName, String jarName, String beanName) throws RemoteException {
        return this.getPoolProperty(appName, jarName, beanName, 4);
    }

    public int getPoolCurrentlyUsedObject(String appName, String jarName, String beanName) throws RemoteException {
        return this.getPoolProperty(appName, jarName, beanName, 5);
    }

    public int getSessionActiveTimeout(String appName, String jarName, String beanName) throws RemoteException {
        return this.getPoolProperty(appName, jarName, beanName, 1);
    }

    public int getSessionPassiveTimeout(String appName, String jarName, String beanName) throws RemoteException {
        return this.getSessionProperty(appName, jarName, beanName, 2);
    }

    public int getActiveSessionsCount(String appName, String jarName, String beanName) throws RemoteException {
        return this.getSessionProperty(appName, jarName, beanName, 3);
    }

    public int getPassiveSessionsCount(String appName, String jarName, String beanName) throws RemoteException {
        return this.getSessionProperty(appName, jarName, beanName, 4);
    }

    public int getCompletedSessions(String appName, String jarName, String beanName) throws RemoteException {
        return this.getSessionProperty(appName, jarName, beanName, 5);
    }

    public String[] getAllAppNames() throws RemoteException {
        return this.admin.listApplications();
    }

    public ApplicationDescriptor[] getAllApplications() throws RemoteException {
        return this.admin.getAllApplications();
    }

    public ApplicationDescriptor getApplication(String appName) throws RemoteException {
        return this.admin.getApplicationDescriptor(appName);
    }

    public ContainerRuntime getContainerRuntime(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getContainerRuntime(String appName, String jarName, String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getContainerRuntime(String appName, String jarName, String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
        }
        return runtime;
    }

    public PersistentRuntime getPersistentRuntime(String appName, String jarName, String beanName) throws RemoteException {
        return new PersistentRuntimeImpl(this.admin.getPersistentCache(appName, jarName, beanName));
    }

    public void registerEJBAdminCallback(EJBAdminCallback ejbCallback) throws RemoteException {
        this.admin.addEJBAdminCallback(ejbCallback);
    }

    public void unregisterEJBAdminCallback(EJBAdminCallback ejbCallback) throws RemoteException {
        this.admin.removeEJBAdminCallback(ejbCallback);
    }

    public void registerManagementListener(ManagementListener managementListener) {
        this.admin.setManagementListener(managementListener);
    }

    public void runtimeUpdate(String appName, EJBRuntimeChanges[] changes) throws RemoteException {
        String method = "runtimeUpdate(String appName, EJBRuntimeChanges[] changes)";
        boolean needRestartApplication = false;
        Vector<String> jarNames = new Vector<String>();
        Configuration appConfig = null;
        DeployCommunicator deployCommunicator = this.env.getDeployCommunicator();
        try {
            int i = 0;
            while (i < changes.length) {
                DeploymentDescriptor dd;
                String jarName = changes[i].getJarName();
                if (!jarNames.contains(jarName)) {
                    jarNames.add(jarName);
                }
                if ((dd = this.admin.getDeploymentDescriptor(appName, jarName, changes[i].getBeanName())) == null) {
                    BaseRemoteException toThrow = new BaseRemoteException("ejb_9005", new Object[]{changes[i].getBeanName(), jarName, appName});
                    throw toThrow;
                }
                String description = changes[i].getDescription();
                String displayName = changes[i].getDisplayName();
                String jndiName = changes[i].getJndiName();
                int containerSize = changes[i].getContainerSize();
                int lruLimit = changes[i].getLruLimit();
                byte reentrance = changes[i].getReentrance();
                int sessionTimeout = changes[i].getSessionTimeout();
                int statefulTimeout = changes[i].getStatefulTimeout();
                String connectionFactoryName = changes[i].getConnectionFactoryName();
                String messageSelector = changes[i].getMessageSelector();
                String acknowledgeMode = changes[i].getAcknowledgeMode();
                String subscriptionDurability = changes[i].getSubscriptionDurability();
                String destinationType = changes[i].getDestinationType();
                String destinationName = changes[i].getDestinationName();
                if (description != null) {
                    dd.setDescription(description);
                }
                if (displayName != null) {
                    dd.setDisplayName(displayName);
                }
                if (jndiName != null) {
                    dd.setJndiNameUpdated(jndiName);
                    needRestartApplication = true;
                }
                if (containerSize != -1) {
                    dd.setContainerSize(containerSize);
                    needRestartApplication = true;
                }
                if (reentrance != 0) {
                    EntityDescriptor ed = (EntityDescriptor)dd;
                    if (reentrance == 1) {
                        ed.setReentrant(true);
                    } else {
                        ed.setReentrant(false);
                    }
                    needRestartApplication = true;
                }
                if (sessionTimeout != -1) {
                    ((SessionDescriptor)dd).setSessionTimeout(sessionTimeout);
                    needRestartApplication = true;
                }
                if (statefulTimeout != -1) {
                    ((SessionDescriptor)dd).setStatefulTimeout(statefulTimeout);
                    needRestartApplication = true;
                }
                if (dd instanceof SessionDescriptor && lruLimit >= 0) {
                    ((SessionDescriptor)dd).setLruLimit(lruLimit);
                    needRestartApplication = true;
                }
                if (dd instanceof MessageDrivenDescriptor) {
                    if (connectionFactoryName != null) {
                        dd.getBeanProperties().setProperty("ConnectionFactoryName", connectionFactoryName);
                        needRestartApplication = true;
                    }
                    if (messageSelector != null) {
                        ((MessageDrivenDescriptor)dd).setMessageSelector(messageSelector);
                        needRestartApplication = true;
                    }
                    if (acknowledgeMode != null) {
                        ((MessageDrivenDescriptor)dd).setAcknowledgeMode(acknowledgeMode);
                        needRestartApplication = true;
                    }
                    if (subscriptionDurability != null) {
                        ((MessageDrivenDescriptor)dd).setSubscriptionDurability(subscriptionDurability);
                        needRestartApplication = true;
                    }
                    if (destinationType != null) {
                        ((MessageDrivenDescriptor)dd).setDestinationType(destinationType);
                        needRestartApplication = true;
                    }
                    if (destinationName != null) {
                        dd.getBeanProperties().setProperty("DestinationName", destinationName);
                        needRestartApplication = true;
                    }
                }
                ++i;
            }
            appConfig = deployCommunicator.startRuntimeChanges(appName);
        }
        catch (Exception ex) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_9006", new Object[]{appName}, ex);
            throw toThrow;
        }
        File backupDir = null;
        Configuration ejbConfig = null;
        Configuration backupConfig = null;
        Vector warnings = new Vector();
        try {
            String appRootDir = deployCommunicator.getMyWorkDirectory(appName);
            File appDir = new File(appRootDir);
            backupDir = new File(appDir, "backup");
            String[] jars = jarNames.toArray(new String[jarNames.size()]);
            ApplicationDescriptor applicationDescriptor = this.admin.getApplicationDescriptor(appName);
            EJBJarDescriptor[] jarDescriptors = applicationDescriptor.getEJBJarDescriptors();
            ejbConfig = appConfig.getSubConfiguration("ejb");
            backupConfig = ejbConfig.getSubConfiguration("backup");
            JarHandler jarHandler = new JarHandler();
            Vector<String> filters = new Vector<String>();
            filters.add(".xml");
            int i = 0;
            while (i < jars.length) {
                boolean found = false;
                int j = 0;
                while (j < jarDescriptors.length) {
                    if (jars[i].equals(jarDescriptors[j].getJarName())) {
                        found = true;
                        File metaInfDir = new File(backupDir, "META-INF");
                        metaInfDir.mkdir();
                        Document document = this.ejbJarGenerator.loadEJBJarDescriptor(jarDescriptors[j], warnings);
                        String ejbJarFile = metaInfDir.getPath() + File.separator + "ejb-jar.xml";
                        new StandardDOMWriter().write(document, ejbJarFile, "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>", UTF8);
                        String ejbJ2eeEngineFile = metaInfDir.getPath() + File.separator + "ejb-j2ee-engine.xml";
                        this.inqmyGenerator.generateXML(appName, jarDescriptors[j], ejbJ2eeEngineFile);
                        String jarName = appRootDir + File.separatorChar + "backup" + File.separatorChar + jars[i];
                        jarHandler.updateJarFile(jarName, backupDir, filters);
                        backupConfig.updateFile(new File(jarName));
                        AdminUtils.delFolder((File)metaInfDir);
                        AdminUtils.updateCRCIndexForFolder((File)backupDir, (String)"backup.crc", (String)"backup.idx", (File)appDir, (Configuration)ejbConfig);
                    }
                    if (found) break;
                    ++j;
                }
                ++i;
            }
            deployCommunicator.makeRuntimeChanges(appName, needRestartApplication);
        }
        catch (Exception exc) {
            if (backupDir != null && backupConfig != null) {
                try {
                    AdminUtils.makeConsistent(backupDir, backupConfig, ejbConfig, (String)"backup.crc", (String)"backup.idx", warnings);
                }
                catch (DeploymentException dex) {
                    BaseRemoteException toThrow = new BaseRemoteException("ejb_9008", new Object[]{backupConfig.getPath(), ejbConfig.getPath()}, (Throwable)((Object)dex));
                    throw toThrow;
                }
            }
            try {
                deployCommunicator.rollbackRuntimeChanges(appName);
            }
            catch (RuntimeException e) {
                LOCATION.traceThrowableT(500, "runtimeUpdate(String appName, EJBRuntimeChanges[] changes)", (String)null, (Throwable)e);
            }
            BaseRemoteException toThrow = new BaseRemoteException("ejb_9007", exc);
            throw toThrow;
        }
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_9058", new Object[]{appName});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
    }

    public boolean deployIiopSupport(String appName) throws RemoteException {
        return this.admin.deployIiopSupport(appName);
    }

    public String[] getModuleNamesPerApplication(String appName) throws RemoteException {
        ApplicationDescriptor ad = this.admin.getApplicationDescriptor(appName);
        if (ad == null) {
            return null;
        }
        EJBJarDescriptor[] descriptors = ad.getEJBJarDescriptors();
        if (descriptors == null) {
            return null;
        }
        String[] result = new String[descriptors.length];
        int i = 0;
        while (i < result.length) {
            result[i] = descriptors[i].getJarName();
            ++i;
        }
        return result;
    }

    public String[] getBeanNamesPerModule(String appName, String jarName) throws RemoteException {
        ApplicationDescriptor ad = this.admin.getApplicationDescriptor(appName);
        if (ad == null) {
            return null;
        }
        EJBJarDescriptor[] descriptors = ad.getEJBJarDescriptors();
        if (descriptors == null) {
            return null;
        }
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getJarName().equals(jarName)) {
                DeploymentDescriptor[] beans = descriptors[i].getDDescriptors();
                if (beans == null) {
                    return null;
                }
                String[] result = new String[beans.length];
                int k = 0;
                while (k < beans.length) {
                    result[k] = beans[k].getEjbName();
                    ++k;
                }
                return result;
            }
            ++i;
        }
        return null;
    }

    public int getSessionProperty(String appName, String jarName, String beanName, int property) throws RemoteException {
        String method = "getSessionProperty(String appName,String jarName,String beanName,int property)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getSessionProperty(String appName,String jarName,String beanName,int property)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getSessionProperty(property);
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getSessionProperty(String appName,String jarName,String beanName,int property)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getPoolProperty(String appName, String jarName, String beanName, int property) throws RemoteException {
        String method = "getPoolProperty(String appName,String jarName,String beanName,int property)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getPoolProperty(String appName,String jarName,String beanName,int property)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getPoolProperty(property);
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getPoolProperty(String appName,String jarName,String beanName,int property)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getCreationsNumber(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getCreationsNumber(String appName,String jarName,String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getCreationsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getCreationsNumber();
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getCreationsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getRemovalsNumber(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getRemovalsNumber(String appName,String jarName,String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getRemovalsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getRemovalsNumber();
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getRemovalsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getPassivationsNumber(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getPassivationsNumber(String appName,String jarName,String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getPassivationsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getPassivationsNumber();
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getPassivationsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getActivationsNumber(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getActivationsNumber(String appName,String jarName,String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getActivationsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getActivationsNumber();
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getActivationsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getLoadsNumber(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getLoadsNumber(String appName,String jarName,String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getLoadsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getLoadsNumber();
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getLoadsNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    public int getStoresNumber(String appName, String jarName, String beanName) throws RemoteException {
        String method = "getStoresNumber(String appName,String jarName,String beanName)";
        ContainerRuntime runtime = this.admin.getBeanContainer(appName, jarName, beanName);
        if (runtime == null) {
            LOCATION.infoT("getStoresNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName});
            return -1;
        }
        try {
            return runtime.getStoresNumber();
        }
        catch (NullPointerException npex) {
            LOCATION.traceThrowableT(300, "getStoresNumber(String appName,String jarName,String beanName)", CANNOT_FIND_INFO, new Object[]{beanName, jarName, appName}, (Throwable)npex);
            return -1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

