/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.runtime;

import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.interfaces.ejb.monitor.EJBManagerException;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.EJBAdmin;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseEJBManagerException;
import com.sap.engine.services.ejb.exceptions.ExceptionConstants;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.naming.NamingException;

public class EJBManagerImpl
implements EJBManager,
ExceptionConstants {
    private EJBAdmin admin = null;

    public EJBManagerImpl(EJBAdmin admin) {
        this.admin = admin;
    }

    public String resolveEjbRef(String appName, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbHome, String refEjbObject, String refName) throws EJBException {
        ApplicationDescriptor ad = this.admin.getApplicationDescriptor(appName);
        if (ad == null && (ad = this.admin.getRandomApplicationDescriptor()) == null) {
            throw new BaseEJBManagerException("ejb_9009");
        }
        try {
            return this.admin.findEjbRefLink(ad, warnings, jndiLinkName, ejbLinkName, refEjbHome, refEjbObject, refName, null, null);
        }
        catch (DeploymentException de) {
            throw new BaseEJBManagerException("ejb_9999", new Object[]{refName}, (Throwable)((Object)de));
        }
    }

    public String resolveEjbLocalRef(String appName, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbLocalHome, String refEjbLocalObject, String refName) throws EJBManagerException {
        ApplicationDescriptor ad = this.admin.getApplicationDescriptor(appName);
        if (ad == null && (ad = this.admin.getRandomApplicationDescriptor()) == null) {
            throw new BaseEJBManagerException("ejb_9009");
        }
        try {
            return this.admin.findEjbLocalRefLink(ad, warnings, jndiLinkName, ejbLinkName, refEjbLocalHome, refEjbLocalObject, refName, null, null);
        }
        catch (DeploymentException de) {
            throw new BaseEJBManagerException("ejb_9010", new Object[]{refName}, (Throwable)((Object)de));
        }
    }

    public String[] getApplicationJars(String appName, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbHome, String refEjbObject, String refName) throws EJBManagerException {
        ApplicationDescriptor ad = this.admin.getApplicationDescriptor(appName);
        if (ad == null && (ad = this.admin.getRandomApplicationDescriptor()) == null) {
            return null;
        }
        try {
            return this.admin.getApplicationJars(ad, warnings, jndiLinkName, ejbLinkName, refEjbHome, refEjbObject, refName, null);
        }
        catch (DeploymentException de) {
            throw new BaseEJBManagerException("ejb_9011", new Object[]{refName}, (Throwable)((Object)de));
        }
    }

    public String[] getApplicationJarsLocal(String appName, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbLocalHome, String refEjbLocalObject, String refName) throws EJBManagerException {
        ApplicationDescriptor ad = this.admin.getApplicationDescriptor(appName);
        if (ad == null && (ad = this.admin.getRandomApplicationDescriptor()) == null) {
            return null;
        }
        try {
            return this.admin.getApplicationJarsLocal(ad, warnings, jndiLinkName, ejbLinkName, refEjbLocalHome, refEjbLocalObject, refName, null);
        }
        catch (DeploymentException de) {
            throw new BaseEJBManagerException("ejb_9012", (Throwable)((Object)de));
        }
    }

    public String getJNDIName(String appName, String jarName, String beanName) {
        DeploymentDescriptor dd = this.admin.getDeploymentDescriptor(appName, jarName, beanName);
        if (dd != null && dd.hasRemoteInterfaces()) {
            return dd.getJndiName();
        }
        return null;
    }

    public String[] getJNDINames(String appName, String jarName) {
        return this.admin.getJNDINames(appName, jarName);
    }

    public boolean isStatefulSession(String jndiName) throws EJBManagerException {
        SessionDescriptor descr = (SessionDescriptor)this.admin.getDeploymentDescriptor(jndiName);
        if (descr == null) {
            throw new BaseEJBManagerException("ejb_9013", new Object[]{jndiName});
        }
        return descr.getSessionType() == 1;
    }

    public String getJNDINameLocal(String appName, String jarName, String beanName) {
        DeploymentDescriptor dd = this.admin.getDeploymentDescriptor(appName, jarName, beanName);
        if (dd != null && dd.hasLocalInterfaces()) {
            return "localejbs/" + dd.getJndiName();
        }
        return null;
    }

    public boolean isStatefulSessionLocal(String jndiName) throws EJBManagerException {
        SessionDescriptor descr;
        String realJndiName = jndiName;
        int prefixLength = "localejbs/".length();
        if (jndiName.length() > prefixLength) {
            realJndiName = jndiName.substring(prefixLength);
        }
        if ((descr = (SessionDescriptor)this.admin.getDeploymentDescriptor(realJndiName)) == null) {
            throw new BaseEJBManagerException("ejb_9013", new Object[]{realJndiName});
        }
        return descr.getSessionType() == 1;
    }

    public String getRemoteInterfaceName(String appName, String jarName, String beanName) {
        DeploymentDescriptor dd = this.admin.getDeploymentDescriptor(appName, jarName, beanName);
        if (dd != null) {
            return dd.getRemoteInterface();
        }
        return null;
    }

    public String getLocalInterfaceName(String appName, String jarName, String beanName) {
        DeploymentDescriptor dd = this.admin.getDeploymentDescriptor(appName, jarName, beanName);
        if (dd != null) {
            return dd.getLocalInterface();
        }
        return null;
    }

    public void addReferencedObject(String appName, String beanJNDIName, String jndiLinkName, Object referencedObject) throws EJBManagerException {
        try {
            this.admin.addReferencedObject(appName, beanJNDIName, jndiLinkName, referencedObject);
        }
        catch (NamingException ne) {
            throw new BaseEJBManagerException("ejb_9014", new Object[]{jndiLinkName, beanJNDIName});
        }
    }
}

