/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.handle;

import com.sap.engine.services.ejb.exceptions.BaseIOException;
import com.sap.engine.services.ejb.handle.LocalHandleDelegate;
import com.sap.engine.services.ejb.session.stateless_sp5.BaseContainer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class ServerHandleDelegate
extends LocalHandleDelegate {
    private HandleDelegate local = LocalHandleDelegate.getHandleDelegate();
    private String jndiName;

    public ServerHandleDelegate(String jndiName) {
        this.jndiName = jndiName;
    }

    protected Object readStub(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        Object myHomeReference = this.getHomeFromJNDI();
        ClassLoader appLoader = myHomeReference.getClass().getClassLoader();
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(appLoader);
        try {
            try {
                Object object = super.readStub(istream);
                Object var8_7 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return object;
            }
            catch (IOException ioe) {
                throw (IOException)BaseContainer.traceError(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw (ClassNotFoundException)BaseContainer.traceError(cnfe);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
    }

    protected void writeStub(Remote ejbObject, ObjectOutputStream ostream) throws IOException {
        try {
            super.writeStub(ejbObject, ostream);
        }
        catch (IOException ioe) {
            throw (IOException)BaseContainer.traceError(ioe);
        }
    }

    private Object getHomeFromJNDI() throws IOException {
        try {
            Properties p = new Properties();
            ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            ((Hashtable)p).put("domain", "true");
            InitialContext ctx = new InitialContext(p);
            return ctx.lookup(this.jndiName);
        }
        catch (NamingException nex) {
            throw new BaseIOException("ejb_9003", new Object[]{this.jndiName}, nex);
        }
    }
}

