/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm.multiple;

import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.multiple.ReferenceCollection;
import com.sap.engine.services.ejb.entity.pm.multiple.ReferenceIterator;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchElementException;
import com.sap.tc.logging.Location;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LazyReferenceIterator
extends ReferenceIterator {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$multiple$LazyReferenceIterator == null ? (class$com$sap$engine$services$ejb$entity$pm$multiple$LazyReferenceIterator = LazyReferenceIterator.class$("com.sap.engine.services.ejb.entity.pm.multiple.LazyReferenceIterator")) : class$com$sap$engine$services$ejb$entity$pm$multiple$LazyReferenceIterator));
    PreparedStatement mPreparedStatement = null;
    ResultSet mResultSet = null;
    private Persistent mNextPersistent = null;
    private boolean isForced = false;
    private boolean hasNewCreatedInstancesInCollection = true;
    private boolean mHasNext = false;
    private boolean mMustFetchRS = true;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$multiple$LazyReferenceIterator;

    public LazyReferenceIterator(ReferenceCollection collection, TransactionContext locker) {
        super(collection, locker);
        collection.initResourcesOfLazyIterator(this);
    }

    public boolean hasNext() {
        if (this.isForced) {
            return super.hasNext();
        }
        this.checkIteratorLocker();
        if (this.hasNewCreatedInstancesInCollection) {
            if (this.index < this.collection.size) {
                return true;
            }
            this.hasNewCreatedInstancesInCollection = false;
        }
        try {
            if (this.mMustFetchRS) {
                this.fetchRSToFirstNotAlreadyAddedRow();
                this.mMustFetchRS = false;
            }
        }
        catch (SQLException sqle) {
            BaseEJBException toThrow = new BaseEJBException("ejb_0106", sqle);
            toThrow.trace(LOCATION);
            this.closeResources();
            throw toThrow;
        }
        return this.mHasNext;
    }

    public Object next() {
        if (this.isForced) {
            return super.next();
        }
        this.checkIteratorLocker();
        Object result = null;
        Persistent persistent = null;
        if (this.hasNewCreatedInstancesInCollection) {
            if (this.index < this.collection.size) {
                persistent = this.collection.getItem(this.index++);
            } else {
                this.hasNewCreatedInstancesInCollection = false;
            }
        }
        if (!this.hasNewCreatedInstancesInCollection) {
            try {
                if (this.mMustFetchRS) {
                    this.fetchRSToFirstNotAlreadyAddedRow();
                    if (!this.mHasNext) {
                        throw new BaseNoSuchElementException("ejb_0105");
                    }
                }
                persistent = this.mNextPersistent;
                this.mMustFetchRS = true;
                this.mNextPersistent = null;
            }
            catch (SQLException sqle) {
                BaseEJBException toThrow = new BaseEJBException("ejb_0106", sqle);
                toThrow.trace(LOCATION);
                this.closeResources();
                throw toThrow;
            }
        }
        result = this.collection.getElement(persistent);
        this.mCurrentPersistent = persistent;
        this.removeAllowed = true;
        return result;
    }

    void forceLoadingAndCloseResources() {
        try {
            try {
                if (!this.hasNewCreatedInstancesInCollection) {
                    this.index = this.mMustFetchRS ? this.collection.size : this.collection.size - 1;
                }
                this.collection.extractAllPersistents(this.mResultSet, this.mMustFetchRS);
                this.isForced = true;
            }
            catch (SQLException sqle) {
                BaseEJBException toThrow = new BaseEJBException("ejb_0106", sqle);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            Object var4_1 = null;
            this.closeResources();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.closeResources();
            throw throwable;
        }
    }

    private void fetchRSToFirstNotAlreadyAddedRow() throws SQLException {
        this.mHasNext = false;
        while (this.mResultSet.next()) {
            Persistent persistent = this.collection.extractSinglePersistent(this.mResultSet);
            if (persistent == null) continue;
            this.mNextPersistent = persistent;
            this.mHasNext = true;
            break;
        }
        if (!this.mHasNext) {
            this.collection.isValid = true;
        }
    }

    public void closeResources() {
        this.collection.close1(this.mResultSet, this.mPreparedStatement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

