/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm.multiple;

import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCacheM2M;
import com.sap.engine.services.ejb.entity.pm.PersistentM2M;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.multiple.BasicCollection;
import com.sap.engine.services.ejb.entity.pm.multiple.IteratorM2M;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.tc.logging.Location;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CollectionM2M
extends BasicCollection
implements EntityExceptionConstants {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$multiple$CollectionM2M == null ? (class$com$sap$engine$services$ejb$entity$pm$multiple$CollectionM2M = CollectionM2M.class$("com.sap.engine.services.ejb.entity.pm.multiple.CollectionM2M")) : class$com$sap$engine$services$ejb$entity$pm$multiple$CollectionM2M));
    private PersistentCacheM2M intermediateCache;
    private PersistentM2M createPS;
    private int relId;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$multiple$CollectionM2M;

    public CollectionM2M(Persistent ref, TransactionContext myTransaction, PersistenceManager pManager, PersistentM2M persistentM2M, int relId) {
        super(ref, myTransaction, persistentM2M.getType(ref.getPersistentTypeId()), pManager);
        this.relId = relId;
        this.createPS = persistentM2M;
        this.intermediateCache = this.createPS.getRelationCache();
    }

    public void ejbFlush(Connection conn) {
        this.intermediateCache.ejbFlush(conn, this.ref);
    }

    public boolean add(Object obj) {
        this.checkLocker();
        this.checkValidity();
        Persistent argPersistent = this.verify(obj);
        return this.intermediateCache.add(argPersistent, this.ref);
    }

    public boolean remove(Object obj) {
        this.checkLocker();
        this.checkValidity();
        Persistent argPersistent = this.verify(obj);
        return this.intermediateCache.remove(argPersistent, this.ref);
    }

    public int size() {
        this.checkLocker();
        this.checkValidity();
        return this.intermediateCache.countSize(this.ref);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object obj) {
        this.checkLocker();
        this.checkValidity();
        Persistent argPersistent = this.verify(obj);
        PersistentM2M relation = this.intermediateCache.newPersistentM2M(this.ref, argPersistent);
        Object m2m = this.intermediateCache.get(relation);
        return m2m != null && !((PersistentM2M)m2m).checkDeleted();
    }

    public Iterator iterator() {
        this.checkLocker();
        this.checkValidity();
        return new IteratorM2M(this.lockerTX, this.pm, this.intermediateCache, this.ref);
    }

    public Object[] toArray() {
        return this.intermediateCache.toArray(this.ref);
    }

    public Object[] toArray(Object[] a) {
        Object[] content = this.intermediateCache.toArray(this.ref);
        if (a.length < content.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), content.length);
        }
        System.arraycopy(content, 0, a, 0, content.length);
        if (a.length > content.length) {
            a[content.length] = null;
        }
        return a;
    }

    public boolean containsAll(Collection c) {
        this.checkLocker();
        this.checkValidity();
        if (c == null) {
            return true;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Persistent argPersistent = this.verify(it.next());
            PersistentM2M relation = this.intermediateCache.newPersistentM2M(argPersistent, this.ref);
            Object m2m = this.intermediateCache.get(relation);
            if (m2m != null && !((PersistentM2M)m2m).checkDeleted()) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        this.checkLocker();
        return this.outerAddAll(c);
    }

    public boolean outerAddAll(Collection c) {
        if (c == null) {
            return false;
        }
        this.checkValidity();
        boolean modified = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Persistent argPersistent = this.verify(it.next());
            if (!this.intermediateCache.add(argPersistent, this.ref)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            return false;
        }
        this.checkValidity();
        boolean modified = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Persistent argPersistent = this.verify(it.next());
            if (!this.intermediateCache.remove(argPersistent, this.ref)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        if (c == null || c.isEmpty()) {
            if (this.size() == 0) {
                return false;
            }
            this.clear();
            return true;
        }
        this.checkValidity();
        Vector<Object> vector = new Vector<Object>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            vector.add(this.verify(it.next()).getPrimaryKey());
        }
        return this.intermediateCache.retainAll(this.ref, vector);
    }

    public void clear() {
        this.checkLocker();
        this.outerClear();
    }

    public void outerClear() {
        this.checkValidity();
        this.intermediateCache.clear(this.ref);
    }

    public boolean equals(Object o) {
        return false;
    }

    public void checkValidity() {
        if (this.isValid) {
            return;
        }
        this.loadCollection();
        this.isValid = true;
    }

    protected void loadCollection() {
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rset = null;
        TransactionContext tc = this.pm.getTransactionContext();
        int status = 0x4000000;
        try {
            try {
                conn = tc.getConnection();
                try {
                    pst = this.createPS.createPreparedStatement(this.ref, conn);
                }
                catch (Exception e) {
                    BaseEJBException toThrow = new BaseEJBException("ejb_0098", e);
                    toThrow.trace(LOCATION);
                    throw toThrow;
                }
                rset = pst.executeQuery();
                boolean repRead = this.pm.getIsolationLevel() == 1;
                while (rset.next()) {
                    this.intermediateCache.extractPersistent(rset, repRead);
                }
            }
            catch (SQLException sqle) {
                status = 0x20000000;
                BaseEJBException toThrow = new BaseEJBException("ejb_0098", sqle);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            Object var9_11 = null;
            this.close1(rset, pst);
            if (conn != null) {
                tc.releaseConnection(status);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.close1(rset, pst);
            if (conn != null) {
                tc.releaseConnection(status);
            }
            throw throwable;
        }
    }

    protected void logInfo(Throwable t) {
        LOCATION.traceThrowableT(300, null, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

