/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm.multiple;

import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.UpdatablePersistent;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;

public abstract class BasicCollection
extends LinearItemAdapter
implements Set {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$multiple$BasicCollection == null ? (class$com$sap$engine$services$ejb$entity$pm$multiple$BasicCollection = BasicCollection.class$("com.sap.engine.services.ejb.entity.pm.multiple.BasicCollection")) : class$com$sap$engine$services$ejb$entity$pm$multiple$BasicCollection));
    public Persistent ref;
    protected PersistenceManager pm;
    protected boolean isValid = false;
    protected int foreignPTypeId = 0;
    protected PersistentCache foreignCache;
    protected TransactionContext lockerTX;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$multiple$BasicCollection;

    public BasicCollection(Persistent ref, TransactionContext myTransaction, int foreignPTypeId, PersistenceManager pManager) {
        this.ref = ref;
        this.foreignPTypeId = foreignPTypeId;
        this.pm = pManager;
        this.foreignCache = myTransaction.getPersistentCache(foreignPTypeId);
        this.lockerTX = myTransaction;
    }

    protected void checkLocker() {
        TransactionContext tc = this.pm.getTransactionContext();
        if (!tc.equals(this.lockerTX)) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0096");
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    protected Persistent verify(Object obj) {
        if (obj == null) {
            BaseIllegalArgumentException toThrow = new BaseIllegalArgumentException("ejb_2184");
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        EJBLocalObject lobj = null;
        try {
            lobj = (EJBLocalObject)obj;
        }
        catch (ClassCastException e) {
            BaseIllegalArgumentException toThrow = new BaseIllegalArgumentException("ejb_2188", new Object[]{obj.getClass().getName()}, e);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        Object pk = lobj.getPrimaryKey();
        String foreignInterfaceName = this.foreignCache.getLocalIntfName();
        String argumentInterfaceName = lobj.getClass().getInterfaces()[0].getName();
        if (foreignInterfaceName.equals(argumentInterfaceName)) {
            Persistent pers = (Persistent)this.foreignCache.supply(pk);
            ((UpdatablePersistent)this.ref).checkArgument((UpdatablePersistent)pers);
            return pers;
        }
        BaseIllegalArgumentException toThrow = new BaseIllegalArgumentException("ejb_2188", new Object[]{obj.getClass().getName()});
        toThrow.trace(LOCATION);
        throw toThrow;
    }

    public void markInvalid() {
        this.isValid = false;
    }

    protected void close1(ResultSet rset, PreparedStatement pst) {
        try {
            if (rset != null) {
                rset.close();
            }
        }
        catch (SQLException sqle) {
            this.logInfo(sqle);
        }
        try {
            if (pst != null) {
                pst.close();
            }
        }
        catch (SQLException sqle) {
            this.logInfo(sqle);
        }
    }

    protected void close(ResultSet rset, PreparedStatement pst, Connection conn) {
        try {
            if (rset != null) {
                rset.close();
            }
        }
        catch (SQLException sqle) {
            this.logInfo(sqle);
        }
        try {
            if (pst != null) {
                pst.close();
            }
        }
        catch (SQLException sqle) {
            this.logInfo(sqle);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            this.logInfo(sqle);
        }
    }

    protected void throwEJBException(String message, Exception ex) throws EJBException {
        Throwable nestedEx = ex;
        if (ex instanceof InvocationTargetException && (nestedEx = ((InvocationTargetException)ex).getTargetException()) == null) {
            nestedEx = ex;
        }
        throw new BaseEJBException(message, nestedEx);
    }

    protected abstract void logInfo(Throwable var1);

    public abstract void clear();

    public abstract boolean removeAll(Collection var1);

    public abstract boolean retainAll(Collection var1);

    public abstract boolean addAll(Collection var1);

    public abstract boolean containsAll(Collection var1);

    public abstract boolean remove(Object var1);

    public abstract boolean add(Object var1);

    public abstract Object[] toArray(Object[] var1);

    public abstract Object[] toArray();

    public abstract Iterator iterator();

    public abstract boolean contains(Object var1);

    public abstract boolean isEmpty();

    public abstract int size();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

