/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm.lock;

import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.lock.LockException;
import com.sap.engine.services.ejb.entity.pm.lock.LockObject;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystem;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;

public class LockSystemImpl
implements LockSystem {
    private LockingContext lockCtx;

    public LockSystemImpl(LockingContext _lockCtx) {
        this.lockCtx = _lockCtx;
    }

    public void read(LockObject object, TransactionContext transaction) {
        if (!object.readCheck(transaction)) {
            try {
                this.lockCtx.getAdministrativeLocking().lock(transaction.getLockName(this.lockCtx), object.getAreaName(), object.getLockID(), 'S');
            }
            catch (com.sap.engine.frame.core.locking.LockException le) {
                throw new LockException("ejb_0203", (Throwable)((Object)le));
            }
            catch (TechnicalLockException tle) {
                throw new BaseEJBException("ejb_0205", (Throwable)((Object)tle));
            }
            object.setReadLock(transaction);
        }
    }

    public void write(LockObject object, TransactionContext transaction, boolean toFlush) {
        TransactionContext locker = object.writeCheck(transaction, toFlush);
        if (locker != null) {
            try {
                this.lockCtx.getAdministrativeLocking().lock(locker.getLockName(this.lockCtx), object.getAreaName(), object.getLockID(), 'E');
            }
            catch (com.sap.engine.frame.core.locking.LockException le) {
                throw new LockException("ejb_0204", (Throwable)((Object)le));
            }
            catch (TechnicalLockException tle) {
                throw new BaseEJBException("ejb_0206", (Throwable)((Object)tle));
            }
            object.setWriteLock(transaction, toFlush);
        }
    }

    public void unlockAll(String owner) {
        try {
            if (owner != null) {
                this.lockCtx.getAdministrativeLocking().unlockAll(owner, true);
            }
        }
        catch (TechnicalLockException tle) {
            throw new BaseEJBException("ejb_0207", (Throwable)((Object)tle));
        }
    }
}

