/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm;

import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.lock.LockException;
import com.sap.engine.services.ejb.entity.pm.lock.LockObject;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystem;
import com.sap.engine.services.ejb.entity.pm.multiple.ReferenceCollection;
import com.sap.engine.services.ejb.exceptions.BaseDuplicateKeyException;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchEntityException;
import com.sap.engine.services.ejb.exceptions.BaseObjectNotFoundException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EntityBean;
import javax.ejb.ObjectNotFoundException;

public abstract class UpdatablePersistent
extends LockObject
implements Persistent,
EntityExceptionConstants {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent == null ? (class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent = UpdatablePersistent.class$("com.sap.engine.services.ejb.entity.pm.UpdatablePersistent")) : class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent));
    public int pm_status = 1;
    private boolean flushing = false;
    public EntityBean beanPM = null;
    protected boolean loaded;
    private static int bytesInInputStream = 0;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent;

    public void rsLoad(ResultSet rs, boolean repRead, boolean dbLocking) throws SQLException {
        if (!this.loaded) {
            if (repRead && !dbLocking) {
                this.getLockSystem().read(this, this.getPM().getTransactionContext());
            }
            this.extract(rs);
        }
    }

    public void ejbFlush(Connection conn) throws EJBException {
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        try {
            switch (this.pm_status) {
                case 2: {
                    this.ins_updDependence(conn);
                    this.ejb_iUpdate(conn);
                    this.pm_status = 1;
                    break;
                }
                case 3: {
                    this.deleteDependence(conn);
                    this.ejb_iDelete(conn);
                    this.pm_status = 5;
                    break;
                }
                case 4: {
                    this.ins_updDependence(conn);
                    this.ejb_iInsert(conn);
                    this.pm_status = 1;
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            BaseEJBException toThrow = new BaseEJBException("ejb_0053", new Object[]{this.getClass().getName()}, sqle);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public void ejbEndFlushFinderMethod() {
        this.flushing = false;
    }

    public void ejbFinish(TransactionContext locker, boolean committed) {
        this.flushing = false;
        if (!committed) {
            this.loaded = false;
            this.markNotLoaded();
            this.beanPM = null;
        }
        if (this.pm_status == 5) {
            this.loaded = false;
        }
        this.pm_status = 1;
        this.unlock(locker);
    }

    public void correctCreate(TransactionContext t, UpdatablePersistent p) throws DuplicateKeyException {
        block8: {
            block7: {
                if (this.writeLocker == null) break block7;
                switch (this.pm_status) {
                    case 5: {
                        this.pm_status = 4;
                        this.copyCMPFields(p);
                        break block8;
                    }
                    case 3: {
                        this.pm_status = 2;
                        this.copyCMPFields(p);
                        break block8;
                    }
                    default: {
                        BaseDuplicateKeyException toThrow = new BaseDuplicateKeyException("ejb_0055", new Object[]{this.getClass().getName()});
                        toThrow.trace(LOCATION);
                        throw toThrow;
                    }
                }
            }
            if (this.loaded) {
                BaseDuplicateKeyException toThrow = new BaseDuplicateKeyException("ejb_0055", new Object[]{this.getClass().getName()});
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            try {
                this.getLockSystem().write(this, t, true);
            }
            catch (LockException e) {
                BaseDuplicateKeyException toThrow = new BaseDuplicateKeyException("ejb_0056", new Object[]{this.getClass().getName()}, e);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            this.copyCMPFields(p);
            this.pm_status = 4;
            this.loaded = true;
        }
    }

    private void writeLock(TransactionContext temporary, boolean toFlush) {
        this.getLockSystem().write(this, temporary, toFlush);
        if (!this.loaded) {
            Connection conn = null;
            int status = 0x4000000;
            try {
                try {
                    conn = temporary.getConnection();
                    this.ejb_iLoad(conn);
                }
                catch (SQLException e) {
                    status = 0x20000000;
                    BaseEJBException toThrow = new BaseEJBException("ejb_0057", new Object[]{this.getClass().getName()}, e);
                    toThrow.trace(LOCATION);
                    throw toThrow;
                }
                Object var8_5 = null;
                if (conn != null) {
                    temporary.releaseConnection(status);
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (conn != null) {
                    temporary.releaseConnection(status);
                }
                throw throwable;
            }
        }
    }

    public void writeOperation(TransactionContext temporary, boolean toFlush) {
        this.writeLock(temporary, toFlush);
        if (toFlush) {
            this.update();
        } else {
            this.updateCheck();
        }
    }

    public void lockFoundObjects(ResultSet rs, PersistentCache pCache, boolean writeLock) throws SQLException {
        TransactionContext currentTx = this.getPM().getTransactionContext();
        while (rs.next()) {
            Object pk = this.extractPrimaryKey(rs);
            UpdatablePersistent loadedObject = (UpdatablePersistent)pCache.supply(pk);
            if (writeLock) {
                this.getLockSystem().write(loadedObject, currentTx, false);
                continue;
            }
            this.getLockSystem().read(loadedObject, currentTx);
        }
    }

    public void create(TransactionContext temporary) {
        this.getLockSystem().write(this, temporary, true);
        this.pm_status = 4;
        this.loaded = true;
    }

    public void update() {
        if (this.pm_status != 2 && this.pm_status != 4) {
            if (this.pm_status == 1) {
                this.pm_status = 2;
            } else {
                this.beanPM = null;
                throw new BaseNoSuchEntityException("ejb_0058", new Object[]{"update", this.getClass().getName()});
            }
        }
    }

    public void updateCheck() {
        if (this.pm_status == 3 || this.pm_status == 5) {
            this.beanPM = null;
            throw new BaseNoSuchEntityException("ejb_0058", new Object[]{"update", this.getClass().getName()});
        }
    }

    public void delete() {
        if (this.pm_status == 3 || this.pm_status == 5) {
            this.beanPM = null;
            throw new BaseNoSuchEntityException("ejb_0058", new Object[]{"delete", this.getClass().getName()});
        }
        if (this.pm_status == 2 || this.pm_status == 1) {
            this.pm_status = 3;
        }
        if (this.pm_status == 4) {
            this.pm_status = 5;
        }
    }

    public boolean isRemoved() {
        return this.pm_status == 5 || this.pm_status == 3;
    }

    public void checkArgument(UpdatablePersistent persistent) {
        if (persistent.pm_status == 3 || persistent.pm_status == 5) {
            throw new BaseIllegalArgumentException("ejb_0059", new Object[]{persistent.getClass().getName()});
        }
    }

    public static InputStream writeObjectToInputStream(Object obj) {
        if (obj != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(obj);
                byte[] bytes = bos.toByteArray();
                bytesInInputStream = bytes.length;
                return new ByteArrayInputStream(bytes);
            }
            catch (Exception e) {
                BaseEJBException toThrow = new BaseEJBException("ejb_0060", new Object[]{obj.getClass().getName()}, e);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        return null;
    }

    public String readerToString(Reader r) {
        StringBuffer sBuffer = new StringBuffer();
        char[] chArr = new char[32];
        try {
            int readed = r.read(chArr);
            while (readed > -1) {
                sBuffer.append(chArr, 0, readed);
                readed = r.read(chArr);
            }
        }
        catch (Exception e) {
            BaseEJBException toThrow = new BaseEJBException("ejb_0060", new Object[0], e);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return sBuffer.toString();
    }

    public int getBytesInInputStream() {
        return bytesInInputStream;
    }

    public boolean isFound(TransactionContext t) throws ObjectNotFoundException {
        if (this.writeLocker != null && this.writeLocker.equals(t)) {
            if (this.pm_status == 3 || this.pm_status == 5) {
                BaseObjectNotFoundException toThrow = new BaseObjectNotFoundException("ejb_0081");
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            return this.pm_status == 4 || this.pm_status == 2;
        }
        return false;
    }

    protected abstract void ins_updDependence(Connection var1);

    protected abstract void deleteDependence(Connection var1);

    protected abstract void markNotLoaded();

    protected abstract void copyCMPFields(UpdatablePersistent var1);

    protected void ejb_iLoad() throws SQLException {
        throw new BaseIllegalStateException("Abstract class implementation.");
    }

    protected void ejb_iLoad(Connection c) throws SQLException {
        this.ejb_iLoad();
    }

    protected abstract void ejb_iUpdate(Connection var1) throws SQLException;

    protected abstract void ejb_iDelete(Connection var1) throws SQLException;

    protected abstract void ejb_iInsert(Connection var1) throws SQLException;

    public abstract void extract(ResultSet var1) throws SQLException;

    protected abstract PersistenceManager getPM();

    protected abstract LockSystem getLockSystem();

    public abstract void initTransaction(TransactionContext var1);

    public abstract boolean isInRelationshipWith(ReferenceCollection var1);

    public abstract int getPersistentTypeId();

    public abstract PreparedStatement createPreparedStatement(String var1, Connection var2) throws SQLException;

    public abstract EJBLocalObject getEJBLocalObject();

    public abstract Object extractPrimaryKey(ResultSet var1, String[] var2) throws SQLException;

    public abstract Object extractPrimaryKey(ResultSet var1) throws SQLException;

    public abstract Object getPrimaryKey();

    public abstract void init(Object var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

