/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm;

import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContextException;
import com.sap.engine.lib.util.base.BaseDoublyLinkedList;
import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.lib.util.base.PrevItem;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.entity.pm.PMTransactionListener;
import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.PersistentCacheM2M;
import com.sap.engine.services.ejb.entity.pm.ThreadedPersistentCache;
import com.sap.engine.services.ejb.entity.pm.TransactionListener;
import com.sap.engine.services.ejb.entity.pm.TransactionalPersistentCache;
import com.sap.engine.services.ejb.entity.pm.UpdatablePersistent;
import com.sap.engine.services.ejb.entity.pm.lock.DbLockSystemImpl;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystem;
import com.sap.engine.services.ejb.entity.pm.multiple.ReferenceCollection;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import javax.ejb.EJBException;

public final class TransactionContext
extends BaseDoublyLinkedList
implements EntityExceptionConstants,
PMTransactionListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$TransactionContext == null ? (class$com$sap$engine$services$ejb$entity$pm$TransactionContext = TransactionContext.class$("com.sap.engine.services.ejb.entity.pm.TransactionContext")) : class$com$sap$engine$services$ejb$entity$pm$TransactionContext));
    private static final String PERSISTENCE_MANAGER_COMPONENT_NAME = "PersistenceManager";
    private static final String PERSISTENCE_MANAGER_METHOD_NAME = "Persistence_manager_methods_using_transactional_connection";
    private LinearItemAdapter item = new LinearItemAdapter();
    private Connection connection;
    private PersistenceManager pm;
    private Object key;
    private boolean global;
    private boolean toFlush;
    private String lockName;
    private ResourceContext myResource = null;
    private int pCacheSize = 0;
    private int relationCacheSize = 0;
    private PersistentCache[] pCache;
    private PersistentCacheM2M[] relationCache;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$TransactionContext;

    public TransactionContext(Object _key, PersistenceManager _pm, boolean _global, int pCacheSize, int relationCacheSize) {
        this.key = _key;
        this.pm = _pm;
        this.global = _global;
        this.pCacheSize = pCacheSize;
        this.relationCacheSize = relationCacheSize;
        this.pCache = new PersistentCache[pCacheSize];
        this.relationCache = new PersistentCacheM2M[relationCacheSize];
    }

    public boolean isGlobal() {
        return this.global;
    }

    public PersistentCache getPersistentCache(int pTypeId) {
        if (this.pCache[pTypeId] == null) {
            CMPEntityDescriptor descriptor = this.pm.getCMPDescriptor(pTypeId);
            this.pCache[pTypeId] = this.isGlobal() ? new TransactionalPersistentCache(descriptor.getCacheSize(), this) : new ThreadedPersistentCache(descriptor.getCacheSize(), this);
            this.pCache[pTypeId].init(descriptor, this.pm.getPersistentClass(pTypeId), this.pm);
        }
        return this.pCache[pTypeId];
    }

    public PersistentCacheM2M getRelationCache(int relId) {
        if (this.relationCache[relId] == null) {
            RelationDescriptor descriptor = this.pm.getRelDescriptor(relId);
            this.relationCache[relId] = new PersistentCacheM2M();
            this.relationCache[relId].init(descriptor, this.pm.cLoader, this.pm, this.pm.getAbstractSchemaIndex(), this);
        }
        return this.relationCache[relId];
    }

    public void addPMListener(TransactionListener p, boolean isUpdate) {
        String methodSign = "addPMListener(TransactionListener p, boolean isUpdate)";
        if (LOCATION.bePath()) {
            LOCATION.entering("addPMListener(TransactionListener p, boolean isUpdate)", new Object[]{p, new Boolean(isUpdate)});
        }
        try {
            this.addLastItem(p);
            if (isUpdate) {
                this.toFlush = true;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public Connection getLockingConnection() {
        return this.simpleGetConnection();
    }

    private Connection simpleGetConnection() {
        String methodSign = "simpleGetConnection()";
        LOCATION.entering("simpleGetConnection()");
        Connection lockingCon = null;
        try {
            try {
                this.myResource = Environment.getEnvironment().getResourceContextFactory().createContext(this.pm.getApplicationName(), PERSISTENCE_MANAGER_COMPONENT_NAME, false);
                this.myResource.enterMethod(PERSISTENCE_MANAGER_METHOD_NAME);
            }
            catch (Exception e) {
                throw new BaseEJBException("ejb_0061", e);
            }
            try {
                lockingCon = this.pm.getConnection();
            }
            catch (SQLException sql) {
                try {
                    this.myResource.exitMethod(PERSISTENCE_MANAGER_METHOD_NAME, false);
                }
                catch (ResourceContextException rce) {
                    throw new BaseIllegalStateException("ejb_0036", rce);
                }
                throw new BaseEJBException("ejb_0062", sql);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            LOCATION.exiting(lockingCon);
            throw throwable;
        }
        LOCATION.exiting((Object)lockingCon);
        return lockingCon;
    }

    public void releaseLockingConnection(Connection lockingCon) {
        String methodSign = "releaseLockingConnection(Connection lockingCon)";
        LOCATION.entering("releaseLockingConnection(Connection lockingCon)", new Object[]{lockingCon});
        try {
            int success = 0x4000000;
            try {
                lockingCon.close();
            }
            catch (SQLException se) {
                LOCATION.traceThrowableT(300, null, (Throwable)se);
                success = 0x20000000;
            }
            if (this.myResource != null) {
                try {
                    this.myResource.exitMethod(PERSISTENCE_MANAGER_METHOD_NAME, success == 0x4000000);
                }
                catch (ResourceContextException rce) {
                    throw new BaseIllegalStateException("ejb_0036", rce);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public String getLockName(LockingContext lockCtx) throws TechnicalLockException {
        if (this.lockName == null) {
            this.lockName = lockCtx.getAdministrativeLocking().createUniqueOwner();
        }
        return this.lockName;
    }

    public String getLockName() {
        return this.lockName;
    }

    public void setToFlush() {
        this.toFlush = true;
    }

    public boolean toFlush() {
        return this.toFlush;
    }

    public Connection getConnection() {
        String methodSign = "getConnection()";
        LOCATION.entering("getConnection()");
        try {
            if (this.connection == null) {
                this.connection = this.simpleGetConnection();
            } else {
                try {
                    this.myResource.enterMethod(PERSISTENCE_MANAGER_METHOD_NAME);
                }
                catch (ResourceContextException rce) {
                    throw new BaseEJBException("ejb_0061", rce);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            LOCATION.exiting((Object)this.connection);
            throw throwable;
        }
        LOCATION.exiting((Object)this.connection);
        return this.connection;
    }

    public void releaseConnection(int success) {
        String methodSign = "releaseConnection(int success)";
        if (LOCATION.bePath()) {
            LOCATION.entering("releaseConnection(int success)", new Object[]{new Integer(success)});
        }
        try {
            if (this.connection != null && this.myResource != null) {
                try {
                    this.myResource.exitMethod(PERSISTENCE_MANAGER_METHOD_NAME, success == 0x4000000);
                }
                catch (ResourceContextException rce) {
                    throw new BaseIllegalStateException("ejb_0036", rce);
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    private void releaseConnectionAndClose(int status) {
        String methodSign = "releaseConnectionAndClose( int status )";
        if (LOCATION.bePath()) {
            LOCATION.entering("releaseConnectionAndClose( int status )", new Object[]{new Integer(status)});
        }
        try {
            int success = status;
            if (this.connection != null) {
                if (LOCATION.bePath()) {
                    LOCATION.pathT("releaseConnectionAndClose( int status )", "Closing connection " + this.connection);
                }
                try {
                    this.connection.close();
                }
                catch (SQLException se) {
                    LOCATION.traceThrowableT(300, null, (Throwable)se);
                    success = 0x20000000;
                }
                this.releaseConnection(success);
                this.connection = null;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    private void closeConnection(int success) {
        String methodSign = "closeConnection( int success )";
        if (LOCATION.bePath()) {
            LOCATION.entering("closeConnection( int success )", new Object[]{new Integer(success)});
        }
        try {
            if (this.connection != null) {
                try {
                    this.myResource.enterMethod(PERSISTENCE_MANAGER_METHOD_NAME);
                }
                catch (Exception e) {
                    throw new BaseEJBException("ejb_0061", e);
                }
                this.releaseConnectionAndClose(success);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void flush() {
        String methodSign = "flush()";
        LOCATION.entering("flush()");
        try {
            int success = 0x20000000;
            try {
                this.getConnection();
                this.flushAll();
                success = 0x4000000;
                Object var5_3 = null;
                this.releaseConnectionAndClose(success);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.releaseConnectionAndClose(success);
                throw throwable;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void flushAllBeforeFindMethod() {
        methodSign = "flushAllBeforeFindMethod()";
        TransactionContext.LOCATION.entering("flushAllBeforeFindMethod()");
        if (TransactionContext.LOCATION.bePath()) {
            TransactionContext.LOCATION.pathT("flushAllBeforeFindMethod()", "Value of flag 'toFlush' is " + this.toFlush());
        }
        try {
            block8: {
                if (this.toFlush()) {
                    try {
                        this.flushAll();
                        var3_2 = null;
                        current /* !! */  = this.getFirstItem();
                        ** while (current /* !! */  != null)
                    }
                    catch (Throwable var2_6) {
                        var3_3 = null;
                        current /* !! */  = this.getFirstItem();
                        ** while (current /* !! */  != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((TransactionListener)current /* !! */ ).ejbEndFlushFinderMethod();
                        current /* !! */  = current /* !! */ .getNext();
                        continue;
lbl18:
                        // 1 sources

                        break block8;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((TransactionListener)current /* !! */ ).ejbEndFlushFinderMethod();
                        current /* !! */  = current /* !! */ .getNext();
                        continue;
                    }
lbl27:
                    // 1 sources

                    throw var2_6;
                }
            }
            var6_7 = null;
        }
        catch (Throwable var5_9) {
            var6_8 = null;
            TransactionContext.LOCATION.exiting();
            throw var5_9;
        }
        TransactionContext.LOCATION.exiting();
    }

    public void flushAll() {
        String methodSign = "flushAll()";
        LOCATION.entering("flushAll()");
        try {
            NextItem current = this.getFirstItem();
            while (current != null) {
                ((TransactionListener)current).ejbFlush(this.connection);
                current = current.getNext();
            }
            this.toFlush = false;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finishWork() {
        String methodSign = "finishWork()";
        LOCATION.entering("finishWork()");
        if (LOCATION.bePath()) {
            LOCATION.pathT("finishWork()", "Value of flag 'global' is " + this.global);
        }
        try {
            if (!this.global) {
                boolean ok = true;
                try {
                    try {
                        if (this.toFlush) {
                            this.flush();
                        } else {
                            this.closeConnection(0x4000000);
                        }
                        this.finishAllSelectForUpdate(3);
                    }
                    catch (EJBException e) {
                        ok = false;
                        throw e;
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    TransactionListener listener = (TransactionListener)this.getFirstItem();
                    if (listener != null) {
                        LockSystem lockSystem = this.pm.getLockSystem();
                        lockSystem.unlockAll(this.getLockName());
                        listener.ejbFinish(this, ok);
                    }
                    this.pCache = new PersistentCache[this.pCacheSize];
                    this.relationCache = new PersistentCacheM2M[this.relationCacheSize];
                    throw throwable;
                }
                TransactionListener listener = (TransactionListener)this.getFirstItem();
                if (listener != null) {
                    LockSystem lockSystem = this.pm.getLockSystem();
                    lockSystem.unlockAll(this.getLockName());
                    listener.ejbFinish(this, ok);
                }
                this.pCache = new PersistentCache[this.pCacheSize];
                this.relationCache = new PersistentCacheM2M[this.relationCacheSize];
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            TransactionContext tc = (TransactionContext)obj;
            return this.global == tc.global && this.key.equals(tc.key);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(300, null, (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public void beforeCompletion() {
        String methodSign = "beforeCompletion()";
        LOCATION.entering("beforeCompletion()");
        try {
            int success = 0x20000000;
            try {
                try {
                    if (this.toFlush) {
                        this.flush();
                    } else {
                        this.closeConnection(0x4000000);
                    }
                    success = 0x4000000;
                }
                catch (EJBException e) {
                    LOCATION.traceThrowableT(500, null, (Throwable)e);
                    success = 0x20000000;
                    throw e;
                }
                Object var5_3 = null;
                this.finishAllSelectForUpdate(success);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.finishAllSelectForUpdate(success);
                throw throwable;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void afterCompletion(int status) {
        String methodSign = "afterCompletion(int status)";
        if (LOCATION.bePath()) {
            LOCATION.entering("afterCompletion(int status)", new Object[]{new Integer(status)});
        }
        try {
            this.pm.getLockSystem().unlockAll(this.getLockName());
            this.pm.removeTransactionContext(this.key);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void beforeRollback() {
        String methodSign = "beforeRollback()";
        LOCATION.entering("beforeRollback()");
        try {
            this.closeConnection(0x20000000);
            this.finishAllSelectForUpdate(0x20000000);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void finishAllSelectForUpdate(int status) {
        String methodSign = "finishAllSelectForUpdate(int status)";
        if (LOCATION.bePath()) {
            LOCATION.entering("finishAllSelectForUpdate(int status)", new Object[]{new Integer(status)});
        }
        try {
            NextItem current = this.getFirstItem();
            while (current != null) {
                if (current instanceof UpdatablePersistent) {
                    UpdatablePersistent up = (UpdatablePersistent)current;
                    current = current.getNext();
                    if (!(up.getLockSystem() instanceof DbLockSystemImpl)) continue;
                    up.ejbFinish(this, true);
                    this.removeElement(up);
                    continue;
                }
                if (current instanceof ReferenceCollection) {
                    ReferenceCollection rc = (ReferenceCollection)current;
                    current = current.getNext();
                    rc.ejbFinish(this, true);
                    this.removeElement(rc);
                    continue;
                }
                current = current.getNext();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public PersistenceManager getPM() {
        return this.pm;
    }

    public NextItem getNext() {
        return this.item.getNext();
    }

    public PrevItem getPrev() {
        return this.item.getPrev();
    }

    public void setPrev(PrevItem linkNode) {
        this.item.setPrev(linkNode);
    }

    public void setNext(NextItem linkNode) {
        this.item.setNext(linkNode);
    }

    public void clearItem() {
        this.item.clearItem();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

