/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm;

import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCacheM2M;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.UpdatablePersistent;
import com.sap.engine.services.ejb.entity.pm.lock.LockObject;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.util.ObjectToStringHashing;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;

public abstract class PersistentM2M
extends LockObject {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$PersistentM2M == null ? (class$com$sap$engine$services$ejb$entity$pm$PersistentM2M = PersistentM2M.class$("com.sap.engine.services.ejb.entity.pm.PersistentM2M")) : class$com$sap$engine$services$ejb$entity$pm$PersistentM2M));
    protected int pm_status = 1;
    private boolean flushing = false;
    private PersistentCacheM2M cache;
    public int firstTypeId = 0;
    public int secondTypeId = 0;
    protected UpdatablePersistent first;
    protected UpdatablePersistent second;
    protected String lockId;
    protected Hashtable pkMap;
    private int relId;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$PersistentM2M;

    public PersistentM2M(PersistentCacheM2M cache, UpdatablePersistent _first, UpdatablePersistent _second) {
        this.cache = cache;
        this.first = _first;
        this.firstTypeId = cache.pCache1.getType();
        this.second = _second;
        this.secondTypeId = cache.pCache2.getType();
        this.relId = cache.getRelationId();
    }

    public String getLockID() {
        if (this.lockId == null) {
            String firstId = this.first.getLockID();
            String secondId = this.second.getLockID();
            int size = firstId.length() + secondId.length();
            if (size > 150) {
                int out_of_bounds = size - 150;
                int new_size = (firstId.length() + 1) * out_of_bounds / (151 + out_of_bounds);
                new_size = new_size > 2 ? new_size - 1 : 1;
                firstId = firstId.substring(firstId.length() - new_size);
                new_size = (secondId.length() + 1) * out_of_bounds / (151 + out_of_bounds);
                new_size = new_size > 2 ? new_size - 1 : 1;
                secondId = secondId.substring(secondId.length() - new_size);
            }
            this.lockId = firstId + ObjectToStringHashing.delimitar + secondId;
        }
        return this.lockId;
    }

    public PersistentCacheM2M getRelationCache() {
        return this.cache;
    }

    public EJBLocalObject getEJBLocalObject(int pTypeId) {
        if (this.firstTypeId == pTypeId) {
            return this.second.getEJBLocalObject();
        }
        return this.first.getEJBLocalObject();
    }

    public int getType(int type) {
        if (type == this.firstTypeId) {
            return this.secondTypeId;
        }
        if (type == this.secondTypeId) {
            return this.firstTypeId;
        }
        throw new BaseEJBException("ejb_0063", new Object[]{new Integer(type)});
    }

    public Object getPK(int pTypeId) {
        if (this.firstTypeId == pTypeId) {
            return this.first.getPrimaryKey();
        }
        return this.second.getPrimaryKey();
    }

    public void ejbFlush(Connection conn) throws EJBException {
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        try {
            switch (this.pm_status) {
                case 3: {
                    this.ejb_iDelete(conn);
                    break;
                }
                case 4: {
                    this.insertDependence(conn);
                    this.ejb_iInsert(conn);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    BaseEJBException toTrace = new BaseEJBException("ejb_0120", new Object[]{new Integer(this.pm_status)});
                    LOCATION.traceThrowableT(300, null, (Throwable)((Object)toTrace));
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            throw new BaseEJBException("ejb_0064", sqle);
        }
    }

    public void ejbEndFlushFinderMethod() {
        this.flushing = false;
    }

    protected void insertDependence(Connection conn) {
        TransactionContext modifier = this.cache.pm.getTransactionContext();
        if (modifier.equals(this.first.getModifier())) {
            this.first.ejbFlush(conn);
        }
        if (modifier.equals(this.second.getModifier())) {
            this.second.ejbFlush(conn);
        }
    }

    public void ejbFinish(TransactionContext locker, boolean committed) {
        this.flushing = false;
        this.cache.remove(this);
        this.pm_status = 1;
        this.unlock(locker);
    }

    public void create(TransactionContext temporary, boolean newRel) {
        this.cache.getLockSystem().write(this, temporary, true);
        if (newRel) {
            this.pm_status = 4;
            return;
        }
        switch (this.pm_status) {
            case 3: {
                this.pm_status = 1;
                break;
            }
            case 5: {
                this.pm_status = 4;
                break;
            }
            default: {
                BaseEJBException toTrace = new BaseEJBException("ejb_0120", new Object[]{new Integer(this.pm_status)});
                LOCATION.traceThrowableT(300, null, (Throwable)((Object)toTrace));
            }
        }
    }

    public void delete(TransactionContext temporary) {
        this.cache.getLockSystem().write(this, temporary, true);
        if (this.pm_status == 1) {
            this.pm_status = 3;
        }
        if (this.pm_status == 4) {
            this.pm_status = 5;
        }
    }

    public boolean checkDeleted() {
        return this.pm_status == 3 || this.pm_status == 5;
    }

    public boolean equals(Object obj) {
        PersistentM2M perM2M = null;
        try {
            perM2M = (PersistentM2M)obj;
        }
        catch (ClassCastException cce) {
            LOCATION.traceThrowableT(300, null, (Throwable)cce);
            return false;
        }
        if (perM2M == null || perM2M.relId != this.relId) {
            return false;
        }
        return this.compare(perM2M.first, this.first) && this.compare(perM2M.second, this.second);
    }

    private boolean compare(Persistent p1, Persistent p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    public boolean checkRelation(Persistent relPersistent) {
        return relPersistent.getPrimaryKey().equals(this.getPK(relPersistent.getPersistentTypeId()));
    }

    protected abstract void ejb_iDelete(Connection var1) throws SQLException;

    protected abstract void ejb_iInsert(Connection var1) throws SQLException;

    public abstract PreparedStatement createPreparedStatement(Persistent var1, Connection var2) throws SQLException;

    protected PersistenceManager getPM() {
        return this.first.getPM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

