/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm;

import com.sap.engine.lib.util.Set;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.PersistentM2M;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystem;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.ejb.EJBLocalObject;

public class PersistentCacheM2M
extends Set
implements EntityExceptionConstants {
    protected Class persistentM2M;
    private LockSystem lockSystem = null;
    protected PersistentCache pCache1 = null;
    protected PersistentCache pCache2 = null;
    private Constructor constructor = null;
    private String[] columns1 = null;
    private String[] columns2 = null;
    protected int relId = -1;
    protected PersistenceManager pm = null;
    private TransactionContext myTransaction = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$PersistentCacheM2M;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent;

    public PersistentCacheM2M(int initial) {
        super(initial);
    }

    public PersistentCacheM2M() {
    }

    protected LockSystem getLockSystem() {
        return this.lockSystem;
    }

    protected void init(RelationDescriptor relation, ClassLoader cLoader, PersistenceManager pm, int abstractSchemaId, TransactionContext myTransaction) {
        this.pm = pm;
        this.myTransaction = myTransaction;
        this.relId = relation.getM2MMap().getM2MRelId();
        this.pCache1 = myTransaction.getPersistentCache(relation.getSide1().getEjbId());
        this.pCache2 = myTransaction.getPersistentCache(relation.getSide2().getEjbId());
        this.columns1 = relation.getM2MMap().getColumns1();
        this.columns2 = relation.getM2MMap().getColumns2();
        this.lockSystem = pm.getLockSystem();
        String persistentM2MName = "many2many" + abstractSchemaId + ".PersistentM2M" + this.relId;
        try {
            this.persistentM2M = cLoader.loadClass(persistentM2MName);
            Class[] constrArgTypes = new Class[]{class$com$sap$engine$services$ejb$entity$pm$PersistentCacheM2M == null ? (class$com$sap$engine$services$ejb$entity$pm$PersistentCacheM2M = PersistentCacheM2M.class$("com.sap.engine.services.ejb.entity.pm.PersistentCacheM2M")) : class$com$sap$engine$services$ejb$entity$pm$PersistentCacheM2M, class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent == null ? (class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent = PersistentCacheM2M.class$("com.sap.engine.services.ejb.entity.pm.UpdatablePersistent")) : class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent, class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent == null ? (class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent = PersistentCacheM2M.class$("com.sap.engine.services.ejb.entity.pm.UpdatablePersistent")) : class$com$sap$engine$services$ejb$entity$pm$UpdatablePersistent};
            this.constructor = this.persistentM2M.getConstructor(constrArgTypes);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) == null) {
                t = e;
            }
            throw new BaseEJBException("ejb_0065", new Object[]{this.pCache1.persistentClass.getName(), this.pCache2.persistentClass.getName()}, t);
        }
    }

    public Class getPersistentM2MClass() {
        return this.persistentM2M;
    }

    public void ejbFlush(Connection conn, Persistent ref) {
        SnapShotEnumeration snapShotEnumeration = this.elementsEnumeration();
        while (snapShotEnumeration.hasNext()) {
            PersistentM2M m2m = (PersistentM2M)snapShotEnumeration.next();
            if (!m2m.checkRelation(ref)) continue;
            m2m.ejbFlush(conn);
        }
    }

    public int getRelationId() {
        return this.relId;
    }

    public Object get(Object key) {
        SnapShotEnumeration snapShotEnumeration = this.elementsEnumeration();
        while (snapShotEnumeration.hasNext()) {
            PersistentM2M m2m = (PersistentM2M)snapShotEnumeration.next();
            if (!m2m.equals(key)) continue;
            return m2m;
        }
        return null;
    }

    private int isMember(int type) {
        if (this.pCache1.getType() == type) {
            return 1;
        }
        if (this.pCache2.getType() == type) {
            return 2;
        }
        throw new BaseEJBException("ejb_0066", new Object[]{new Integer(type)});
    }

    public PersistentM2M newPersistentM2M(Persistent pers1, Persistent pers2) {
        if (pers1 == null && pers2 == null) {
            return null;
        }
        Object[] args = new Object[]{this, null, null};
        if (pers1 != null) {
            args[this.isMember((int)pers1.getPersistentTypeId())] = pers1;
        }
        if (pers2 != null) {
            args[this.isMember((int)pers2.getPersistentTypeId())] = pers2;
        }
        return this.createNewInstance(args);
    }

    private PersistentM2M createNewInstance(Object[] args) {
        try {
            return (PersistentM2M)this.constructor.newInstance(args);
        }
        catch (InstantiationException ie) {
            throw new BaseEJBException("ejb_0068", new Object[]{this.constructor.getDeclaringClass().getName()}, ie);
        }
        catch (IllegalAccessException ia) {
            throw new BaseEJBException("ejb_0069", new Object[]{this.constructor.getDeclaringClass().getName()}, ia);
        }
        catch (InvocationTargetException ite) {
            Throwable toThrow = ite.getTargetException();
            if (toThrow == null) {
                toThrow = ite;
            }
            throw new BaseEJBException("ejb_0070", new Object[]{this.constructor.getDeclaringClass().getName()}, toThrow);
        }
    }

    public void clear(Persistent per) {
        SnapShotEnumeration snapShotEnumeration = this.elementsEnumeration();
        while (snapShotEnumeration.hasNext()) {
            PersistentM2M m2m = (PersistentM2M)snapShotEnumeration.next();
            if (!m2m.checkRelation(per)) continue;
            m2m.delete(this.myTransaction);
        }
    }

    public boolean retainAll(Persistent owner, Vector vector) {
        SnapShotEnumeration snapShotEnumeration = this.elementsEnumeration();
        boolean modified = false;
        while (snapShotEnumeration.hasNext()) {
            PersistentM2M m2m = (PersistentM2M)snapShotEnumeration.next();
            if (!m2m.checkRelation(owner) || vector.contains(m2m.getPK(m2m.getType(owner.getPersistentTypeId())))) continue;
            m2m.delete(this.myTransaction);
            modified = true;
        }
        return modified;
    }

    public boolean add(Persistent persistent, Persistent ref) {
        PersistentM2M relation = this.newPersistentM2M(persistent, ref);
        PersistentM2M oldRel = (PersistentM2M)this.get(relation);
        if (oldRel == null) {
            relation.create(this.myTransaction, true);
            this.add(relation);
            return true;
        }
        oldRel.create(this.myTransaction, false);
        return false;
    }

    public boolean remove(Persistent persistent, Persistent ref) {
        PersistentM2M relation = (PersistentM2M)this.get(this.newPersistentM2M(persistent, ref));
        if (relation == null) {
            return false;
        }
        relation.delete(this.myTransaction);
        return true;
    }

    public Object[] toArray(Persistent per) {
        Vector<EJBLocalObject> ejblos = new Vector<EJBLocalObject>();
        SnapShotEnumeration snapShotEnumeration = this.elementsEnumeration();
        while (snapShotEnumeration.hasNext()) {
            PersistentM2M m2m = (PersistentM2M)snapShotEnumeration.next();
            if (!m2m.checkRelation(per) || m2m.checkDeleted()) continue;
            ejblos.add(m2m.getEJBLocalObject(per.getPersistentTypeId()));
        }
        return ejblos.toArray();
    }

    public int countSize(Persistent per) {
        int size = 0;
        SnapShotEnumeration snapShotEnumeration = this.elementsEnumeration();
        while (snapShotEnumeration.hasNext()) {
            PersistentM2M m2m = (PersistentM2M)snapShotEnumeration.next();
            if (!m2m.checkRelation(per) || m2m.checkDeleted()) continue;
            ++size;
        }
        return size;
    }

    public void extractPersistent(ResultSet rset, boolean repRead) throws SQLException {
        Object pk1 = this.pm.getStaticInstance(this.pCache1.getType()).extractPrimaryKey(rset, this.columns1);
        Object pk2 = this.pm.getStaticInstance(this.pCache2.getType()).extractPrimaryKey(rset, this.columns2);
        Persistent persistent1 = (Persistent)this.pCache1.supply(pk1);
        Persistent persistent2 = (Persistent)this.pCache2.supply(pk2);
        Object[] args = new Object[]{this, persistent1, persistent2};
        PersistentM2M perM2M = this.createNewInstance(args);
        if (this.get(perM2M) == null) {
            this.add(perM2M);
            TransactionContext tx = this.myTransaction;
            if (repRead) {
                this.lockSystem.read(perM2M, tx);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

