/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.pm;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.entity.SynchronizationList;
import com.sap.engine.services.ejb.entity.pm.AbstractSchemaID;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.PersistentCacheM2M;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.lock.DbLockSystemImpl;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystem;
import com.sap.engine.services.ejb.entity.pm.lock.TableLockingSystem;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.tc.logging.Location;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class PersistenceManager
implements EntityExceptionConstants {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$pm$PersistenceManager == null ? (class$com$sap$engine$services$ejb$entity$pm$PersistenceManager = PersistenceManager.class$("com.sap.engine.services.ejb.entity.pm.PersistenceManager")) : class$com$sap$engine$services$ejb$entity$pm$PersistenceManager));
    public static final String TX_DS_NAME_PREFIX = "ejbContainer/cmp/tx/";
    public static final String NO_TX_DS_NAME_PREFIX = "ejbContainer/cmp/notx/";
    public static final int TRANSACTION_REPEATABLE_READ = 1;
    public static final int TRANSACTION_READ_COMMITTED = 4;
    private DataSource ds;
    private DataSource localds;
    private boolean optimistic;
    private ThreadSystem threadSystem = null;
    private TransactionManager transactionManager = null;
    private DataBaseProperties dbProperties;
    private Environment env;
    private boolean applicationIsStopped = false;
    private LockSystem lockSystem;
    private LockSystem dbLockSystem;
    private boolean localLocking = false;
    private AbstractSchemaID schemaId;
    private ConfigurationHandler handler = null;
    private String appName = null;
    private CMPEntityDescriptor[] components;
    private RelationDescriptor[] relations;
    private Class[] persistentClasses;
    private Persistent[] staticPersistentInstances;
    private Hashtable txContexts = new Hashtable();
    private Hashtable transactionalTxContexts = new Hashtable();
    public ClassLoader cLoader;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$pm$PersistenceManager;

    public PersistenceManager(Environment environment, AbstractSchema asd, ClassLoader cLoader, String applicationName) throws EJBException {
        this.env = environment;
        this.appName = applicationName;
        this.schemaId = new AbstractSchemaID(this.appName, asd.getIndex());
        this.applicationIsStopped = false;
        this.initLocking(asd.getLockingType());
        this.dbProperties = asd.getDBProperties();
        this.components = asd.getDescriptors();
        this.relations = asd.getM2MRelationDescriptors();
        this.cLoader = cLoader;
        this.initStaticPersistentInstances(cLoader);
        this.optimistic = asd.getLockStrategy() == 0;
        this.threadSystem = this.env.getThreadSystem();
        this.transactionManager = this.env.getTransactionManager();
    }

    private void initStaticPersistentInstances(ClassLoader cLoader) {
        this.staticPersistentInstances = new Persistent[this.components.length];
        this.persistentClasses = new Class[this.components.length];
        int i = 0;
        while (i < this.staticPersistentInstances.length) {
            try {
                this.persistentClasses[i] = cLoader.loadClass(this.components[i].getPersistentClassName());
            }
            catch (ClassNotFoundException cnfe) {
                throw new BaseEJBException("ejb_0998", new Object[]{this.components[i].getPersistentClassName()}, cnfe);
            }
            try {
                Method initPersistent = this.persistentClasses[i].getMethod("initPersistent", this.getClass());
                initPersistent.invoke(null, this);
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) == null) {
                    t = e;
                }
                throw new BaseEJBException("ejb_0997", new Object[]{"initPersistent()"}, t);
            }
            try {
                Class[] booleanArg = new Class[]{Boolean.TYPE};
                Object[] booleanPar = new Object[]{Boolean.TRUE};
                Constructor constr = this.persistentClasses[i].getConstructor(booleanArg);
                this.staticPersistentInstances[i] = (Persistent)constr.newInstance(booleanPar);
            }
            catch (InstantiationException ie) {
                throw new BaseEJBException("ejb_0072", new Object[]{this.persistentClasses[i].getName()}, ie);
            }
            catch (IllegalAccessException ia) {
                throw new BaseEJBException("ejb_0073", new Object[]{this.persistentClasses[i].getName()}, ia);
            }
            catch (Exception e) {
                throw new BaseEJBException("ejb_0074", new Object[]{this.persistentClasses[i].getName()}, e);
            }
            ++i;
        }
    }

    public Class getPersistentClass(int ptypeId) {
        return this.persistentClasses[ptypeId];
    }

    public Persistent getStaticInstance(int ptypeId) {
        return this.staticPersistentInstances[ptypeId];
    }

    private void initLocking(int lockType) {
        switch (lockType) {
            case 1: {
                this.lockSystem = new TableLockingSystem(this.env.getTableLocking());
                break;
            }
            case 0: {
                this.lockSystem = this.env.getLockSystem();
                break;
            }
            case 2: {
                this.lockSystem = this.env.getLocalLockingSystem();
                this.localLocking = true;
                break;
            }
            default: {
                throw new BaseIllegalArgumentException("ejb_2186");
            }
        }
        this.dbLockSystem = new DbLockSystemImpl();
    }

    boolean useDistributedLocking() {
        return !this.localLocking;
    }

    /*
     * Loose catch block
     */
    public void initDataSource(boolean useSelectForUpdate) throws EJBDeploymentException {
        block15: {
            String method = "initDataSource(boolean useSelectForUpdate)";
            String dsName = null;
            try {
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ((Hashtable)p).put("domain", "true");
                InitialContext naming = new InitialContext(p);
                dsName = this.dbProperties.getDataSourceName();
                this.ds = (DataSource)naming.lookup(TX_DS_NAME_PREFIX + this.appName + "/" + dsName);
                this.localds = (DataSource)naming.lookup(NO_TX_DS_NAME_PREFIX + this.appName + "/" + dsName);
                if (!useSelectForUpdate) break block15;
                Connection conn = null;
                conn = this.getConnection();
                if (conn.getClass().getName().equals("com.sap.engine.services.dbpool.cci.CommonConnectionHandle")) {
                    throw new EJBDeploymentException("ejb_2013", new Object[]{dsName});
                }
                Object var9_8 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block15;
                }
                catch (SQLException sql) {
                    String message = "ejb_2015";
                    try {
                        message = new LocalizableTextFormatter(EJBResourceAccessor.getResourceAccessor(), message, new Object[]{"Connection.close()"}).format();
                    }
                    catch (LocalizationException e) {
                        // empty catch block
                    }
                    LOCATION.traceThrowableT(500, "initDataSource(boolean useSelectForUpdate)", message, (Throwable)sql);
                }
                break block15;
                {
                    catch (SQLException sql) {
                        throw new EJBDeploymentException("ejb_2014", new Object[]{dsName}, sql);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException sql) {
                        String message = "ejb_2015";
                        try {
                            message = new LocalizableTextFormatter(EJBResourceAccessor.getResourceAccessor(), message, new Object[]{"Connection.close()"}).format();
                        }
                        catch (LocalizationException e) {
                            // empty catch block
                        }
                        LOCATION.traceThrowableT(500, "initDataSource(boolean useSelectForUpdate)", message, (Throwable)sql);
                    }
                    throw throwable;
                }
            }
            catch (NamingException ne) {
                throw new EJBDeploymentException("ejb_0994", new Object[]{dsName}, ne);
            }
        }
    }

    public int getIsolationLevel() {
        return this.env.getExecutionContext().getIsolationLevel();
    }

    public void startThread(Runnable work) {
        this.threadSystem.startThread(work, true);
    }

    public PersistentCache getPersistentCache(int pTypeId) {
        return this.getTransactionContext().getPersistentCache(pTypeId);
    }

    public CMPEntityDescriptor getCMPDescriptor(int pTypeId) {
        return this.components[pTypeId];
    }

    public RelationDescriptor getRelDescriptor(int relId) {
        return this.relations[relId];
    }

    public int getAbstractSchemaIndex() {
        return this.schemaId.getIndex();
    }

    public PersistentCacheM2M getRelationCache(int relId) {
        return this.getTransactionContext().getRelationCache(relId);
    }

    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    public Connection getLocalConnection() throws SQLException {
        return this.localds.getConnection();
    }

    public LockSystem getLockSystem() {
        return this.lockSystem;
    }

    public LockSystem getDbLockSystem() {
        return this.dbLockSystem;
    }

    private Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException s) {
            throw new BaseEJBException("ejb_0076", s);
        }
    }

    public TransactionContext getTransactionContext() {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            Thread currentThread = Thread.currentThread();
            TransactionContext txCtx = (TransactionContext)this.txContexts.get(currentThread);
            if (txCtx == null) {
                txCtx = new TransactionContext(currentThread, this, false, this.components.length, this.relations.length);
                this.txContexts.put(currentThread, txCtx);
            }
            return txCtx;
        }
        TransactionContext txCtx = (TransactionContext)this.transactionalTxContexts.get(transaction);
        if (txCtx == null) {
            txCtx = new TransactionContext(transaction, this, true, this.components.length, this.relations.length);
            this.transactionalTxContexts.put(transaction, txCtx);
            SynchronizationList list = this.env.getSynchronizationList(transaction);
            list.addPMListener(txCtx);
        }
        return txCtx;
    }

    public void removeTransactionContext(Object transaction) {
        this.transactionalTxContexts.remove(transaction);
    }

    public Connection getConnectionForFindMethod() throws SQLException {
        String methodSign = "getConnectionForFindMethod()";
        LOCATION.entering("getConnectionForFindMethod()");
        Connection result = null;
        try {
            Transaction transaction = this.getTransaction();
            result = null;
            if (transaction == null) {
                result = this.getConnection();
            } else {
                SynchronizationList list = this.env.getSynchronizationList(transaction);
                list.beforeFindMethod();
                TransactionContext txCtx = (TransactionContext)this.transactionalTxContexts.get(transaction);
                if (txCtx == null) {
                    txCtx = new TransactionContext(transaction, this, true, this.components.length, this.relations.length);
                    this.transactionalTxContexts.put(transaction, txCtx);
                    list.addPMListener(txCtx);
                }
                result = txCtx.getConnection();
                txCtx.flushAllBeforeFindMethod();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            LOCATION.exiting(result);
            throw throwable;
        }
        LOCATION.exiting((Object)result);
        return result;
    }

    public void releaseConnectionForFindMethod(Connection con, int status) throws SQLException {
        String methodSign = "releaseConnectionForFindMethod(Connection con, int status)";
        if (LOCATION.bePath()) {
            LOCATION.entering("releaseConnectionForFindMethod(Connection con, int status)", new Object[]{con, new Integer(status)});
        }
        try {
            Transaction transaction = this.getTransaction();
            if (transaction == null) {
                if (con != null) {
                    con.close();
                }
            } else {
                TransactionContext txCtx = (TransactionContext)this.transactionalTxContexts.get(transaction);
                txCtx.releaseConnection(status);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void applicationIsStopped() {
        this.applicationIsStopped = true;
    }

    public ConfigurationHandler getConfigurationHandler() throws ConfigurationException {
        if (this.applicationIsStopped) {
            throw new BaseEJBException("ejb_0075", new Object[]{this.appName});
        }
        if (this.handler == null) {
            this.handler = this.env.getConfigurationFactory().getConfigurationHandler();
        }
        return this.handler;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public void logInfo(Throwable t) {
        LOCATION.traceThrowableT(300, null, t);
    }

    public void logError(Throwable t) {
        LOCATION.traceThrowableT(500, null, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

