/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.finder;

import com.sap.engine.services.ejb.entity.finder.FindPKCollection;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchElementException;
import com.sap.tc.logging.Location;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class LazyIterator
implements Iterator {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$finder$LazyIterator == null ? (class$com$sap$engine$services$ejb$entity$finder$LazyIterator = LazyIterator.class$("com.sap.engine.services.ejb.entity.finder.LazyIterator")) : class$com$sap$engine$services$ejb$entity$finder$LazyIterator));
    FindPKCollection mCollection;
    ResultSet mResultSet;
    private Object mCurrentObject;
    private Object mNextObject;
    private boolean mIsForced;
    private boolean mHasInstancesInCollectionArray;
    private boolean mHasNext;
    private boolean mMustFetchRS;
    private boolean mRemoveAllowed;
    private int mIndex;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$finder$LazyIterator;

    public LazyIterator(FindPKCollection aCollection) {
        this.mCollection = aCollection;
        this.mResultSet = this.mCollection.mRS;
        this.mNextObject = null;
        this.mCurrentObject = null;
        this.mIsForced = false;
        this.mHasInstancesInCollectionArray = true;
        this.mHasNext = false;
        this.mMustFetchRS = true;
        this.mRemoveAllowed = false;
        this.mIndex = 0;
    }

    public boolean hasNext() {
        if (this.mIsForced) {
            return this.mCollection.size() > this.mIndex;
        }
        if (this.mCollection.mCollectionIsLoaded) {
            return this.mIndex < this.mCollection.mCurrentSize;
        }
        if (this.mHasInstancesInCollectionArray) {
            if (this.mIndex < this.mCollection.mCurrentSize) {
                return true;
            }
            this.mHasInstancesInCollectionArray = false;
        }
        try {
            if (this.mMustFetchRS) {
                this.fetchRSToNextRow();
                this.mMustFetchRS = false;
            }
        }
        catch (SQLException sqle) {
            BaseEJBException toThrow = new BaseEJBException("ejb_0106", sqle);
            toThrow.trace(LOCATION);
            this.closeResources();
            throw toThrow;
        }
        return this.mHasNext;
    }

    public Object next() {
        if (this.mIsForced) {
            this.mCurrentObject = this.mCollection.getElement(this.mIndex++);
            this.mRemoveAllowed = true;
            return this.mCurrentObject;
        }
        if (this.mCollection.mCollectionIsLoaded) {
            this.mRemoveAllowed = true;
            return this.mCollection.getElement(this.mIndex++);
        }
        Object result = null;
        Object current = null;
        if (this.mHasInstancesInCollectionArray) {
            if (this.mIndex < this.mCollection.mCurrentSize) {
                current = this.mCollection.getElement(this.mIndex++);
            } else {
                this.mHasInstancesInCollectionArray = false;
            }
        }
        if (!this.mHasInstancesInCollectionArray) {
            try {
                if (this.mMustFetchRS) {
                    this.fetchRSToNextRow();
                    if (!this.mHasNext) {
                        throw new BaseNoSuchElementException("ejb_0105");
                    }
                }
                current = this.mNextObject;
                this.mMustFetchRS = true;
                this.mNextObject = null;
            }
            catch (SQLException sqle) {
                BaseEJBException toThrow = new BaseEJBException("ejb_0106", sqle);
                toThrow.trace(LOCATION);
                this.closeResources();
                throw toThrow;
            }
        }
        result = current;
        this.mCurrentObject = current;
        this.mRemoveAllowed = true;
        return result;
    }

    public void remove() {
        if (!this.mRemoveAllowed) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0123");
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        this.mCollection.removeElement(this.mIndex);
        this.mRemoveAllowed = false;
    }

    void forceLoadingAndCloseResources() {
        try {
            try {
                if (!this.mHasInstancesInCollectionArray) {
                    this.mIndex = this.mMustFetchRS ? this.mCollection.mCurrentSize : this.mCollection.mCurrentSize - 1;
                }
                this.mCollection.onlyLoadAllElementsFromRS(this.mMustFetchRS);
                this.mIsForced = true;
            }
            catch (SQLException sqle) {
                BaseEJBException toThrow = new BaseEJBException("ejb_0106", sqle);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            Object var4_1 = null;
            this.closeResources();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.closeResources();
            throw throwable;
        }
    }

    private void fetchRSToNextRow() throws SQLException {
        this.mHasNext = false;
        if (this.mResultSet.next()) {
            Object obj;
            this.mNextObject = obj = this.mCollection.extractAndAddSinglePK();
            this.mHasNext = true;
        }
        if (!this.mHasNext) {
            this.mCollection.mCollectionIsLoaded = true;
        }
    }

    private void closeResources() {
        this.mCollection.closeResources();
        this.mResultSet = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

