/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.finder;

import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.services.ejb.entity.finder.LazyIterator;
import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.TransactionListener;
import com.sap.engine.services.ejb.entity.pm.UpdatablePersistent;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchElementException;
import com.sap.tc.logging.Location;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class FindPKCollection
extends LinearItemAdapter
implements Collection,
TransactionListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$finder$FindPKCollection == null ? (class$com$sap$engine$services$ejb$entity$finder$FindPKCollection = FindPKCollection.class$("com.sap.engine.services.ejb.entity.finder.FindPKCollection")) : class$com$sap$engine$services$ejb$entity$finder$FindPKCollection));
    private static final int INITIAL_CAPACITY = 32;
    private Object[] mElements;
    volatile int mCurrentSize;
    private int mCapacityIncrement;
    volatile ResultSet mRS;
    private PreparedStatement mPST;
    private Persistent mPersistent;
    private PersistentCache mPCache;
    private TransactionContext mTC;
    private boolean mToLoad;
    private boolean mToLock;
    volatile boolean mCollectionIsLoaded;
    private LazyIterator mLazyIterator;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$finder$FindPKCollection;

    public FindPKCollection(ResultSet aRS, Persistent aPersistent) throws SQLException {
        this.init(aRS, null, aPersistent, null, null, false, false);
        this.forceLoadingOfAllElementsFromRS();
    }

    public FindPKCollection(ResultSet aRS, Persistent aPersistent, PersistentCache aPCache) throws SQLException {
        this.init(aRS, null, aPersistent, aPCache, null, true, false);
        this.forceLoadingOfAllElementsFromRS();
    }

    public FindPKCollection(ResultSet aRS, Persistent aPersistent, PersistentCache aPCache, TransactionContext aTC, boolean aToLock) throws SQLException {
        this.init(aRS, null, aPersistent, aPCache, aTC, true, aToLock);
        this.forceLoadingOfAllElementsFromRS();
    }

    public FindPKCollection(ResultSet aRS, PreparedStatement aPS, Persistent aPersistent, PersistentCache aPCache, TransactionContext aTC, boolean aToLoad, boolean aToLock, boolean aToLoadLazy) throws SQLException {
        this.init(aRS, aPS, aPersistent, aPCache, aTC, aToLoad, aToLock);
        if (!aToLoadLazy) {
            this.forceLoadingOfAllElementsFromRS();
        } else {
            aTC.addPMListener(this, false);
        }
    }

    private void init(ResultSet aRS, PreparedStatement aPS, Persistent aPersistent, PersistentCache aPCache, TransactionContext aTC, boolean aToLoad, boolean aToLock) {
        this.mCurrentSize = 0;
        this.mElements = new Object[32];
        this.mCapacityIncrement = 0;
        this.mRS = aRS;
        this.mPST = aPS;
        this.mPersistent = aPersistent;
        this.mPCache = aPCache;
        this.mTC = aTC;
        this.mToLoad = aToLoad;
        this.mToLock = aToLock;
        this.mCollectionIsLoaded = false;
        this.mLazyIterator = null;
    }

    void forceLoadingOfAllElementsFromRS() throws SQLException {
        if (!this.mCollectionIsLoaded) {
            if (this.mLazyIterator == null) {
                this.onlyLoadAllElementsFromRS(true);
                this.closeResources();
            } else {
                this.mLazyIterator.forceLoadingAndCloseResources();
                this.mLazyIterator = null;
            }
            this.mCollectionIsLoaded = true;
            this.mRS = null;
            this.mPST = null;
        }
    }

    void onlyLoadAllElementsFromRS(boolean aMustInvokeNextOnRS) throws SQLException {
        if (!aMustInvokeNextOnRS && !this.mRS.isAfterLast()) {
            this.extractAndAddSinglePK();
        }
        while (this.mRS.next()) {
            this.extractAndAddSinglePK();
        }
    }

    private Object extractSinglePK() throws SQLException {
        Object pk = this.mPersistent.extractPrimaryKey(this.mRS);
        if (this.mToLoad) {
            Persistent up = this.mPCache.getLoadedPersistent(pk, this.mRS, false, this.mToLock);
            if (this.mToLock) {
                ((UpdatablePersistent)up).setWriteLock(this.mTC, this.mToLock);
            }
        }
        return pk;
    }

    Object extractAndAddSinglePK() throws SQLException {
        Object pk = this.extractSinglePK();
        this.addElement(pk);
        return pk;
    }

    private synchronized void addElement(Object mObj) {
        if (this.mCurrentSize == this.mElements.length) {
            this.resize();
        }
        this.mElements[this.mCurrentSize++] = mObj;
    }

    private void resize() {
        int newSize = this.mCapacityIncrement > 0 ? this.mCurrentSize + this.mCapacityIncrement : this.mCurrentSize * 2;
        Object[] newArr = new Object[newSize];
        System.arraycopy(this.mElements, 0, newArr, 0, this.mElements.length);
        this.mElements = newArr;
    }

    private int containsElement(Object aObj) {
        int result = -1;
        int i = 0;
        while (i < this.mCurrentSize) {
            if (aObj == null && this.mElements[i] == null) {
                result = i;
                break;
            }
            if (aObj != null && aObj.equals(this.mElements[i])) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean removeElement(Object aObj) {
        boolean result = false;
        int elementIndex = this.containsElement(aObj);
        if (elementIndex != -1) {
            this.mElements[elementIndex] = this.mElements[this.mCurrentSize - 1];
            this.mElements[this.mCurrentSize--] = null;
            result = true;
        }
        return result;
    }

    synchronized boolean removeElement(int aIndex) {
        boolean result = false;
        if (aIndex > 0 && aIndex < this.mCurrentSize) {
            this.mElements[aIndex] = this.mElements[this.mCurrentSize - 1];
            this.mElements[this.mCurrentSize--] = null;
            result = true;
        }
        return result;
    }

    synchronized Object getElement(int aIndex) {
        Object result = null;
        if (aIndex >= this.mCurrentSize) {
            throw new BaseNoSuchElementException("ejb_0105");
        }
        result = this.mElements[aIndex];
        return result;
    }

    public synchronized int size() {
        try {
            this.forceLoadingOfAllElementsFromRS();
        }
        catch (SQLException e) {
            LOCATION.traceThrowableT(500, null, (Throwable)e);
        }
        return this.mCurrentSize;
    }

    public synchronized boolean isEmpty() {
        boolean hasElement = false;
        if (this.mCurrentSize == 0) {
            if (!this.mCollectionIsLoaded && this.mRS != null) {
                try {
                    hasElement = !this.mRS.isAfterLast();
                }
                catch (SQLException e) {
                    LOCATION.traceThrowableT(500, null, (Throwable)e);
                }
            }
        } else {
            hasElement = true;
        }
        return !hasElement;
    }

    public synchronized boolean contains(Object o) {
        Object obj;
        boolean isContains;
        if (this.mLazyIterator != null) {
            try {
                this.forceLoadingOfAllElementsFromRS();
            }
            catch (SQLException e) {
                LOCATION.traceThrowableT(500, null, (Throwable)e);
            }
        }
        boolean bl = isContains = this.containsElement(o) != -1;
        if (!isContains && !this.mCollectionIsLoaded && o != null && (obj = this.containsInRS(o)) != null) {
            this.addElement(obj);
            isContains = true;
        }
        return isContains;
    }

    private Object containsInRS(Object o) {
        Object result = null;
        try {
            this.mCollectionIsLoaded = true;
            while (this.mRS.next()) {
                Object obj = this.extractSinglePK();
                if (obj.equals(o)) {
                    result = obj;
                    if (!this.mRS.isAfterLast()) {
                        this.mCollectionIsLoaded = false;
                    }
                    break;
                }
                this.addElement(obj);
            }
        }
        catch (SQLException e) {
            LOCATION.traceThrowableT(500, null, (Throwable)e);
        }
        return result;
    }

    public synchronized Iterator iterator() {
        LazyIterator resultIterator = new LazyIterator(this);
        if (!this.mCollectionIsLoaded) {
            if (this.mLazyIterator == null) {
                this.mLazyIterator = resultIterator;
            } else {
                this.mLazyIterator.forceLoadingAndCloseResources();
                this.mLazyIterator = null;
                this.mCollectionIsLoaded = true;
            }
        }
        return resultIterator;
    }

    public synchronized Object[] toArray() {
        try {
            this.forceLoadingOfAllElementsFromRS();
        }
        catch (SQLException e) {
            LOCATION.traceThrowableT(500, null, (Throwable)e);
        }
        Object[] result = new Object[this.mCurrentSize];
        System.arraycopy(this.mElements, 0, result, 0, this.mCurrentSize);
        return result;
    }

    public synchronized Object[] toArray(Object[] a) {
        try {
            this.forceLoadingOfAllElementsFromRS();
        }
        catch (SQLException e) {
            LOCATION.traceThrowableT(500, null, (Throwable)e);
        }
        if (a.length < this.mCurrentSize) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.mCurrentSize);
        }
        System.arraycopy(this.mElements, 0, a, 0, this.mCurrentSize);
        if (a.length > this.mCurrentSize) {
            a[this.mCurrentSize] = null;
        }
        return a;
    }

    public synchronized boolean add(Object o) {
        if (this.mLazyIterator != null) {
            try {
                this.forceLoadingOfAllElementsFromRS();
            }
            catch (SQLException e) {
                LOCATION.traceThrowableT(500, null, (Throwable)e);
            }
        }
        this.addElement(o);
        return true;
    }

    public synchronized boolean remove(Object o) {
        Object obj;
        boolean removed;
        if (this.mLazyIterator != null) {
            try {
                this.forceLoadingOfAllElementsFromRS();
            }
            catch (SQLException e) {
                LOCATION.traceThrowableT(500, null, (Throwable)e);
            }
        }
        if (!(removed = this.removeElement(o)) && !this.mCollectionIsLoaded && o != null && (obj = this.containsInRS(o)) != null) {
            removed = true;
        }
        return removed;
    }

    public synchronized boolean containsAll(Collection c) {
        boolean isContains = true;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            isContains = false;
            break;
        }
        return isContains;
    }

    public synchronized boolean addAll(Collection c) {
        if (this.mLazyIterator != null) {
            try {
                this.forceLoadingOfAllElementsFromRS();
            }
            catch (SQLException e) {
                LOCATION.traceThrowableT(500, null, (Throwable)e);
            }
        }
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.mCurrentSize + numNew);
        System.arraycopy(a, 0, this.mElements, this.mCurrentSize, numNew);
        this.mCurrentSize += numNew;
        return numNew != 0;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.mElements.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            Object[] oldData = this.mElements;
            int n = newCapacity = this.mCapacityIncrement > 0 ? oldCapacity + this.mCapacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.mElements = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.mElements, 0, this.mCurrentSize);
        }
    }

    public synchronized boolean removeAll(Collection c) {
        boolean removed = false;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            boolean bl = removed = removed || this.remove(e.next());
        }
        return removed;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean removed = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            removed = true;
        }
        return removed;
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this.mCurrentSize) {
            this.mElements[i] = null;
            ++i;
        }
        this.mCurrentSize = 0;
        this.closeResources();
        this.mRS = null;
        this.mPST = null;
        this.mPersistent = null;
        this.mPCache = null;
        this.mTC = null;
    }

    public Enumeration elements() {
        return new Enumeration(){
            Iterator itrator;
            {
                this.itrator = FindPKCollection.this.iterator();
            }

            public boolean hasMoreElements() {
                return this.itrator.hasNext();
            }

            public Object nextElement() {
                FindPKCollection findPKCollection = FindPKCollection.this;
                synchronized (findPKCollection) {
                    Object e = this.itrator.next();
                    return e;
                }
            }
        };
    }

    void closeResources() {
        String method = "closeResources()";
        try {
            if (this.mRS != null) {
                this.mRS.close();
            }
        }
        catch (SQLException sqle) {
            LOCATION.traceThrowableT(100, "closeResources()", (String)null, (Throwable)sqle);
        }
        try {
            if (this.mPST != null) {
                this.mPST.close();
            }
        }
        catch (SQLException sqle) {
            LOCATION.traceThrowableT(100, "closeResources()", (String)null, (Throwable)sqle);
        }
    }

    public void ejbFlush(Connection c) {
        this.closeResources();
    }

    public void ejbFinish(TransactionContext locker, boolean committed) {
        this.closeResources();
    }

    public void ejbEndFlushFinderMethod() {
    }

    public Object clone() {
        throw new BaseEJBException("", new CloneNotSupportedException());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

