/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity;

import com.sap.engine.interfaces.transaction.SynchronizationExtension;
import com.sap.engine.lib.util.base.BaseDoublyLinkedList;
import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.entity.Container;
import com.sap.engine.services.ejb.entity.Context;
import com.sap.engine.services.ejb.entity.pm.PMTransactionListener;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class SynchronizationList
extends BaseDoublyLinkedList
implements SynchronizationExtension {
    private Environment env;
    private Transaction t;
    private BaseDoublyLinkedList pmListeners;

    public SynchronizationList(Transaction t, Environment env) {
        this.t = t;
        this.env = env;
        this.pmListeners = new BaseDoublyLinkedList();
    }

    public void addPMListener(PMTransactionListener pmListener) {
        this.pmListeners.addLastItem(pmListener);
    }

    public void beforeFindMethod() {
        this.storeAllContexts(false);
    }

    private void storeAllContexts(boolean toPassivate) {
        Context ctx = (Context)((Object)this.getFirstItem());
        while (ctx != null) {
            try {
                if (toPassivate) {
                    ctx.store0();
                } else {
                    ctx.store();
                }
            }
            catch (Exception tr) {
                try {
                    this.t.setRollbackOnly();
                    return;
                }
                catch (SystemException se) {
                    throw new BaseIllegalStateException("ejb_0996", new Object[]{"storeAllContexts(boolean)"}, se);
                }
            }
            ctx = (Context)((Object)((LinearItemAdapter)((Object)ctx)).getNext());
        }
    }

    private void passivateAllContexts() {
        Context ctx = (Context)((Object)this.getFirstItem());
        while (ctx != null) {
            ctx.passivate0();
            ctx = (Context)((Object)((LinearItemAdapter)((Object)ctx)).getNext());
        }
    }

    private void unregisterAllContexts() {
        Context c = null;
        while ((c = (Context)((Object)this.removeFirstItem())) != null) {
            Container container = c.getContainer();
            container.unregister(c, null);
        }
    }

    public void beforeRollback() {
        Context ctx = (Context)((Object)this.getFirstItem());
        while (ctx != null) {
            ctx.passivateError();
            ctx = (Context)((Object)((LinearItemAdapter)((Object)ctx)).getNext());
        }
        PMTransactionListener pmItem = (PMTransactionListener)this.pmListeners.getFirstItem();
        while (pmItem != null) {
            pmItem.beforeRollback();
            pmItem = (PMTransactionListener)pmItem.getNext();
        }
    }

    public void beforeCompletion() {
        this.storeAllContexts(true);
        PMTransactionListener pmItem = (PMTransactionListener)this.pmListeners.getFirstItem();
        while (pmItem != null) {
            pmItem.beforeCompletion();
            pmItem = (PMTransactionListener)pmItem.getNext();
        }
    }

    public void afterCompletion(int state) {
        this.passivateAllContexts();
        PMTransactionListener pmItem = (PMTransactionListener)this.pmListeners.getFirstItem();
        while (pmItem != null) {
            pmItem.afterCompletion(state);
            pmItem = (PMTransactionListener)pmItem.getNext();
        }
        this.env.getSynchronizationTable().remove(this.t);
        this.unregisterAllContexts();
    }
}

