/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity;

import com.sap.engine.interfaces.ejb.component.EJBComponent;
import com.sap.engine.interfaces.ejb.serialization.EJBSerializable;
import com.sap.engine.services.ejb.entity.Container;
import com.sap.engine.services.ejb.entity.Context;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.engine.services.ejb.handle.HandleImpl;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.rmi.PortableRemoteObject;

public abstract class EntityObject
extends PortableRemoteObject
implements EJBSerializable,
EJBComponent,
EntityExceptionConstants {
    protected Object pk;
    protected Container container;

    public EntityObject(Container container, Object key) throws RemoteException {
        this.pk = key;
        this.container = container;
    }

    public Object getPrimaryKey() throws RemoteException {
        return this.pk;
    }

    public Handle getHandle() throws RemoteException {
        return new HandleImpl((EJBObject)this);
    }

    public boolean isIdentical(EJBObject obj) throws RemoteException {
        String myHomeName;
        String objHomeName = obj.getEJBHome().getEJBMetaData().getHomeInterfaceClass().getName();
        if (!objHomeName.equals(myHomeName = this.container.getEJBHome().getEJBMetaData().getHomeInterfaceClass().getName())) {
            return false;
        }
        return obj.getPrimaryKey().equals(this.pk);
    }

    public EJBHome getEJBHome() throws RemoteException {
        return (EJBHome)this.container.remoteHome;
    }

    protected void setEJBObjectTo(Context ctx) {
        ctx.setEJBObject((EJBObject)this);
    }

    protected void unexportEntity() {
        try {
            PortableRemoteObject.unexportObject((Remote)((EJBObject)this));
        }
        catch (NoSuchObjectException nsoe) {
            this.container.logInfo(nsoe);
        }
    }

    public String ejbGetID() {
        String jndiName = this.container.descriptor.getJndiName();
        return "&ENTITY&" + jndiName + "*";
    }

    public Object getResourceSet() {
        return this.container.getNoConnectionResourceSet();
    }
}

