/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity;

import com.sap.engine.interfaces.ejb.component.EJBComponent;
import com.sap.engine.interfaces.ejb.serialization.EJBSerializable;
import com.sap.engine.services.ejb.entity.Container;
import com.sap.engine.services.ejb.entity.Context;
import com.sap.engine.services.ejb.entity.EntityMetaData;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.engine.services.ejb.handle.HomeHandleImpl;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;

public abstract class EntityHome
extends PortableRemoteObject
implements EJBSerializable,
EJBComponent,
EntityExceptionConstants {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$EntityHome == null ? (class$com$sap$engine$services$ejb$entity$EntityHome = EntityHome.class$("com.sap.engine.services.ejb.entity.EntityHome")) : class$com$sap$engine$services$ejb$entity$EntityHome));
    protected Container container;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$EntityHome;

    public EntityHome(Container container) throws RemoteException {
        this.container = container;
    }

    public HomeHandle getHomeHandle() throws RemoteException {
        return new HomeHandleImpl((EJBHome)this);
    }

    public EJBMetaData getEJBMetaData() throws RemoteException {
        String homeClassName = null;
        Class<?> homeClass = null;
        try {
            homeClassName = this.container.descriptor.getRemoteHomeInterface();
            homeClass = this.container.loader.loadClass(homeClassName);
        }
        catch (ClassNotFoundException cnfe) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_0018", new Object[]{homeClassName}, cnfe);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        Class<?> remoteClass = null;
        Class<?> pkClass = null;
        Method[] allMethods = homeClass.getMethods();
        int i = 0;
        while (i < allMethods.length) {
            if (allMethods[i].getName().equals("findByPrimaryKey") && allMethods[i].getParameterTypes().length == 1) {
                remoteClass = allMethods[i].getReturnType();
                pkClass = allMethods[i].getParameterTypes()[0];
                break;
            }
            ++i;
        }
        if (remoteClass == null || pkClass == null) {
            BaseRemoteException toThrow = new BaseRemoteException("ejb_0043", new Object[]{this.container.getDescriptor().getEjbName()});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return new EntityMetaData(this.getP4Stub(homeClass), homeClass, remoteClass, pkClass);
    }

    protected void setEJBObjectToContext(EJBObject ejbObject, Context ctx) {
        ctx.setEJBObject(ejbObject);
    }

    protected void unexportEntityHome() {
        try {
            PortableRemoteObject.unexportObject((Remote)((EJBHome)this));
        }
        catch (NoSuchObjectException nsoe) {
            this.container.logInfo(nsoe);
        }
    }

    protected EJBHome getP4Stub(Class homeClass) {
        P4ObjectBroker broker = P4ObjectBroker.init();
        if (broker == null) {
            BaseEJBException toThrow = new BaseEJBException("ejb_0044");
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        try {
            return (EJBHome)broker.narrow(broker.byteArrayToObject(broker.objectToByteArr(broker.loadObject((Remote)((Object)this)))), homeClass);
        }
        catch (ClassNotFoundException cnfex) {
            BaseEJBException toThrow = new BaseEJBException("ejb_0045", cnfex);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public String ejbGetID() {
        String jndiName = this.container.getDescriptor().getJndiName();
        return jndiName + "*" + "*ENTITY_HOME";
    }

    public abstract EJBObject createEJBObject(Object var1) throws RemoteException;

    public Object getResourceSet() {
        return this.container.getNoConnectionResourceSet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

