/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.lib.security.SecurityContext;
import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.entity.Container;
import com.sap.engine.services.ejb.entity.ContainerException;
import com.sap.engine.services.ejb.entity.ContextStatus;
import com.sap.engine.services.ejb.entity.EntityObject;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchObjectException;
import com.sap.engine.services.ejb.exceptions.BaseUnsupportedOperationException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.engine.services.ejb.util.EJBHashtableItem;
import com.sap.engine.services.ejb.util.ObjectToStringHashing;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.security.Identity;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public class Context
extends EJBHashtableItem
implements ContextStatus,
EntityContext,
EntityExceptionConstants {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$Context == null ? (class$com$sap$engine$services$ejb$entity$Context = Context.class$("com.sap.engine.services.ejb.entity.Context")) : class$com$sap$engine$services$ejb$entity$Context));
    protected static final String EJB_STORE = "ejbStore()";
    protected Container container = null;
    private EJBHashtableItem next_ctx = null;
    private EJBHashtableItem prev_ctx = null;
    protected Object key = null;
    protected EntityBean bean = null;
    private EJBObject ejbObject = null;
    private EJBLocalObject ejbLocalObject = null;
    private Principal runAsPrincipal = null;
    protected int entrance = 0;
    protected Object transaction = null;
    protected boolean global = false;
    private ResourceSet resources = null;
    public byte status = 0;
    private int hashCode = 0;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$Context;

    public Context(Container container, EntityBean instance) {
        this.container = container;
        this.bean = instance;
        String appName = container.getApplicationName();
        String compName = "ejbContexts/" + appName + "/" + container.getDescriptor().getJndiName();
        int isolationLevel = container.getDescriptor().getIsolationLevel();
        this.resources = isolationLevel == -1 ? new ResourceSetImpl(appName, compName, 4) : new ResourceSetImpl(appName, compName, isolationLevel);
        this.status = (byte)4;
    }

    public Container getContainer() {
        return this.container;
    }

    protected void identify(Object pk, Object transaction, boolean global) {
        this.key = pk;
        this.hashCode = this.key.hashCode();
        this.transaction = transaction;
        this.global = global;
    }

    protected void setEJBObject(EJBObject ejbObject) {
        this.ejbObject = ejbObject;
    }

    protected void setEJBLocalObject(EJBLocalObject ejbLocalObject) {
        this.ejbLocalObject = ejbLocalObject;
    }

    public boolean isActive() {
        return this.status == 7;
    }

    public boolean isPassive() {
        return this.status == 5;
    }

    public boolean isRemoved() {
        return this.status == 9;
    }

    public boolean isDiscarded() {
        return this.status == -1;
    }

    public Object getKey() {
        return this.key;
    }

    public EntityBean getInstance() {
        return this.bean;
    }

    public ResourceSet getResourceSet() {
        return this.resources;
    }

    protected boolean inGlobalTransaction() {
        return this.global;
    }

    protected boolean isNestedEntrance() {
        return this.entrance > 1;
    }

    public void discard() {
        if (this.status != -1) {
            this.status = (byte)-1;
            this.container.pool.fail();
        }
    }

    public void setRunAsPrincipal(Principal p) {
        this.runAsPrincipal = p;
    }

    protected void cleanup() {
        ((LinearItemAdapter)((Object)this)).clearItem();
        this.next_ctx = null;
        this.prev_ctx = null;
        this.key = null;
        this.transaction = null;
        this.global = false;
        this.ejbObject = null;
        this.ejbLocalObject = null;
    }

    public void destroyEntity() {
        if (this.ejbObject != null) {
            ((EntityObject)this.ejbObject).unexportEntity();
        }
        this.ejbObject = null;
        this.ejbLocalObject = null;
    }

    public synchronized void lock() throws ContainerException {
        if (this.entrance > 0 && !this.container.isReentrant()) {
            throw new ContainerException("ejb_0034", new Object[]{this.container.getDescriptor().getEjbName()});
        }
        ++this.entrance;
    }

    public synchronized void unlock() {
        --this.entrance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unsetContext() {
        if (this.bean == null) return;
        ResourceSet rsOut = null;
        try {
            try {
                this.status = (byte)4;
                rsOut = ResourceSetContextObject.replaceCurrentResourceSet(this.container.getNoConnectionResourceSet());
                this.bean.unsetEntityContext();
            }
            catch (Exception e) {
                this.container.logInfo(e);
                Object var4_3 = null;
                ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
                this.bean = null;
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
            this.bean = null;
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
        this.bean = null;
    }

    protected void passivateError() throws ContainerException {
        try {
            this.resources.delistAll(0x20000000);
        }
        catch (SystemException se) {
            this.discard();
            ContainerException toThrow = new ContainerException("ejb_0036", se);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public void passivate() throws ContainerException {
        this.store0();
        this.passivate0();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void store0() throws ContainerException {
        try {
            this.store();
            Object var2_1 = null;
            if (!this.global) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!this.global) throw throwable;
            try {
                this.resources.delistAll(0x4000000);
                throw throwable;
            }
            catch (SystemException se) {
                this.discard();
                ContainerException toThrow = new ContainerException("ejb_0036", se);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        try {
            this.resources.delistAll(0x4000000);
            return;
        }
        catch (SystemException se) {
            this.discard();
            ContainerException toThrow = new ContainerException("ejb_0036", se);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    protected void store() throws ContainerException {
        if (this.container.isCMP() ? this.status != 7 && this.status != -1 : this.status != 7) {
            return;
        }
        ResourceSet rsOut = ResourceSetContextObject.replaceCurrentResourceSet(this.resources);
        String oldMethodName = this.resources.setMethodName(EJB_STORE);
        try {
            this.container.getMonitoringInfo().updateStores();
            this.bean.ejbStore();
        }
        catch (Exception e) {
            this.discard();
            ContainerException toThrow = new ContainerException("ejb_0035", new Object[]{EJB_STORE}, e);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        this.resources.setMethodName(oldMethodName);
        ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
    }

    protected void passivate0() throws ContainerException {
        if (this.status != 7) {
            return;
        }
        this.status = (byte)5;
        ResourceSet rsOut = null;
        try {
            try {
                rsOut = ResourceSetContextObject.replaceCurrentResourceSet(this.container.getNoConnectionResourceSet());
                this.container.getMonitoringInfo().updatePassivations();
                this.bean.ejbPassivate();
            }
            catch (Exception e) {
                this.discard();
                ContainerException toThrow = new ContainerException("ejb_0035", new Object[]{"ejbPassivate()"}, e);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
    }

    public void activate() throws ContainerException {
        if (this.status != 5) {
            return;
        }
        ResourceSet rsOut = null;
        try {
            try {
                rsOut = ResourceSetContextObject.replaceCurrentResourceSet(this.container.getNoConnectionResourceSet());
                this.container.getMonitoringInfo().updateActivations();
                this.bean.ejbActivate();
            }
            catch (Exception e) {
                this.discard();
                throw new ContainerException("ejb_0035", new Object[]{"ejbActivate()"}, e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
        if (this.global) {
            try {
                this.resources.enlistAll((Transaction)this.transaction);
            }
            catch (SystemException se) {
                this.discard();
                throw new ContainerException("ejb_0036", se);
            }
            catch (RollbackException re) {
                this.discard();
                throw new ContainerException("ejb_0037", re);
            }
        }
        this.status = (byte)7;
        try {
            this.container.getMonitoringInfo().updateLoads();
            this.bean.ejbLoad();
        }
        catch (NoSuchEntityException nsee) {
            this.discard();
            throw new ContainerException("ejb_0015", new BaseNoSuchObjectException("ejb_0016", new Object[]{ObjectToStringHashing.getCompoundHashNoError((Object)this.key)}, nsee));
        }
        catch (Exception e) {
            this.discard();
            throw new ContainerException("ejb_0035", new Object[]{"ejbLoad()"}, e);
        }
    }

    public void remove() throws RemoveException, RemoteException {
        if (this.status != 7) {
            return;
        }
        this.container.getMonitoringInfo().updateRemovals();
        this.bean.ejbRemove();
        this.status = (byte)9;
    }

    public void enlist(Transaction t) throws RollbackException, SystemException {
        this.resources.enlistAll(t);
    }

    public void delist(int flag) throws SystemException {
        this.resources.delistAll(flag);
    }

    public synchronized void setNextContext(EJBHashtableItem context) {
        this.next_ctx = context;
    }

    public synchronized EJBHashtableItem getNextContext() {
        return this.next_ctx;
    }

    public void setPrevContext(EJBHashtableItem context) {
        this.prev_ctx = context;
    }

    public EJBHashtableItem getPrevContext() {
        return this.prev_ctx;
    }

    public synchronized EJBObject getEJBObject() throws IllegalStateException {
        if ((this.status & 1) == 0 || !this.container.remoteView) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0038", new Object[]{"remote"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        if (this.ejbObject == null) {
            try {
                this.ejbObject = this.container.createEJBObject(this.key);
            }
            catch (RemoteException e) {
                BaseEJBException toThrow = new BaseEJBException("ejb_0039", new Object[]{ObjectToStringHashing.getCompoundHashNoError((Object)this.key)}, e);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        return this.ejbObject;
    }

    public synchronized EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        if ((this.status & 1) == 0 || !this.container.localView) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0038", new Object[]{"local"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        if (this.ejbLocalObject == null) {
            this.ejbLocalObject = this.container.createEJBLocalObject(this.key);
        }
        return this.ejbLocalObject;
    }

    public EJBLocalHome getEJBLocalHome() {
        if ((this.status & 4) == 0 || !this.container.localView) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"getEJBLocalHome()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return this.container.getEJBLocalHome();
    }

    public EJBHome getEJBHome() {
        if ((this.status & 4) == 0 || !this.container.remoteView) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"getEJBHome()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return this.container.getEJBHome();
    }

    public Properties getEnvironment() {
        BaseUnsupportedOperationException toThrow = new BaseUnsupportedOperationException("ejb_0041", new Object[]{"getEnvironment()", "Use the JNDI naming context java:comp/env to access enterprise bean's environment."});
        toThrow.trace(LOCATION);
        throw toThrow;
    }

    public Identity getCallerIdentity() {
        BaseUnsupportedOperationException toThrow = new BaseUnsupportedOperationException("ejb_0041", new Object[]{"getCallerIdentity()", "Use getCallerPrincipal() to obtain the caller principal."});
        toThrow.trace(LOCATION);
        throw toThrow;
    }

    public Principal getCallerPrincipal() {
        if ((this.status & 2) == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"getCallerPrincipal()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        if (this.runAsPrincipal != null) {
            return this.runAsPrincipal;
        }
        SecurityContext secCtx = this.container.getSecurityContext();
        return secCtx.getPrincipal();
    }

    public boolean isCallerInRole(Identity identity) {
        BaseUnsupportedOperationException toThrow = new BaseUnsupportedOperationException("ejb_0041", new Object[]{"isCallerInRole(java.security.Identity)", "Use isCallerInRole(java.lang.String) instead."});
        toThrow.trace(LOCATION);
        throw toThrow;
    }

    public boolean isCallerInRole(String roleReferenceName) {
        if ((this.status & 2) == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"isCallerInRole(java.lang.String)"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        Hashtable secRoleReferences = this.container.getDescriptor().getRoleReferences();
        SecurityRoleReference secRoleRef = (SecurityRoleReference)secRoleReferences.get(roleReferenceName);
        if (secRoleRef == null) {
            return false;
        }
        String roleName = secRoleRef.getSecurityRoleName();
        SecurityRole securityRole = this.container.getSecurityRoleContext().getSecurityRole(roleName);
        if (securityRole == null) {
            return false;
        }
        return securityRole.isCallerInRole();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0993", new Object[]{"getUserTransaction()"});
        toThrow.trace(LOCATION);
        throw toThrow;
    }

    public void setRollbackOnly() throws IllegalStateException {
        if ((this.status & 2) == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"setRollbackOnly()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        try {
            this.container.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException se) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0011", new Object[]{"com.sap.engine.services.ejb.entity.Context.setRollbackOnly()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if ((this.status & 2) == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"getRollbackOnly()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        try {
            int transactionStatus = this.container.getTransactionManager().getStatus();
            if (transactionStatus == 6) {
                BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0042");
                toThrow.trace(LOCATION);
                throw toThrow;
            }
            return transactionStatus == 1;
        }
        catch (SystemException se) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0011", new Object[]{"getRollbackOnly()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public Object getPrimaryKey() throws IllegalStateException {
        if ((this.status & 1) == 0) {
            BaseIllegalStateException toThrow = new BaseIllegalStateException("ejb_0040", new Object[]{"getPrimaryKey()"});
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return this.key;
    }

    public boolean equals(Object obj) {
        Context ctx;
        try {
            ctx = (Context)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.equals(ctx.key, ctx.transaction);
    }

    public boolean equals(Object obj, Object t) {
        return this.key.equals(obj) && this.transaction.equals(t);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String s = "Context [ reentrant = " + this.container.isReentrant() + "\n          entrance = " + this.entrance + "\n          status = " + this.status2String() + "\n          transaction = " + this.transaction + "\n          key = " + this.key;
        s = this.resources == null ? s + "\n          resources = null ]" : s + "\n          resources.isEmpty = " + this.resources.isEmpty() + " ]";
        return s;
    }

    protected String status2String() {
        switch (this.status) {
            case -1: {
                return "DISCARDED";
            }
            case 0: {
                return "UNSPECIFIED";
            }
            case 4: {
                return "SET_CONTEXT";
            }
            case 5: {
                return "PASSIVE";
            }
            case 6: {
                return "EJB";
            }
            case 7: {
                return "ACTIVE";
            }
            case 9: {
                return "REMOVED";
            }
        }
        return "Unknown status value!";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

